/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.resource;

import edu.stanford.smi.protege.resource.BlankIcon;
import edu.stanford.smi.protege.resource.ConfigureButtonIcon;
import edu.stanford.smi.protege.resource.HiddenIconFilter;
import edu.stanford.smi.protege.resource.ReadonlyIconFilter;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.UglyIcon;
import edu.stanford.smi.protege.util.ComponentUtilities;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class Icons {
    private static final Icon UGLY_ICON = new UglyIcon();
    private static Map _icons = new HashMap();
    private static final ImageFilter hiddenIconFilter = new HiddenIconFilter();
    private static final ImageFilter readonlyIconFilter = new ReadonlyIconFilter();

    public static Icon lookupIcon(ResourceKey resourceKey) {
        Icon icon = (Icon)_icons.get(resourceKey);
        if (icon == null || icon.getIconWidth() == -1) {
            String string = resourceKey.toString() + ".gif";
            icon = ComponentUtilities.loadImageIcon(Icons.class, "image/" + string);
            _icons.put(resourceKey, icon);
        }
        return icon;
    }

    public static Icon lookupActionIcon(ResourceKey resourceKey, boolean bl, boolean bl2) {
        if (bl2) {
            resourceKey = new ResourceKey(resourceKey.toString() + ".gray");
        }
        if (bl) {
            resourceKey = new ResourceKey(resourceKey.toString() + ".24");
        }
        return Icons.lookupIcon(resourceKey);
    }

    public static Icon getIcon(ResourceKey resourceKey) {
        Icon icon = Icons.lookupIcon(resourceKey);
        if (icon == null) {
            icon = UGLY_ICON;
        }
        return icon;
    }

    private static Icon getIcon(String string) {
        return Icons.getIcon(new ResourceKey(string));
    }

    private static Icon getActionIcon(ResourceKey resourceKey, boolean bl, boolean bl2) {
        Icon icon = Icons.lookupActionIcon(resourceKey, bl, bl2);
        if (icon == null) {
            icon = UGLY_ICON;
        }
        return icon;
    }

    private static Icon getObjectIcon(String string, boolean bl, boolean bl2) {
        Icon icon = bl2 ? Icons.getFilteredIcon(string, "hidden", hiddenIconFilter) : (bl ? Icons.getFilteredIcon(string, "readonly", readonlyIconFilter) : Icons.getIcon(string));
        return icon;
    }

    private static Icon getFilteredIcon(String string, String string2, ImageFilter imageFilter) {
        ResourceKey resourceKey = new ResourceKey(string + "." + string2);
        Icon icon = (Icon)_icons.get(resourceKey);
        if (icon == null) {
            ImageIcon imageIcon = (ImageIcon)Icons.getIcon(string);
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), imageFilter);
            icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
            _icons.put(resourceKey, icon);
        }
        return icon;
    }

    public static Icon getClsesIcon() {
        return Icons.getClsIcon();
    }

    public static Icon getSlotsIcon() {
        return Icons.getSlotIcon();
    }

    public static Icon getInstancesIcon() {
        return Icons.getInstanceIcon();
    }

    public static Icon getFacetsIcon() {
        return Icons.getFacetIcon();
    }

    public static Image getClsImage() {
        return Icons.getImage(Icons.getClsIcon());
    }

    public static Image getSlotImage() {
        return Icons.getImage(Icons.getSlotIcon());
    }

    public static Image getFacetImage() {
        return Icons.getImage(Icons.getFacetIcon());
    }

    public static Image getInstanceImage() {
        return Icons.getImage(Icons.getInstanceIcon());
    }

    private static Image getImage(Icon icon) {
        return ((ImageIcon)icon).getImage();
    }

    public static Icon getClsesAndInstancesIcon() {
        return Icons.getClsAndInstanceIcon();
    }

    public static Icon getHierarchyExpandedIcon() {
        return Icons.getIcon("hierarchy.expanded");
    }

    public static Icon getHierarchyCollapsedIcon() {
        return Icons.getIcon("hierarchy.collapsed");
    }

    public static Icon getConfigureIcon() {
        return new ConfigureButtonIcon();
    }

    public static Icon getLogo() {
        return Icons.getIcon("logo.banner");
    }

    public static Icon getAddClsIcon() {
        return Icons.getIcon(ResourceKey.CLASS_ADD);
    }

    public static Icon getAddInstanceIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_ADD);
    }

    public static Icon getAddSlotIcon() {
        return Icons.getIcon(ResourceKey.SLOT_ADD);
    }

    public static Icon getAddIcon() {
        return Icons.getIcon(ResourceKey.VALUE_ADD);
    }

    public static Icon getArchiveProjectIcon() {
        return Icons.getArchiveProjectIcon(false, false);
    }

    public static Icon getArchiveProjectIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.PROJECT_ARCHIVE, bl, bl2);
    }

    public static Icon getBackIcon() {
        return Icons.getIcon("back");
    }

    public static Icon getBlankIcon() {
        return new BlankIcon();
    }

    public static Icon getCancelIcon() {
        return Icons.getIcon(ResourceKey.CANCEL_BUTTON_LABEL);
    }

    public static Icon getCascadeWindowsIcon() {
        return Icons.getCascadeWindowsIcon(false, false);
    }

    public static Icon getCascadeWindowsIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.CASCADE_WINDOWS, bl, bl2);
    }

    public static Icon getCloseAllWindowsIcon() {
        return Icons.getCloseAllWindowsIcon(false, false);
    }

    public static Icon getCloseAllWindowsIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.CLOSE_ALL_WINDOWS, bl, bl2);
    }

    public static Icon getCloseIcon() {
        return Icons.getOkIcon();
    }

    public static Icon getClsAndInstanceIcon() {
        return Icons.getIcon("class.instance");
    }

    public static Icon getClsIcon() {
        return Icons.getClsIcon(false, false, false, false);
    }

    public static Icon getClsIcon(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = "class";
        if (bl) {
            string = string + ".metaclass";
        }
        if (bl2) {
            string = string + ".abstract";
        }
        return Icons.getObjectIcon(string, bl3, bl4);
    }

    public static Icon getInstanceCopyIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_COPY);
    }

    public static Icon getSlotHideNoteIcon() {
        return Icons.getIcon(ResourceKey.SLOT_NOTE_HIDE);
    }

    public static Icon getInstanceHideNoteIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_NOTE_HIDE);
    }

    public static Icon getClsHideNoteIcon() {
        return Icons.getIcon(ResourceKey.CLASS_NOTE_HIDE_ALL);
    }

    public static Icon getInstanceNoteIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_NOTE);
    }

    public static Icon getClsNoteIcon() {
        return Icons.getIcon(ResourceKey.CLASS_NOTE);
    }

    public static Icon getSlotNoteIcon() {
        return Icons.getIcon(ResourceKey.SLOT_NOTE);
    }

    public static Icon getCreateIcon() {
        return Icons.getIcon(ResourceKey.VALUE_CREATE);
    }

    public static Icon getCreateClsIcon() {
        return Icons.getIcon(ResourceKey.CLASS_CREATE);
    }

    public static Icon getCreateInstanceIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_CREATE);
    }

    public static Icon getCreateSlotIcon() {
        return Icons.getIcon(ResourceKey.SLOT_CREATE);
    }

    public static Icon getCreateClsNoteIcon() {
        return Icons.getIcon(ResourceKey.CLASS_NOTE_CREATE);
    }

    public static Icon getCreateInstanceNoteIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_NOTE_CREATE);
    }

    public static Icon getDeleteIcon() {
        return Icons.getIcon(ResourceKey.VALUE_DELETE);
    }

    public static Icon getDeleteClsIcon() {
        return Icons.getIcon(ResourceKey.CLASS_DELETE);
    }

    public static Icon getDeleteInstanceIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_DELETE);
    }

    public static Icon getDeleteSlotIcon() {
        return Icons.getIcon(ResourceKey.SLOT_DELETE);
    }

    public static Icon getDeleteClsNoteIcon() {
        return Icons.getIcon(ResourceKey.CLASS_NOTE_DELETE);
    }

    public static Icon getCreateSlotNoteIcon() {
        return Icons.getIcon(ResourceKey.SLOT_NOTE_CREATE);
    }

    public static Icon getDeleteSlotNoteIcon() {
        return Icons.getIcon(ResourceKey.SLOT_NOTE_DELETE);
    }

    public static Icon getDeleteInstanceNoteIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_NOTE_DELETE);
    }

    public static Icon getDownIcon() {
        return Icons.getIcon(ResourceKey.VALUE_MOVE_DOWN);
    }

    public static Icon getFacetIcon() {
        return Icons.getFacetIcon(false, false);
    }

    public static Icon getFacetIcon(boolean bl, boolean bl2) {
        return Icons.getObjectIcon("facet", bl, bl2);
    }

    public static Icon getFindIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_SEARCH_FOR);
    }

    public static Icon getFindClsIcon() {
        return Icons.getIcon(ResourceKey.CLASS_SEARCH_FOR);
    }

    public static Icon getFindInstanceIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_SEARCH_FOR);
    }

    public static Icon getFindFormIcon() {
        return Icons.getIcon(ResourceKey.FORM_SEARCH_FOR);
    }

    public static Icon getFindSlotIcon() {
        return Icons.getIcon(ResourceKey.SLOT_SEARCH_FOR);
    }

    public static Icon getFormIcon() {
        return Icons.getFormIcon(false);
    }

    public static Icon getFormIcon(boolean bl) {
        String string = "form";
        if (bl) {
            string = string + ".customized";
        }
        return Icons.getIcon(string);
    }

    public static Icon getForwardIcon() {
        return Icons.getIcon("forward");
    }

    public static Icon getHomeIcon() {
        return Icons.getIcon("home");
    }

    public static Icon getInstanceIcon() {
        return Icons.getInstanceIcon(false, false);
    }

    public static Icon getInstanceIcon(boolean bl, boolean bl2) {
        return Icons.getObjectIcon("instance", bl, bl2);
    }

    public static Icon getLayoutLikeOtherFormIcon() {
        return Icons.getIcon(ResourceKey.FORM_LAYOUT_LIKE);
    }

    public static Icon getLogoIcon() {
        return Icons.getIcon("logo16");
    }

    public static Icon getNewProjectIcon() {
        return Icons.getNewProjectIcon(false, false);
    }

    public static Icon getNewProjectIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.PROJECT_NEW, bl, bl2);
    }

    public static Icon getCutIcon() {
        return Icons.getCutIcon(false, false);
    }

    public static Icon getCutIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.CUT_ACTION, bl, bl2);
    }

    public static Icon getCopyIcon() {
        return Icons.getCopyIcon(false, false);
    }

    public static Icon getCopyIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.COPY_ACTION, bl, bl2);
    }

    public static Icon getPasteIcon() {
        return Icons.getPasteIcon(false, false);
    }

    public static Icon getPasteIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.PASTE_ACTION, bl, bl2);
    }

    public static Icon getClearIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.CLEAR_ACTION, bl, bl2);
    }

    public static Icon getNoIcon() {
        return Icons.getIcon(ResourceKey.NO_BUTTON_LABEL);
    }

    public static Icon getOkIcon() {
        return Icons.getIcon(ResourceKey.OK_BUTTON_LABEL);
    }

    public static Icon getOpenProjectIcon() {
        return Icons.getOpenProjectIcon(false, false);
    }

    public static Icon getOpenProjectIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.PROJECT_OPEN, bl, bl2);
    }

    public static Icon getProjectIcon() {
        return Icons.getIcon("project");
    }

    public static Icon getSelectProjectIcon() {
        return Icons.getIcon("project_select");
    }

    public static Icon getProjectIcon(boolean bl, boolean bl2) {
        return Icons.getObjectIcon("project", bl, bl2);
    }

    public static Icon getQueryIcon() {
        return Icons.getIcon("query");
    }

    public static Icon getCopyQueryIcon() {
        return Icons.getIcon("query.copy");
    }

    public static Icon getDeleteQueryIcon() {
        return Icons.getIcon("query.delete");
    }

    public static Icon getViewQueryIcon() {
        return Icons.getIcon("query.view");
    }

    public static Icon getAddQueryLibraryIcon() {
        return Icons.getIcon("query.library.add");
    }

    public static Icon getRetrieveQueryLibraryIcon() {
        return Icons.getIcon("query.library.retrieve");
    }

    public static Icon getRedoIcon() {
        return Icons.getRedoIcon(false, false);
    }

    public static Icon getRedoIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.REDO_ACTION, bl, bl2);
    }

    public static Icon getRelayoutIcon() {
        return Icons.getIcon(ResourceKey.FORM_RELAYOUT);
    }

    public static Icon getRemoveCustomizationsIcon() {
        return Icons.getIcon(ResourceKey.FORM_REMOVE_CUSTOMIZATIONS);
    }

    public static Icon getRemoveIcon() {
        return Icons.getIcon(ResourceKey.VALUE_REMOVE);
    }

    public static Icon getRemoveClsIcon() {
        return Icons.getIcon(ResourceKey.CLASS_REMOVE);
    }

    public static Icon getRemoveInstanceIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_REMOVE);
    }

    public static Icon getRemoveSlotIcon() {
        return Icons.getIcon(ResourceKey.SLOT_REMOVE);
    }

    public static Icon getRemoveSlotOverrideIcon() {
        return Icons.getIcon(ResourceKey.SLOT_REMOVE_FACET_OVERRIDES);
    }

    public static Icon getRevertProjectIcon() {
        return Icons.getRevertProjectIcon(false, false);
    }

    public static Icon getRevertProjectIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.PROJECT_REVERT, bl, bl2);
    }

    public static Icon getSaveProjectIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.PROJECT_SAVE, bl, bl2);
    }

    public static Icon getSaveProjectIcon() {
        return Icons.getSaveProjectIcon(false, false);
    }

    public static Icon getSlotIcon() {
        return Icons.getSlotIcon(false, false, false, false);
    }

    public static Icon getSlotIcon(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = "slot";
        if (bl) {
            string = string + ".inherited";
        }
        if (bl2) {
            string = string + ".overridden";
        }
        return Icons.getObjectIcon(string, bl3, bl4);
    }

    public static Icon getLogoSplashIcon() {
        return Icons.getIcon("logo.splash");
    }

    public static Icon getLogoBannerIcon() {
        return Icons.getIcon("logo.banner");
    }

    public static Icon getUglyIcon() {
        return UGLY_ICON;
    }

    public static Icon getUndoIcon(boolean bl, boolean bl2) {
        return Icons.getActionIcon(ResourceKey.UNDO_ACTION, bl, bl2);
    }

    public static Icon getUndoIcon() {
        return Icons.getUndoIcon(false, false);
    }

    public static Icon getUpIcon() {
        return Icons.getIcon(ResourceKey.VALUE_MOVE_UP);
    }

    public static Icon getViewIcon() {
        return Icons.getIcon(ResourceKey.VALUE_VIEW);
    }

    public static Icon getViewClsIcon() {
        return Icons.getIcon(ResourceKey.CLASS_VIEW);
    }

    public static Icon getViewInstanceIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_VIEW);
    }

    public static Icon getViewClsReferencersIcon() {
        return Icons.getIcon(ResourceKey.CLASS_VIEW_REFERENCES);
    }

    public static Icon getViewInstanceReferencersIcon() {
        return Icons.getIcon(ResourceKey.INSTANCE_VIEW_REFERENCES);
    }

    public static Icon getViewSlotAtClassIcon() {
        return Icons.getIcon(ResourceKey.SLOT_VIEW_FACET_OVERRIDES);
    }

    public static Icon getViewSlotIcon() {
        return Icons.getIcon(ResourceKey.SLOT_VIEW);
    }

    public static Icon getViewFormIcon() {
        return Icons.getIcon(ResourceKey.FORM_VIEW_CUSTOMIZATIONS);
    }

    public static Icon getYesIcon() {
        return Icons.getIcon(ResourceKey.YES_BUTTON_LABEL);
    }

    public static Icon getQueryExportIcon() {
        return Icons.getIcon("export");
    }

    public static Icon getExportIcon() {
        return Icons.getIcon(ResourceKey.PROJECT_EXPORT);
    }

    static {
        _icons.put(ResourceKey.COMPONENT_MENU, new ConfigureButtonIcon());
        _icons.put(ResourceKey.CLASS_ADD_SUPERCLASS, Icons.getAddClsIcon());
        _icons.put(ResourceKey.CLASS_REMOVE_SUPERCLASS, Icons.getRemoveClsIcon());
        _icons.put(ResourceKey.SLOT_ADD_SUPERSLOT, Icons.getAddSlotIcon());
        _icons.put(ResourceKey.SLOT_REMOVE_SUPERSLOT, Icons.getRemoveSlotIcon());
    }
}

