/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.rmi.Naming;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerPanel
extends JPanel
implements Validatable {
    private static String _lastPassword = null;
    private JTextField _usernameField = ComponentFactory.createTextField();
    private JTextField _passwordField;
    private JTextField _hostNameField;
    private RemoteServer _server;
    private RemoteSession _session;
    private static final String USER_NAME = ServerPanel.class.getName() + ".user_name";
    private static final String HOST_NAME = ServerPanel.class.getName() + ".host_name";

    public ServerPanel() {
        this._usernameField.setText(ApplicationProperties.getString(USER_NAME, "Guest"));
        this._passwordField = ComponentFactory.createPasswordField();
        if (_lastPassword != null) {
            this._passwordField.setText(_lastPassword);
        } else if (this._usernameField.getText().equals("Guest")) {
            this._passwordField.setText("guest");
        }
        this._hostNameField = ComponentFactory.createTextField();
        this._hostNameField.setText(ApplicationProperties.getString(HOST_NAME, "localhost"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(3, 0));
        jPanel.add(new LabeledComponent("Host Machine Name", this._hostNameField));
        jPanel.add(new LabeledComponent("User Name", this._usernameField));
        jPanel.add(new LabeledComponent("Password", this._passwordField));
        this.add((Component)jPanel, "North");
    }

    public boolean validateContents() {
        boolean bl = false;
        try {
            bl = this.isValidConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private boolean isValidConfiguration() {
        boolean bl = false;
        String string = this._hostNameField.getText();
        this._server = ServerPanel.connectToHost(string);
        if (this._server == null) {
            String string2 = LocalizedText.getText(ResourceKey.REMOTE_CONNECT_FAILED_DIALOG_TEXT);
            ModalDialog.showMessageDialog(this, string2);
        } else {
            String string3 = this._usernameField.getText();
            String string4 = this._passwordField.getText();
            this._session = this.createSession(string3, string4);
            if (this._session == null) {
                String string5 = LocalizedText.getText(ResourceKey.REMOTE_SESSION_CREATE_FAILED_DIALOG_TITLE);
                String string6 = LocalizedText.getText(ResourceKey.REMOTE_SESSION_CREATE_FAILED_DIALOG_TEXT);
                ModalDialog.showMessageDialog((Component)this, string6, string5);
            } else {
                bl = true;
            }
        }
        this.saveFields();
        return bl;
    }

    public void saveContents() {
    }

    private void saveFields() {
        ApplicationProperties.setString(USER_NAME, this._usernameField.getText());
        ApplicationProperties.setString(HOST_NAME, this._hostNameField.getText());
        _lastPassword = this._passwordField.getText();
    }

    public RemoteServer getServer() {
        return this._server;
    }

    public RemoteSession getSession() {
        return this._session;
    }

    private static RemoteServer connectToHost(String string) {
        RemoteServer remoteServer = null;
        try {
            remoteServer = (RemoteServer)Naming.lookup("//" + string + "/" + Server.getBoundName());
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return remoteServer;
    }

    private RemoteSession createSession(String string, String string2) {
        RemoteSession remoteSession = null;
        try {
            remoteSession = this._server.openSession(string, SystemUtilities.getMachineIpAddress(), string2);
        }
        catch (RemoteException remoteException) {
            Log.getLogger().severe(Log.toString(remoteException));
        }
        return remoteSession;
    }
}

