/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory2;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.plugin.ExportWizard;
import edu.stanford.smi.protege.plugin.ImportPlugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.plugin.ProjectPluginManager;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteProjectUtil;
import edu.stanford.smi.protege.storage.clips.ParseErrorPanel;
import edu.stanford.smi.protege.ui.ArchivePanel;
import edu.stanford.smi.protege.ui.ConfigureProjectPanel;
import edu.stanford.smi.protege.ui.FactoryRenderer;
import edu.stanford.smi.protege.ui.ProjectMenuBar;
import edu.stanford.smi.protege.ui.ProjectToolBar;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.RevertProjectPanel;
import edu.stanford.smi.protege.ui.ViewSelector;
import edu.stanford.smi.protege.ui.WindowComparator;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ArchiveManager;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.ModalDialogCloseDoubleClickAdapter;
import edu.stanford.smi.protege.util.ProjectChooser;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.widget.TextComponentWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ProjectManager {
    private static ProjectManager _projectManager = new ProjectManager();
    private ProjectPluginManager _projectPluginManager = new ProjectPluginManager();
    private Project _currentProject;
    private JRootPane _rootPane;
    private ProjectMenuBar _menuBar;
    private ProjectToolBar _mainToolBar;
    private ProjectView _projectView;
    private ViewSelector _viewSelector;
    private JPanel _headerPanel;
    private boolean _doExitVM = true;
    private JFrame _errorFrame;
    private JComponent _toolBarHolder;

    private ProjectManager() {
    }

    private static void advance(Point point) {
        point.x += 25;
        point.y += 25;
    }

    public void buildProjectRequest() {
        KnowledgeBaseFactory knowledgeBaseFactory;
        if (this.closeProjectRequest() && (knowledgeBaseFactory = this.promptForFactory()) != null) {
            this.importSources(knowledgeBaseFactory);
        }
    }

    public boolean buildProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        boolean bl = true;
        if (knowledgeBaseFactory != null) {
            bl = this.importSources(knowledgeBaseFactory);
        }
        return bl;
    }

    public void importProjectRequest(ImportPlugin importPlugin) {
        if (this.closeProjectRequest()) {
            this._currentProject = importPlugin.handleImportRequest();
            if (this._currentProject != null) {
                this.displayCurrentProject();
            }
        }
    }

    public void exportProjectRequest(ExportPlugin exportPlugin) {
        exportPlugin.handleExportRequest(this._currentProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importSources(KnowledgeBaseFactory knowledgeBaseFactory) {
        Project project;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        if (knowledgeBaseFactory != null && (bl = this.loadNewSources(project = Project.createBuildProject(knowledgeBaseFactory, arrayList), knowledgeBaseFactory, false))) {
            WaitCursor waitCursor = new WaitCursor(this._rootPane);
            try {
                project.createDomainKnowledgeBase(knowledgeBaseFactory, arrayList, true);
                this._currentProject = project;
                this._projectPluginManager.afterLoad(project);
                this.displayCurrentProject();
            }
            finally {
                waitCursor.hide();
            }
            this.displayErrors("Build Project Errors", arrayList);
        }
        return bl;
    }

    public void cascadeWindows(Point point, Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, new WindowComparator());
        for (Window window : arrayList) {
            window.setLocation(point);
            window.toFront();
            window.requestFocus();
            ProjectManager.advance(point);
        }
    }

    public void cascadeWindowsRequest() {
        Project project = this.getCurrentProject();
        if (project != null) {
            Point point = SwingUtilities.windowForComponent(this._rootPane).getLocation();
            point.x += 25;
            point.y += 110;
            this.cascadeWindows(point, project.getOpenWindows());
        }
    }

    public void changeProjectStorageFormatRequest() {
        if (this.hasLoadedProject()) {
            boolean bl;
            KnowledgeBaseFactory knowledgeBaseFactory = this._currentProject.getKnowledgeBase().getKnowledgeBaseFactory();
            KnowledgeBaseFactory knowledgeBaseFactory2 = this.promptForFactory();
            boolean bl2 = bl = knowledgeBaseFactory2 != null && knowledgeBaseFactory2 != knowledgeBaseFactory;
            if (bl) {
                bl = this.loadNewSources(this._currentProject, knowledgeBaseFactory2, true);
            }
            if (bl) {
                if (this._currentProject.hasCompleteSources()) {
                    if (bl) {
                        bl = this.prepareToSave(knowledgeBaseFactory, knowledgeBaseFactory2);
                    }
                    boolean bl3 = this._currentProject.isReadonly();
                    if (bl) {
                        this._currentProject.setIsReadonly(false);
                        bl = this.save();
                    }
                    if (bl) {
                        URI uRI = this._currentProject.getProjectURI();
                        this.closeCurrentProject();
                        this.loadProject(uRI);
                    } else {
                        this._currentProject.setIsReadonly(bl3);
                    }
                } else {
                    Log.getLogger().warning("Sources are not complete");
                }
            }
        }
    }

    public boolean closeProjectRequest() {
        boolean bl = true;
        if (this.hasLoadedProject()) {
            ProjectManager.commitChanges();
            if (this._currentProject.isDirty()) {
                bl = this.confirmSave();
            }
            if (bl) {
                bl = this.closeCurrentProject();
            }
        }
        return bl;
    }

    private boolean closeCurrentProject() {
        ProjectView projectView = this.getCurrentProjectView();
        if (projectView == null) {
            return true;
        }
        boolean bl = projectView.canClose();
        if (bl) {
            this._projectPluginManager.beforeHide(this._projectView, this._mainToolBar, this._menuBar);
            this._projectView.setVisible(false);
            this._projectView.close();
            ComponentUtilities.closeAllWindows();
            this._rootPane.getContentPane().remove(this._projectView);
            ComponentUtilities.dispose(this._projectView);
            this._projectView = null;
            this._viewSelector = null;
            this._projectPluginManager.beforeClose(this._currentProject);
            this._currentProject.dispose();
            this._currentProject = null;
            this.updateFrameTitle();
            this.createMenuAndToolBar();
            this._rootPane.revalidate();
            this._rootPane.repaint();
        }
        return bl;
    }

    public void configureProjectRequest() {
        String string;
        ConfigureProjectPanel configureProjectPanel;
        int n;
        Project project = this.getCurrentProject();
        boolean bl = project.getDisplayHiddenClasses();
        boolean bl2 = project.getTabbedInstanceFormLayout();
        if (project != null && (n = ModalDialog.showDialog(this._rootPane, configureProjectPanel = new ConfigureProjectPanel(project), string = "Configure " + project.getProjectURI(), 11)) == 1) {
            boolean bl3 = bl != project.getDisplayHiddenClasses() || bl2 != project.getTabbedInstanceFormLayout();
            this.reloadUI(bl3);
        }
    }

    private boolean confirmSave() {
        boolean bl;
        JLabel jLabel = ComponentFactory.createLabel("Do you want to save changes to the current project?");
        int n = ModalDialog.showDialog(this._rootPane, jLabel, "Save?", 12);
        switch (n) {
            case 2: {
                bl = this.saveProjectRequest();
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: 
            case 5: {
                bl = false;
                break;
            }
            default: {
                Assert.fail("bad result: " + n);
                bl = false;
            }
        }
        return bl;
    }

    private void displayCurrentProject() {
        this.displayCurrentProject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayCurrentProject(boolean bl) {
        WaitCursor waitCursor = new WaitCursor(this._rootPane);
        try {
            this.createMenuAndToolBar();
            this._projectView = new ProjectView(this._currentProject);
            if (bl) {
                RemoteProjectUtil.configure(this._projectView);
            }
            this.addViewSelector(this._projectView);
            this._rootPane.getContentPane().add((Component)this._projectView, "Center");
            this._projectView.revalidate();
            this._projectView.repaint();
            this._projectPluginManager.afterShow(this._projectView, this._mainToolBar, this._menuBar);
            this._rootPane.revalidate();
        }
        finally {
            waitCursor.hide();
        }
        this.updateFrameTitle();
    }

    public JMenuBar getCurrentProjectMenuBar() {
        return this._menuBar;
    }

    public JToolBar getCurrentProjectToolBar() {
        return this.getCurrentProjectMainToolBar();
    }

    public JToolBar getCurrentProjectMainToolBar() {
        return this._mainToolBar;
    }

    public void displayErrors(String string, Collection collection) {
        if (!collection.isEmpty()) {
            ParseErrorPanel parseErrorPanel = new ParseErrorPanel(collection);
            this._errorFrame = ComponentFactory.showInFrame(parseErrorPanel, string);
            this.bringErrorFrameToFront();
        }
    }

    public void bringErrorFrameToFront() {
        if (this._errorFrame != null && this._errorFrame.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectManager.this._errorFrame.toFront();
                }
            });
        }
    }

    public void exitApplicationRequest() {
        boolean bl = this.closeProjectRequest();
        if (bl) {
            Frame frame = ComponentUtilities.getFrame(this._rootPane);
            ApplicationProperties.recordMainFrameProperties(frame);
            ApplicationProperties.flush();
            ComponentUtilities.dispose(frame);
            if (this._doExitVM) {
                SystemUtilities.exit();
            }
        }
    }

    public Project getCurrentProject() {
        return this._currentProject;
    }

    public ProjectView getCurrentProjectView() {
        return this._projectView;
    }

    public JComponent getMainPanel() {
        return this._rootPane;
    }

    public static ProjectManager getProjectManager() {
        return _projectManager;
    }

    private static Project getRequestedProject(Component component) {
        Project project = null;
        ProjectChooser projectChooser = new ProjectChooser();
        int n = projectChooser.showOpenDialog(component);
        if (n == 0) {
            project = projectChooser.getProject();
        }
        return project;
    }

    private boolean hasLoadedProject() {
        return this._currentProject != null && this._currentProject.getProjectInstance() != null && this._currentProject.getKnowledgeBase() != null;
    }

    public void changeIncludedProjectURIsRequest(Collection collection) {
        if (this.canChangeIncludedProjectURIs(collection)) {
            this._currentProject.setDirectIncludedProjectURIs(collection);
            boolean bl = this.saveProjectRequest();
            if (bl) {
                this.reload();
            }
        }
    }

    public void setActiveProjectURI(URI uRI) {
        this._currentProject.setActiveRootURI(uRI);
        this.reloadUI(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        URI uRI = this.getCurrentProject().getProjectURI();
        WaitCursor waitCursor = new WaitCursor(this._rootPane);
        try {
            this.closeProjectRequest();
            this.loadProject(uRI);
        }
        finally {
            waitCursor.hide();
        }
    }

    private boolean canChangeIncludedProjectURIs(Collection collection) {
        boolean bl;
        HashSet hashSet;
        Project project = this.getCurrentProject();
        boolean bl2 = project.getProjectURI() == null;
        HashSet<URI> hashSet2 = new HashSet<URI>(project.getDirectIncludedProjectURIs());
        if (CollectionUtilities.equalsSet(hashSet2, hashSet = new HashSet(collection))) {
            bl = false;
        } else {
            int n;
            String string = "Changing the included projects will cause the current project to\nbe saved and reloaded. ";
            if (bl2) {
                string = string + "You will need to first specify a name for your project.";
            }
            bl = (n = ModalDialog.showMessageDialog((Component)this._rootPane, string, 11)) == 1;
        }
        return bl;
    }

    private boolean loadNewSources(Project project, KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        if (knowledgeBaseFactory == null) {
            knowledgeBaseFactory = project.getKnowledgeBaseFactory();
        }
        PropertyList propertyList = project.getSources();
        URI uRI = project.getProjectURI();
        String string = uRI == null ? null : uRI.toString();
        KnowledgeBaseSourcesEditor knowledgeBaseSourcesEditor = knowledgeBaseFactory.createKnowledgeBaseSourcesEditor(string, propertyList);
        knowledgeBaseSourcesEditor.setShowProject(bl);
        String string2 = knowledgeBaseFactory.getDescription();
        int n = ModalDialog.showDialog(this._rootPane, knowledgeBaseSourcesEditor, string2, 11);
        if (n == 1) {
            propertyList.setString("factory_class_name", knowledgeBaseFactory.getClass().getName());
            project.setProjectURI(URIUtilities.createURI(knowledgeBaseSourcesEditor.getProjectPath()));
            for (URI uRI2 : knowledgeBaseSourcesEditor.getIncludedProjects()) {
                project.includeProject(uRI2, false, null);
            }
        }
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject(URI uRI) {
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        WaitCursor waitCursor = new WaitCursor(this._rootPane);
        try {
            if (uRI == null) {
                KnowledgeBaseFactory knowledgeBaseFactory = this.promptForFactory();
                l = System.currentTimeMillis();
                if (knowledgeBaseFactory != null) {
                    this._currentProject = this.createNewProject(knowledgeBaseFactory, arrayList);
                }
            } else {
                this._currentProject = this.loadProjectFromURI(uRI, arrayList);
            }
        }
        finally {
            waitCursor.hide();
        }
        long l2 = System.currentTimeMillis();
        if (this._currentProject.getProjectInstance() == null) {
            String string = "Unable to load file: " + uRI + "\nPossible reasons:\n- The file has an unsupported file format\n- The file is not well-formed\n- The project file is corrupt";
            Log.getLogger().severe(string);
            arrayList.add(string);
            JOptionPane.showMessageDialog(this.getMainPanel(), string, "Invalid file", 2);
        }
        this.displayErrors("Load Project Errors", arrayList);
        if (this._currentProject != null && this._currentProject.getProjectInstance() != null && this._currentProject.getKnowledgeBase() != null) {
            this.displayCurrentProject();
            this.printLoadTimes(l, l2);
        }
    }

    private Project createNewProject(KnowledgeBaseFactory knowledgeBaseFactory, Collection collection) {
        Project project = Project.createNewProject(knowledgeBaseFactory, collection);
        this._projectPluginManager.afterCreate(project);
        return project;
    }

    public Project loadProjectFromURI(URI uRI, Collection collection) {
        Project project = null;
        try {
            project = Project.loadProjectFromURI(uRI, collection);
            this._projectPluginManager.afterLoad(project);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.FINE, "Error loading project", exception);
            collection.add(exception);
        }
        return project;
    }

    public void loadProject(URI uRI, KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList arrayList = new ArrayList();
        long l = System.currentTimeMillis();
        long l2 = 0L;
        if (knowledgeBaseFactory != null) {
            this._currentProject = uRI == null ? this.createNewProject(knowledgeBaseFactory, arrayList) : this.loadProjectFromURI(uRI, arrayList);
            l2 = System.currentTimeMillis();
        }
        if (this._currentProject != null) {
            this.displayErrors("Load Project Errors", arrayList);
            this.displayCurrentProject();
            this.printLoadTimes(l, l2);
        }
    }

    public void mergeIncludedProjectsRequest() {
        if (this.hasLoadedProject() && this._currentProject.hasIncludedProjects()) {
            String string = "This action will make all included frames in the knowledge base direct members  of the current project.";
            JComponent jComponent = ProjectManager.getProjectManager().getMainPanel();
            int n = ModalDialog.showMessageDialog((Component)jComponent, string, 11);
            if (n == 1) {
                this._currentProject.mergeIncludedProjects();
            }
        }
    }

    public boolean createNewProjectRequest() {
        CreateProjectWizard createProjectWizard;
        int n;
        boolean bl = false;
        if (this.closeProjectRequest() && (n = (createProjectWizard = new CreateProjectWizard(this.getMainPanel())).execute()) == 1) {
            this._currentProject = createProjectWizard.getProject();
            ProjectManager.getProjectManager().displayCurrentProject();
            bl = true;
        }
        return bl;
    }

    public void saveToFormatRequest() {
        Project project;
        ExportWizard exportWizard;
        int n;
        if (this.hasLoadedProject() && (n = (exportWizard = new ExportWizard(this.getMainPanel(), this._currentProject)).execute()) == 1 && (project = exportWizard.getNewProject()) != null) {
            this.closeCurrentProject();
            this._currentProject = project;
            this._projectPluginManager.afterCreate(project);
            ProjectManager.getProjectManager().displayCurrentProject();
        }
    }

    public void newProjectRequest() {
        if (this.closeProjectRequest()) {
            this.loadProject(null);
        }
    }

    public void openProjectRequest() {
        this.openProjectRequest(this._rootPane);
    }

    public boolean openProjectRequest(Component component) {
        if (this.closeProjectRequest()) {
            this._currentProject = ProjectManager.getRequestedProject(component);
            if (this._currentProject != null && this._currentProject.getProjectInstance() != null && this._currentProject.getKnowledgeBase() != null) {
                ApplicationProperties.addProjectToMRUList(this._currentProject.getProjectURI());
                long l = System.currentTimeMillis();
                this._projectPluginManager.afterLoad(this._currentProject);
                this.displayCurrentProject();
                ProjectManager.printDisplayTime(l);
            }
            this.bringErrorFrameToFront();
        }
        return this._currentProject != null;
    }

    public void setCurrentProject(Project project) {
        this.setCurrentProject(project, true);
    }

    public void setCurrentProject(Project project, boolean bl) {
        if (this.closeProjectRequest()) {
            this._currentProject = project;
            if (this._currentProject != null) {
                this._projectPluginManager.afterLoad(this._currentProject);
                this.displayCurrentProject(bl);
            }
        }
    }

    private static void printDisplayTime(final long l) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                long l2 = System.currentTimeMillis();
                Log.getLogger().info("UI display time = " + (l2 - l) / 1000L + " sec");
            }
        });
    }

    private static Project getRequestedRemoteProject() {
        return RemoteProjectManager.getInstance().getRemoteProject();
    }

    public void openRemoteProjectRequest() {
        if (this.closeProjectRequest()) {
            long l = System.currentTimeMillis();
            this._currentProject = ProjectManager.getRequestedRemoteProject();
            long l2 = System.currentTimeMillis();
            if (this._currentProject != null) {
                this._projectPluginManager.afterLoad(this._currentProject);
                this.displayCurrentProject(true);
                this.printLoadTimes(l, l2);
            }
        }
    }

    private void printLoadTimes(final long l, final long l2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                long l3 = System.currentTimeMillis();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Load time for ");
                stringBuffer.append(URIUtilities.getDisplayText(ProjectManager.this._currentProject.getProjectURI()));
                stringBuffer.append(" = ");
                stringBuffer.append((l2 - l) / 1000L);
                stringBuffer.append(" sec (project) + ");
                stringBuffer.append((l3 - l2) / 1000L);
                stringBuffer.append(" sec (ui)");
                Log.getLogger().info(stringBuffer.toString());
            }
        });
    }

    private KnowledgeBaseFactory promptForFactory() {
        FactoryPanel factoryPanel = new FactoryPanel();
        int n = ModalDialog.showDialog(this._rootPane, factoryPanel, "Select Format", 11);
        return n == 1 ? factoryPanel.getSelectedFactory() : null;
    }

    public void reloadUI(boolean bl) {
        ProjectView projectView = this.getCurrentProjectView();
        if (projectView != null) {
            projectView.reload(bl);
        }
        if (this._viewSelector != null) {
            this._viewSelector.reload();
        }
        this._menuBar.updateUI();
        Application.repaint();
    }

    private static void commitChanges() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        TextComponentWidget textComponentWidget = (TextComponentWidget)SwingUtilities.getAncestorOfClass(TextComponentWidget.class, component);
        if (textComponentWidget != null) {
            textComponentWidget.commitChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save() {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        ProjectManager.commitChanges();
        boolean bl = this.getCurrentProjectView().attemptSave();
        if (bl) {
            this._projectPluginManager.beforeSave(this._currentProject);
            WaitCursor waitCursor = new WaitCursor(this._rootPane);
            try {
                this._currentProject.save(arrayList);
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
            finally {
                this._projectPluginManager.afterSave(this._currentProject);
                waitCursor.hide();
            }
            this.displayErrors("Save Project Errors", arrayList);
        }
        return bl && arrayList.isEmpty();
    }

    public boolean saveProjectAsRequest() {
        return this.saveProjectAsRequest(null);
    }

    public boolean saveProjectAsRequest(KnowledgeBaseFactory knowledgeBaseFactory) {
        boolean bl = true;
        if (this.hasLoadedProject() && (bl = this.loadNewSources(this._currentProject, knowledgeBaseFactory, true))) {
            if (this._currentProject.hasCompleteSources()) {
                bl = this.save();
                if (bl) {
                    this.updateFrameTitle();
                    ApplicationProperties.addProjectToMRUList(this._currentProject.getProjectURI());
                }
            } else {
                Log.getLogger().warning("Sources are not complete");
            }
        }
        return bl;
    }

    private boolean prepareToSave(KnowledgeBaseFactory knowledgeBaseFactory, KnowledgeBaseFactory knowledgeBaseFactory2) {
        boolean bl = true;
        if (knowledgeBaseFactory2 != null && knowledgeBaseFactory2 != knowledgeBaseFactory && knowledgeBaseFactory instanceof KnowledgeBaseFactory2) {
            KnowledgeBaseFactory2 knowledgeBaseFactory22 = (KnowledgeBaseFactory2)knowledgeBaseFactory;
            ArrayList arrayList = new ArrayList();
            KnowledgeBase knowledgeBase = this._currentProject.getKnowledgeBase();
            knowledgeBaseFactory22.prepareToSaveInFormat(knowledgeBase, knowledgeBaseFactory2, arrayList);
            bl = arrayList.isEmpty();
        }
        return bl;
    }

    public boolean saveProjectRequest() {
        boolean bl = true;
        if (this.hasLoadedProject()) {
            bl = this._currentProject.hasCompleteSources() ? this.save() : this.saveProjectAsRequest(this._currentProject.getKnowledgeBaseFactory());
        }
        return bl;
    }

    public void setLookAndFeel(String string) {
        try {
            SystemUtilities.setLookAndFeel(string);
            ApplicationProperties.setLookAndFeel(string);
            this.updateUI();
        }
        catch (Exception exception) {
            Log.getLogger().warning(exception.toString());
        }
    }

    public void setRootPane(JRootPane jRootPane) {
        this._rootPane = jRootPane;
        this.setupRootPane();
    }

    private void setupRootPane() {
        this.createMenuAndToolBar();
        this.updateFrameTitle();
    }

    private void createMenuAndToolBar() {
        Container container = this._rootPane.getContentPane();
        container.setLayout(new BorderLayout());
        if (this._headerPanel != null) {
            container.remove(this._headerPanel);
        }
        this._headerPanel = new JPanel(new BorderLayout());
        this._headerPanel.setBackground(Color.WHITE);
        this._mainToolBar = new ProjectToolBar();
        Box box = Box.createHorizontalBox();
        box.setOpaque(false);
        box.add(this._mainToolBar);
        this._headerPanel.add((Component)box, "West");
        this._menuBar = new ProjectMenuBar();
        JLabel jLabel = ComponentFactory.createLabel(Icons.getLogo());
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this._headerPanel.add((Component)jLabel, "East");
        this._toolBarHolder = Box.createHorizontalBox();
        this._toolBarHolder.setOpaque(false);
        this._headerPanel.add((Component)this._toolBarHolder, "South");
        this._rootPane.setJMenuBar(this._menuBar);
        container.add((Component)this._headerPanel, "North");
    }

    private void addViewSelector(ProjectView projectView) {
        if (SystemUtilities.showAlphaFeatures()) {
            this._viewSelector = new ViewSelector(projectView);
            this._headerPanel.add((Component)this._viewSelector, "Center");
        }
    }

    public void addUserToolBar(JToolBar jToolBar) {
        this._toolBarHolder.add(jToolBar);
        this._toolBarHolder.revalidate();
    }

    public void removeUserToolBar(JToolBar jToolBar) {
        this._toolBarHolder.remove(jToolBar);
        this._toolBarHolder.revalidate();
    }

    public JToolBar getUserToolBar(String string) {
        JToolBar jToolBar = null;
        Component[] componentArray = this._toolBarHolder.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.getName().equals(string)) continue;
            jToolBar = (JToolBar)component;
            break;
        }
        return jToolBar;
    }

    public String toString() {
        return "ProjectManager";
    }

    private void updateFrameTitle() {
        String string;
        String string2 = Text.getProgramNameAndVersion();
        if (this._currentProject == null) {
            string = string2;
        } else {
            URI uRI = this._currentProject.getProjectURI();
            if (uRI == null) {
                string = "<new>  " + string2;
            } else {
                String string3 = URIUtilities.getBaseName(uRI);
                String string4 = URIUtilities.getDisplayText(uRI);
                KnowledgeBaseFactory knowledgeBaseFactory = this._currentProject.getKnowledgeBaseFactory();
                String string5 = "";
                if (knowledgeBaseFactory != null) {
                    string5 = ", " + knowledgeBaseFactory.getDescription();
                }
                string = string3 + "  " + string2 + "    (" + string4 + string5 + ")";
            }
        }
        ComponentUtilities.setFrameTitle(this._rootPane, string);
    }

    public void updateLookAndFeel(Collection collection) {
        for (Window window : collection) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public void updateUI() {
        Window window = SwingUtilities.getWindowAncestor(this._rootPane);
        SwingUtilities.updateComponentTreeUI(window);
        this.reloadUI(true);
    }

    public void setExitVMOnApplicationExit(boolean bl) {
        this._doExitVM = bl;
    }

    public void requestRevertProject() {
        if (this._currentProject != null) {
            RevertProjectPanel revertProjectPanel = new RevertProjectPanel(this._currentProject);
            int n = ModalDialog.showDialog(this.getMainPanel(), revertProjectPanel, "Revert to Archived Version", 11);
            Date date = revertProjectPanel.getSelectedTimestamp();
            if (n == 1 && date != null) {
                Project project;
                ArchiveManager archiveManager = ArchiveManager.getArchiveManager();
                boolean bl = revertProjectPanel.getArchiveCurrentVersion();
                if (bl) {
                    archiveManager.archive(this._currentProject, "Automatic archive before revert");
                }
                if ((project = archiveManager.revertToVersion(this._currentProject, date)) != null) {
                    this.closeCurrentProject();
                    this._currentProject = project;
                    this.displayCurrentProject();
                }
            }
        }
    }

    public void archiveProjectRequest() {
        if (this._currentProject != null) {
            if (ArchivePanel.displayPanel()) {
                ArchivePanel archivePanel = new ArchivePanel();
                int n = ModalDialog.showDialog(this._rootPane, archivePanel, "Archive Project", 11);
                if (n == 1) {
                    String string = archivePanel.getComment();
                    this.archive(string);
                }
            } else {
                this.archive(null);
            }
        }
    }

    private void archive(String string) {
        ArchiveManager archiveManager = ArchiveManager.getArchiveManager();
        archiveManager.archive(this._currentProject, string);
    }

    private static class FactoryPanel
    extends JPanel {
        private JList _list = ComponentFactory.createList(null);

        FactoryPanel() {
            this._list.addMouseListener(new ModalDialogCloseDoubleClickAdapter());
            this._list.setCellRenderer(new FactoryRenderer());
            ComponentUtilities.setListValues(this._list, PluginUtilities.getAvailableFactories());
            this._list.setSelectedIndex(0);
            this.setLayout(new BorderLayout());
            this.add(ComponentFactory.createScrollPane(this._list));
            this.setPreferredSize(new Dimension(300, 100));
        }

        public KnowledgeBaseFactory getSelectedFactory() {
            return (KnowledgeBaseFactory)this._list.getSelectedValue();
        }
    }
}

