/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.TablePopupMenuMouseListener;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class AbstractTableWidget
extends AbstractSlotWidget {
    private JTable _table;
    private LabeledComponent _labeledComponent;

    protected AbstractTableWidget() {
        this.setPreferredColumns(2);
        this.setPreferredRows(4);
    }

    public void addButton(Action action) {
        this.addButton(action, true);
    }

    public void addButton(Action action, boolean bl) {
        this.addButtonConfiguration(action, bl);
        if (this.displayButton(action)) {
            this._labeledComponent.addHeaderButton(action);
        }
    }

    protected boolean hasButton(Icon icon) {
        return this._labeledComponent.hasHeaderButton(icon);
    }

    public void addColumn(int n, ResourceKey resourceKey, TableCellRenderer tableCellRenderer) {
        TableColumn tableColumn = new TableColumn(0, n, tableCellRenderer, null);
        String string = LocalizedText.getText(resourceKey);
        tableColumn.setHeaderValue(string);
        this._table.addColumn(tableColumn);
    }

    protected void configureTable(JTable jTable) {
        jTable.setModel(this.createTableModel());
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListenerAdapter(this));
        jTable.addMouseListener(new TablePopupMenuMouseListener(jTable){

            public JPopupMenu getPopupMenu() {
                return AbstractTableWidget.this.getPopupMenu();
            }
        });
    }

    public JComponent createMainComponent(Action action) {
        JScrollPane jScrollPane = ComponentFactory.createScrollPane(this.createTable(action));
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addMouseListener(new PopupMenuMouseListener(jViewport){

            public JPopupMenu getPopupMenu() {
                return AbstractTableWidget.this.getPopupMenu();
            }

            public void setSelection(JComponent jComponent, int n, int n2) {
            }
        });
        this._labeledComponent = new LabeledComponent(this.getLabel(), jScrollPane);
        return this._labeledComponent;
    }

    protected JTable createTable(Action action) {
        this._table = ComponentFactory.createSelectableTable(action);
        this.configureTable(this._table);
        return this._table;
    }

    public abstract TableModel createTableModel();

    public JPopupMenu getPopupMenu() {
        return null;
    }

    private static int getRow(TableModel tableModel, Object object) {
        int n = -1;
        int n2 = tableModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (!tableModel.getValueAt(i, 0).equals(object)) continue;
            n = i;
            break;
        }
        return n;
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._table);
    }

    private Collection getSelections() {
        TableModel tableModel = this._table.getModel();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = this._table.getSelectedRows();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(tableModel.getValueAt(nArray[i], 0));
            }
        }
        return arrayList;
    }

    public JTable getTable() {
        return this._table;
    }

    public void initialize() {
        this.initialize(null);
    }

    public void initialize(Action action) {
        this.add(this.createMainComponent(action));
        this.reload();
    }

    public void reload() {
        Collection collection = this.getSelections();
        this._table.setModel(this.createTableModel());
        this.setSelections(collection);
        this._table.revalidate();
        this._table.repaint();
        this._table.setAutoResizeMode(3);
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this.reload();
    }

    private void setSelections(Collection collection) {
        TableModel tableModel = this._table.getModel();
        this._table.clearSelection();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n = AbstractTableWidget.getRow(tableModel, iterator.next());
            if (n == -1) continue;
            this._table.addRowSelectionInterval(n, n);
        }
    }
}

