/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class CreateSlotCommand
extends AbstractCommand {
    private FrameID id;
    private String name;
    private Collection types;
    private Collection superslots;
    private boolean loadDefaults;
    private Slot createdSlot;

    CreateSlotCommand(FrameStore frameStore, FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        super(frameStore);
        this.id = frameID;
        this.name = string;
        this.loadDefaults = bl;
        this.types = new ArrayList(collection);
        this.superslots = new ArrayList(collection2);
    }

    public Object doIt() {
        this.createdSlot = this.getDelegate().createSlot(this.id, this.name, this.types, this.superslots, this.loadDefaults);
        this.id = this.createdSlot.getFrameID();
        this.name = this.getDelegate().getFrameName(this.createdSlot);
        this.setDescription("Create slot " + CreateSlotCommand.getText(this.createdSlot));
        return this.createdSlot;
    }

    public void undoIt() {
        this.getDelegate().deleteSlot(this.createdSlot);
        this.createdSlot.markDeleted(true);
    }

    public void redoIt() {
        this.getDelegate().createSlot(this.id, this.name, this.types, this.superslots, this.loadDefaults);
        this.createdSlot.markDeleted(false);
    }
}

