/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.ui.CharsetRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EncodingsPanel
extends JPanel {
    private JComboBox readEncodingComboBox;

    public EncodingsPanel() {
        super(new BorderLayout());
        this.add((Component)this.createEncodingsPanel(), "Center");
        this.add((Component)EncodingsPanel.createLocalePanel(), "South");
    }

    private JComponent createEncodingsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Encodings"));
        jPanel.add(EncodingsPanel.createCurrentEncoding());
        jPanel.add(this.createReadEncodingOverride());
        return jPanel;
    }

    private static JComponent createCurrentEncoding() {
        JTextField jTextField = ComponentFactory.createTextField();
        jTextField.setEnabled(false);
        jTextField.setText(SystemUtilities.getFileEncoding());
        return new LabeledComponent("Default", jTextField);
    }

    private JComponent createReadEncodingOverride() {
        this.readEncodingComboBox = ComponentFactory.createComboBox();
        this.readEncodingComboBox.setModel(EncodingsPanel.getEncodingModel());
        this.readEncodingComboBox.setSelectedItem(EncodingsPanel.getCurrentReadEncodingOverride());
        this.readEncodingComboBox.setRenderer(new CharsetRenderer());
        return new LabeledComponent("Read Override", this.readEncodingComboBox);
    }

    private static String getCurrentReadEncodingOverride() {
        String string = FileUtilities.getReadEncodingOverride();
        if (string != null) {
            Charset charset = Charset.forName(string);
            string = charset.name();
        }
        return string;
    }

    private static ComboBoxModel getEncodingModel() {
        Set<String> set = Charset.availableCharsets().keySet();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(set.toArray());
        defaultComboBoxModel.insertElementAt(null, 0);
        return defaultComboBoxModel;
    }

    private static JComponent createLocalePanel() {
        JTextField jTextField = ComponentFactory.createTextField();
        jTextField.setEnabled(false);
        String string = Locale.getDefault().getDisplayName(Locale.ENGLISH);
        jTextField.setText(string);
        return new LabeledComponent("Locale", jTextField);
    }

    public void commitChanges() {
        String string = (String)this.readEncodingComboBox.getSelectedItem();
        FileUtilities.setReadEncodingOverride(string);
    }
}

