/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.LocaleComparator;
import edu.stanford.smi.protege.ui.LocaleRenderer;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PreferencesPanel
extends Box
implements Validatable {
    private JTextField userNameField;
    private JRadioButton useLoginUserNameButton;
    private JRadioButton useSpecifiedUserNameButton;
    private JRadioButton protegeDefaultLocaleButton;
    private JRadioButton systemDefaultLocaleButton;
    private JRadioButton otherLocaleButton;
    private JComboBox localeComboBox;
    private JCheckBox showWelcomeDialogCheckBox;
    private JCheckBox prettyPrintLabelsCheckBox;

    public PreferencesPanel() {
        super(1);
        this.add(this.createShowWelcomeDialogCheckBox());
        this.add(this.createPrettyPrintLabelsCheckBox());
        this.add(this.createUsernamePanel());
        this.add(this.createLocalePanel());
    }

    private JComponent createUsernamePanel() {
        String string = ApplicationProperties.getUserName();
        String string2 = SystemUtilities.getUserName();
        this.userNameField = ComponentFactory.createTextField();
        this.userNameField.setColumns(15);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder("User Name"));
        this.useLoginUserNameButton = new JRadioButton("Use Login Name: " + string2);
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        StandardAction standardAction = new StandardAction("Use Specified Name: "){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PreferencesPanel.this.useSpecifiedUserNameButton.isSelected()) {
                    PreferencesPanel.this.userNameField.setEnabled(true);
                } else {
                    PreferencesPanel.this.userNameField.setText(null);
                    PreferencesPanel.this.userNameField.setEnabled(false);
                }
            }
        };
        this.useSpecifiedUserNameButton = new JRadioButton(standardAction);
        box2.add((Component)this.useSpecifiedUserNameButton, "West");
        box2.add((Component)this.userNameField, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useSpecifiedUserNameButton);
        buttonGroup.add(this.useLoginUserNameButton);
        if (string == null || string.length() == 0 || string2.equals(string)) {
            this.useLoginUserNameButton.setSelected(true);
        } else {
            this.useSpecifiedUserNameButton.setSelected(true);
            this.userNameField.setText(string);
        }
        box.add(this.useLoginUserNameButton);
        box.add(box2);
        return box;
    }

    private JComponent createLocalePanel() {
        Box box = Box.createVerticalBox();
        Locale locale = ApplicationProperties.getLocale();
        Locale locale2 = SystemUtilities.getSystemLocale();
        Locale locale3 = SystemUtilities.getProtegeSystemDefaultLocale();
        box.setBorder(BorderFactory.createTitledBorder("Locale"));
        this.protegeDefaultLocaleButton = new JRadioButton(Text.getProgramName() + " Default:   " + locale3.getDisplayName());
        this.systemDefaultLocaleButton = new JRadioButton("System Default:   " + locale2.getDisplayName());
        this.otherLocaleButton = new JRadioButton("Other:   ");
        this.localeComboBox = ComponentFactory.createComboBox();
        this.localeComboBox.setModel(new DefaultComboBoxModel<Locale>(PreferencesPanel.getSortedLocales()));
        this.localeComboBox.setRenderer(new LocaleRenderer());
        this.localeComboBox.setEnabled(false);
        if (locale.equals(locale3)) {
            this.protegeDefaultLocaleButton.setSelected(true);
        } else if (locale.equals(locale2)) {
            this.systemDefaultLocaleButton.setSelected(true);
        } else {
            this.otherLocaleButton.setSelected(true);
            this.localeComboBox.setSelectedItem(locale);
            this.localeComboBox.setEnabled(true);
        }
        if (locale2.equals(locale3)) {
            this.systemDefaultLocaleButton.setEnabled(false);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPanel.this.localeComboBox.setEnabled(PreferencesPanel.this.otherLocaleButton.isSelected());
            }
        };
        this.protegeDefaultLocaleButton.addActionListener(actionListener);
        this.systemDefaultLocaleButton.addActionListener(actionListener);
        this.otherLocaleButton.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.protegeDefaultLocaleButton);
        buttonGroup.add(this.systemDefaultLocaleButton);
        buttonGroup.add(this.otherLocaleButton);
        Box box2 = Box.createHorizontalBox();
        box2.add(this.otherLocaleButton);
        box2.add(this.localeComboBox);
        box2.setAlignmentX(0.0f);
        box.add(this.protegeDefaultLocaleButton);
        box.add(this.systemDefaultLocaleButton);
        box.add(box2);
        box.setVisible(SystemUtilities.showAlphaFeatures());
        return box;
    }

    private static Locale[] getSortedLocales() {
        Locale[] localeArray = Locale.getAvailableLocales();
        Arrays.sort(localeArray, new LocaleComparator());
        return localeArray;
    }

    private JComponent createShowWelcomeDialogCheckBox() {
        this.showWelcomeDialogCheckBox = ComponentFactory.createCheckBox("Show Welcome Dialog on Start-up");
        this.showWelcomeDialogCheckBox.setSelected(ApplicationProperties.getWelcomeDialogShow());
        return this.showWelcomeDialogCheckBox;
    }

    private JComponent createPrettyPrintLabelsCheckBox() {
        this.prettyPrintLabelsCheckBox = ComponentFactory.createCheckBox("Capitalize Slot Widget Labels");
        this.prettyPrintLabelsCheckBox.setSelected(ApplicationProperties.getPrettyPrintSlotWidgetLabels());
        return this.prettyPrintLabelsCheckBox;
    }

    public void saveContents() {
        ApplicationProperties.setUserName(this.userNameField.getText());
        ApplicationProperties.setWelcomeDialogShow(this.showWelcomeDialogCheckBox.isSelected());
        ApplicationProperties.setPrettyPrintSlotWidgetLabels(this.prettyPrintLabelsCheckBox.isSelected());
        Locale locale = this.protegeDefaultLocaleButton.isSelected() ? SystemUtilities.getProtegeSystemDefaultLocale() : (this.systemDefaultLocaleButton.isSelected() ? SystemUtilities.getSystemLocale() : (Locale)this.localeComboBox.getSelectedItem());
        ApplicationProperties.setLocale(locale);
    }

    public boolean validateContents() {
        return true;
    }
}

