/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import edu.stanford.smi.protege.util.Tree;

public class Tree_Test
extends SimpleTestCase {
    public void testCreate() {
        Object object = new Object();
        Tree<Object> tree = new Tree<Object>(object);
        Tree_Test.assertEquals((Object)object, (Object)tree.getRoot());
        tree.setRoot(null);
        Tree_Test.assertNull((Object)tree.getRoot());
        tree.setRoot(object);
        Tree_Test.assertEquals((Object)object, (Object)tree.getRoot());
    }

    public void testAddNode() {
        String string = "foo";
        String string2 = "bar";
        String string3 = "baz";
        String string4 = "bam";
        Tree<String> tree = new Tree<String>(string);
        tree.addChild(string, string2);
        tree.addChild(string2, string3);
        tree.addChild(string, string4);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(string2, string4), tree.getChildren(string));
        Tree_Test.assertEqualsSet(Tree_Test.makeList(string2, string4, string3), tree.getDescendents(string));
        Tree_Test.assertEqualsSet(Tree_Test.makeList(string3), tree.getDescendents(string2));
        Tree_Test.assertEqualsSet(Tree_Test.makeList(), tree.getDescendents(string4));
    }

    public void testRemoveNode() {
        String string = "foo";
        String string2 = "bar";
        String string3 = "baz";
        Tree<String> tree = new Tree<String>(string);
        tree.addChild(string, string2);
        tree.addChild(string2, string3);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(string2, string3), tree.getDescendents(string));
        tree.removeChild(string2, string3);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(string2), tree.getDescendents(string));
        Tree_Test.assertEqualsSet(Tree_Test.makeList(), tree.getChildren(string2));
        tree.addChild(string, string3);
        String string4 = "all";
        tree.addChild(string3, string4);
        tree.addChild(string2, string4);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(string2, string3, string4), tree.getDescendents(string));
        tree.removeChild(string3, string4);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(string2, string3, string4), tree.getDescendents(string));
        tree.removeChild(string2, string4);
        Tree_Test.assertEqualsSet(Tree_Test.makeList(string2, string3), tree.getDescendents(string));
    }
}

