/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Binding1;
import com.hp.hpl.jena.query.core.DataSourceImpl;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.core.QueryIteratorUtil;
import com.hp.hpl.jena.query.util.iterator.QueryIterSingleton;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterNamedGraph
implements QueryIterator {
    private static Log log = LogFactory.getLog((Class)QueryIterNamedGraph.class);
    boolean finished = false;
    Binding inputBinding;
    Binding binding = null;
    DataSet data;
    ElementNamedGraph sourceElement;
    ClosableIterator current = null;
    Iterator dataSourceURIs = null;
    Mark mark;

    QueryIterNamedGraph(Mark mark, Binding binding, DataSet dataSet, ElementNamedGraph elementNamedGraph) {
        this.mark = mark;
        this.inputBinding = binding;
        this.data = dataSet;
        this.sourceElement = elementNamedGraph;
        this.dataSourceURIs = QueryIterNamedGraph.makeSources(this.data, binding, this.sourceElement.sourceNode);
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (!this.finished && this.current == null) {
            this.current = this.makeIterator();
        }
        if (this.current == null) {
            QueryIteratorUtil.reportHasNext(log, this.mark, false);
            this.close();
            return false;
        }
        while (!this.current.hasNext()) {
            this.current = this.makeIterator();
            if (this.current != null) continue;
            QueryIteratorUtil.reportHasNext(log, this.mark, false);
            this.close();
            return false;
        }
        QueryIteratorUtil.reportHasNext(log, this.mark, true);
        return true;
    }

    public Object next() {
        return this.current.next();
    }

    public void close() {
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.current.close();
        }
        this.current = null;
        this.binding = null;
        this.data = null;
        this.finished = true;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    private ClosableIterator makeIterator() {
        if (this.dataSourceURIs == null) {
            return null;
        }
        if (!this.dataSourceURIs.hasNext()) {
            return null;
        }
        String string = (String)this.dataSourceURIs.next();
        Graph graph = this.data.getNamedGraph(string);
        if (graph == null) {
            this.mark.msg("SourceIterator: no such URI: " + string);
            return null;
        }
        DataSourceImpl dataSourceImpl = new DataSourceImpl(this.data);
        dataSourceImpl.setGraph(graph);
        Binding binding = this.inputBinding;
        if (this.sourceElement.sourceNode != null && this.sourceElement.sourceNode.isVariable()) {
            binding = new Binding1(this.sourceElement.sourceNode.getName(), Node.createURI((String)string), this.inputBinding);
        }
        return this.sourceElement.element.exec(this.mark, new QueryIterSingleton(binding), dataSourceImpl);
    }

    private static Iterator makeSources(DataSet dataSet, Binding binding, Node node) {
        Node node2 = QueryIterNamedGraph.resolve(binding, node);
        if (node2 != null && !node2.isURI()) {
            throw new QueryException("GRAPH is not a URI: " + node2);
        }
        if (node2 == null) {
            return dataSet.listNames();
        }
        return new SingletonIterator((Object)node2.getURI());
    }

    private static Node resolve(Binding binding, Node node) {
        if (node == null) {
            return node;
        }
        if (!node.isVariable()) {
            return node;
        }
        if (binding == null) {
            return null;
        }
        return binding.get(node.getName());
    }
}

