/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.core.QueryIteratorUtil;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class QueryIterRepeatApply
implements QueryIterator {
    static Log log = LogFactory.getLog((Class)QueryIterRepeatApply.class);
    boolean finished = false;
    DataSet data;
    Mark mark;
    QueryIterator nextStage = null;
    QueryIterator input;
    GeneratorBinding generator;

    QueryIterRepeatApply(Mark mark, DataSet dataSet, QueryIterator queryIterator, GeneratorBinding generatorBinding) {
        this.mark = mark;
        this.input = queryIterator;
        this.generator = generatorBinding;
        this.data = dataSet;
        if (this.input == null) {
            log.fatal((Object)"Repeated application to null input iterator");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Start"));
        }
    }

    public boolean hasNext() {
        if (this.finished) {
            QueryIteratorUtil.reportHasNext(log, this.mark, false);
            return false;
        }
        while (true) {
            if (this.nextStage == null) {
                this.nextStage = this.makeNextStage();
                if (this.nextStage == null) {
                    this.finished = true;
                    this.close();
                    QueryIteratorUtil.reportHasNext(log, this.mark, false);
                    return false;
                }
            }
            if (this.nextStage.hasNext()) {
                QueryIteratorUtil.reportHasNext(log, this.mark, true);
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg("hasNext: Stage iterator ends"));
            }
            this.nextStage.close();
            this.nextStage = null;
        }
    }

    public Object next() {
        if (this.finished) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg(".next: Already finished"));
            }
            throw new NoSuchElementException(this.getClass().getName() + ".next()/finished");
        }
        Object object = this.nextStage.next();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.mark.msg("next: " + object));
        }
        return object;
    }

    private QueryIterator makeNextStage() {
        Mark mark = new Mark(this.mark);
        if (this.input == null || !this.input.hasNext()) {
            return null;
        }
        Binding binding = (Binding)this.input.next();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.mark.msg("New stage: Binding: " + binding));
        }
        QueryIterator queryIterator = this.generator.makeIterator(mark, binding, this.data);
        return queryIterator;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    public void close() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.input != null) {
            this.input.close();
        }
    }

    static interface GeneratorBinding {
        public QueryIterator makeIterator(Mark var1, Binding var2, DataSet var3);
    }
}

