/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.expr.ValueException;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.NodeUtils;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.Calendar;
import org.apache.commons.logging.LogFactory;

public class NodeValue
extends ExprNode {
    static Model model = ModelFactory.createDefaultModel();
    public static final NodeValue TRUE = NodeValue.makeBoolean(true);
    public static final NodeValue FALSE = NodeValue.makeBoolean(false);
    public static final int CMP_GREATER = 1;
    public static final int CMP_EQUAL = 0;
    public static final int CMP_LESS = -1;
    public static final int CMP_UNKNOWN = -15;
    protected boolean isSet = false;
    private boolean mayForceToNumber = false;
    private boolean isInteger = false;
    private boolean isBoolean = false;
    private boolean isDouble = false;
    private boolean isURI = false;
    private boolean isString = false;
    private boolean isGraphNode = false;
    private boolean isDate = false;
    private Calendar valDate;
    private long valInteger;
    private boolean valBoolean;
    private double valDouble;
    private String valString;
    private String valURI;
    private Node valGraphNode;
    private static boolean doBooleanEffectiveValue = ARQ.doBooleanEffectiveValue;
    private static boolean doStringToNumberPromotion = false;
    private static boolean dynamicNumberConversion = false;
    private static boolean sameValueAsString = JenaParameters.enablePlainLiteralSameAsString;
    private static final int CLASS_UNDEF = -5;
    private static final int CLASS_NUM = 10;
    private static final int CLASS_DT = 11;
    private static final int CLASS_STRING = 12;
    private static final int CLASS_URI = 13;
    private static final int CLASS_NODE = 14;

    NodeValue() {
    }

    protected NodeValue(NodeValue nodeValue) {
        if (nodeValue.isNode()) {
            this._setNode(nodeValue.getNode());
        }
        if (nodeValue.isBoolean()) {
            this._setBoolean(nodeValue.getBoolean());
        }
        if (nodeValue.isInteger()) {
            this._setInteger(nodeValue.getInteger());
        }
        if (nodeValue.isDouble()) {
            this._setDouble(nodeValue.getDouble());
        }
        if (nodeValue.isURI()) {
            this._setURI(nodeValue.getURI());
        }
        if (nodeValue.isString()) {
            this._setString(nodeValue.getString());
        }
        if (nodeValue.isDate()) {
            this._setDate(nodeValue.getDate());
        }
        LogFactory.getLog((Class)NodeValue.class).warn((Object)("Unknown NodeValue in constructor: " + nodeValue));
    }

    public static NodeValue makeInteger(long l) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setInteger(l);
        return nodeValue;
    }

    public static NodeValue makeInteger(String string) {
        NodeValue nodeValue = NodeValue.makeString(string);
        nodeValue.forceInteger(true);
        return nodeValue;
    }

    public static NodeValue makeDouble(double d) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setDouble(d);
        return nodeValue;
    }

    public static NodeValue makeDouble(String string) {
        NodeValue nodeValue = NodeValue.makeString(string);
        nodeValue.forceDouble(true);
        return nodeValue;
    }

    public static NodeValue makeBoolean(boolean bl) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setBoolean(bl);
        return nodeValue;
    }

    public static NodeValue makeString(String string) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setString(string);
        return nodeValue;
    }

    public static NodeValue makeURI(String string) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setURI(string);
        return nodeValue;
    }

    public static NodeValue makeNode(Node node) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setNode(node);
        return nodeValue;
    }

    public static NodeValue makeNode(String string, XSDDatatype xSDDatatype) {
        Node node = Node.createLiteral((String)string, null, (RDFDatatype)xSDDatatype);
        NodeValue nodeValue = NodeValue.makeNode(node);
        return nodeValue;
    }

    public static NodeValue makeNode(String string, String string2, Node node) {
        String string3 = node == null ? null : node.getURI();
        return NodeValue.makeNode(string, string2, string3);
    }

    public static NodeValue makeNode(String string, String string2, String string3) {
        NodeValue nodeValue = new NodeValue();
        if (string3 != null && string3.equals("")) {
            string3 = null;
        }
        Node node = null;
        if (string3 != null) {
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string3);
            node = Node.createLiteral((String)string, null, (RDFDatatype)rDFDatatype);
        } else {
            node = Node.createLiteral((String)string, (String)string2, null);
        }
        return NodeValue.makeNode(node);
    }

    public static NodeValue makeNodeBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static NodeValue makeNodeInteger(long l) {
        NodeValue nodeValue = NodeValue.makeNode(Long.toString(l), null, XSD.integer.getURI());
        return nodeValue;
    }

    public static NodeValue makeNodeInteger(String string) {
        NodeValue nodeValue = NodeValue.makeNode(string, null, XSD.integer.getURI());
        return nodeValue;
    }

    public static NodeValue makeNodeDouble(double d) {
        NodeValue nodeValue = NodeValue.makeNode(Double.toString(d), null, XSD.xdouble.getURI());
        return nodeValue;
    }

    public static NodeValue makeNodeDouble(String string) {
        NodeValue nodeValue = NodeValue.makeNode(string, null, XSD.xdouble.getURI());
        return nodeValue;
    }

    public static NodeValue makeNodeString(String string) {
        NodeValue nodeValue = NodeValue.makeNode(string, null, (String)null);
        return nodeValue;
    }

    protected void unset() {
        this.isSet = false;
        this.valString = null;
        this.valGraphNode = null;
        this.valInteger = 0L;
        this.valBoolean = false;
        this.valDouble = 0.0;
        this.valURI = null;
        this.valGraphNode = null;
        this.mayForceToNumber = true;
        this.isInteger = false;
        this.isBoolean = false;
        this.isDouble = false;
        this.isURI = false;
        this.isString = false;
    }

    public NodeValue eval(Binding binding) {
        if (!this.isSet) {
            NodeValue.raise(new ValueException("Literal value not set"));
        }
        return this;
    }

    public static boolean sameValueAs(NodeValue nodeValue, NodeValue nodeValue2) {
        int n = NodeValue.classifyOP(nodeValue, nodeValue2);
        switch (n) {
            case 10: {
                return NodeValue.compareAsNum(nodeValue, nodeValue2) == 0;
            }
            case 11: {
                return NodeValue.compareAsDates(nodeValue, nodeValue2) == 0;
            }
            case 12: {
                return NodeValue.compareAsString(nodeValue, nodeValue2) == 0;
            }
            case 13: {
                return nodeValue.valURI.equals(nodeValue2.valURI);
            }
            case 14: {
                return nodeValue.valGraphNode.equals((Object)nodeValue2.valGraphNode);
            }
        }
        NodeValue.raise(new ExprEvalException("Can't sameValueAs " + nodeValue + " and " + nodeValue2));
        return false;
    }

    public static boolean notSameValueAs(NodeValue nodeValue, NodeValue nodeValue2) {
        int n = NodeValue.classifyOP(nodeValue, nodeValue2);
        switch (n) {
            case 10: {
                return NodeValue.compareAsNum(nodeValue, nodeValue2) != 0;
            }
            case 11: {
                return NodeValue.compareAsDates(nodeValue, nodeValue2) != 0;
            }
            case 12: {
                return NodeValue.compareAsString(nodeValue, nodeValue2) != 0;
            }
            case 13: {
                return !nodeValue.valURI.equals(nodeValue2.valURI);
            }
            case 14: {
                Node node = nodeValue.valGraphNode;
                Node node2 = nodeValue2.valGraphNode;
                if (!node.isLiteral() || !node2.isLiteral()) {
                    return !nodeValue.valGraphNode.equals((Object)nodeValue2.valGraphNode);
                }
                String string = node.getLiteral().getDatatypeURI();
                String string2 = node2.getLiteral().getDatatypeURI();
                if (string == null || string.equals("")) {
                    return true;
                }
                return string2 == null || string2.equals("");
            }
        }
        NodeValue.raise(new ExprEvalException("Can't notSameValueAs " + nodeValue + " and " + nodeValue2));
        return false;
    }

    public static int compareAlways(NodeValue nodeValue, NodeValue nodeValue2) {
        int n = NodeValue.compare(nodeValue, nodeValue2);
        if (n != -15) {
            return n;
        }
        if (nodeValue.isNode() && nodeValue2.isNode()) {
            return NodeUtils.compareNodesByKindTypeLexical(nodeValue.getNode(), nodeValue2.getNode());
        }
        return -15;
    }

    public static int compare(NodeValue nodeValue, NodeValue nodeValue2) {
        int n = NodeValue.classifyOP(nodeValue, nodeValue2);
        switch (n) {
            case 10: {
                return NodeValue.compareAsNum(nodeValue, nodeValue2);
            }
            case 11: {
                return NodeValue.compareAsDates(nodeValue, nodeValue2);
            }
            case 12: {
                return NodeValue.compareAsString(nodeValue, nodeValue2);
            }
        }
        NodeValue.raise(new ExprEvalException("Can't compare " + nodeValue + " and " + nodeValue2));
        return -15;
    }

    private static int classifyOP(NodeValue nodeValue, NodeValue nodeValue2) {
        if (!nodeValue.isSet || !nodeValue2.isSet) {
            return -5;
        }
        nodeValue.forceNumber();
        nodeValue2.forceNumber();
        if (nodeValue.isNumber()) {
            if (nodeValue2.isNumber()) {
                return 10;
            }
            return -5;
        }
        if (nodeValue2.isNumber()) {
            return -5;
        }
        if (nodeValue.isDate() && nodeValue2.isDate()) {
            return 11;
        }
        if (nodeValue.isString() && nodeValue2.isString()) {
            return 12;
        }
        if (nodeValue.isString() && nodeValue2.isString()) {
            return 12;
        }
        if (nodeValue.isURI() && nodeValue2.isURI()) {
            return 13;
        }
        if (nodeValue.isNode() && nodeValue2.isNode()) {
            return 14;
        }
        return -5;
    }

    private static int compareAsNum(NodeValue nodeValue, NodeValue nodeValue2) {
        if (nodeValue.isInteger && nodeValue2.isInteger) {
            if (nodeValue.valInteger < nodeValue2.valInteger) {
                return -1;
            }
            if (nodeValue.valInteger > nodeValue2.valInteger) {
                return 1;
            }
            return 0;
        }
        nodeValue.forceDouble(true);
        nodeValue2.forceDouble(true);
        if (!nodeValue.isDouble || !nodeValue2.isDouble) {
            NodeValue.raise(new ExprEvalException("Can't force to doubles"));
        }
        return Double.compare(nodeValue.valDouble, nodeValue2.valDouble);
    }

    private static int compareAsDates(NodeValue nodeValue, NodeValue nodeValue2) {
        if (nodeValue.valDate.after(nodeValue2.valDate)) {
            return 1;
        }
        if (nodeValue.valDate.before(nodeValue2.valDate)) {
            return -1;
        }
        return 0;
    }

    private static int compareAsString(NodeValue nodeValue, NodeValue nodeValue2) {
        return nodeValue.valString.compareTo(nodeValue2.valString);
    }

    public void check() {
        if (!this.isSet()) {
            NodeValue.raise(new ValueException("Unset NodeValue"));
        }
    }

    public boolean isSet() {
        return this.isSet;
    }

    public Node getNode() {
        if (!this.isSet) {
            NodeValue.raise(new ExprEvalException("Not set: " + this));
        }
        if (!this.isGraphNode) {
            NodeValue.raise(new ExprEvalException("Not a graph node: " + this));
        }
        return this.valGraphNode;
    }

    public String getURI() {
        if (!this.isSet || !this.isURI) {
            NodeValue.raise(new ExprEvalException("Not a URI: " + this));
        }
        return this.valURI;
    }

    public String getString() {
        if (!this.isSet || !this.isString) {
            NodeValue.raise(new ExprEvalException("Not a string: " + this));
        }
        return this.valString;
    }

    public boolean getBoolean() {
        if (doBooleanEffectiveValue) {
            return this.getBooleanBEV();
        }
        return this.getBooleanRaw();
    }

    public boolean getBooleanRaw() {
        if (!this.isSet || !this.isBoolean) {
            NodeValue.raise(new ExprEvalException("Not a boolean: " + this));
        }
        return this.valBoolean;
    }

    public boolean getBooleanBEV() {
        if (!this.isSet) {
            NodeValue.raise(new ExprEvalException("Not a boolean effective value (unset): " + this));
        }
        if (this.isBooleanRaw()) {
            return this.getBooleanRaw();
        }
        if (this.isString()) {
            return this.getString().length() > 0;
        }
        if (this.isInteger()) {
            return this.getInteger() != 0L;
        }
        if (this.isDouble()) {
            return this.getDouble() != 0.0;
        }
        NodeValue.raise(new ExprEvalException("Not a boolean effective value (wrong type): " + this));
        return false;
    }

    public double getDouble() {
        if (!this.isSet || !this.isDouble && !this.isInteger) {
            NodeValue.raise(new ExprEvalException("Not a double: " + this));
        }
        if (this.isInteger) {
            return this.valInteger;
        }
        return this.valDouble;
    }

    public long getInteger() {
        if (!this.isSet || !this.isInteger) {
            NodeValue.raise(new ExprEvalException("Not an int: " + this));
        }
        return this.valInteger;
    }

    public Calendar getDate() {
        if (!this.isSet || !this.isDate) {
            NodeValue.raise(new ExprEvalException("Not a date: " + this));
        }
        return this.valDate;
    }

    public boolean isNumber() {
        if (dynamicNumberConversion) {
            this.forceNumber();
        }
        return this.isSet && (this.isInteger || this.isDouble);
    }

    public boolean isInteger() {
        if (dynamicNumberConversion) {
            this.forceInteger(false);
        }
        return this.isSet && this.isInteger;
    }

    public boolean isDouble() {
        if (dynamicNumberConversion) {
            this.forceDouble(false);
        }
        return this.isSet && this.isDouble;
    }

    public boolean isBooleanRaw() {
        return this.isSet && this.isBoolean;
    }

    public boolean isBooleanBEV() {
        return this.isSet && (this.isBoolean || this.isInteger || this.isDouble || this.isString);
    }

    public boolean isBoolean() {
        if (doBooleanEffectiveValue) {
            return this.isBooleanBEV();
        }
        return this.isBooleanRaw();
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isURI() {
        return this.isSet && this.isURI;
    }

    public boolean isNode() {
        return this.isSet && this.isGraphNode;
    }

    public boolean isDate() {
        return this.isSet && this.isDate;
    }

    protected void setInteger(long l) {
        this.unset();
        this._setInteger(l);
    }

    protected void _setInteger(long l) {
        this.isSet = true;
        this.mayForceToNumber = false;
        this.isInteger = true;
        this.valInteger = l;
        this.isDouble = true;
        this.valDouble = l;
    }

    protected void setDouble(double d) {
        this.unset();
        this._setDouble(d);
    }

    protected void _setDouble(double d) {
        this.isSet = true;
        this.mayForceToNumber = false;
        this.isDouble = true;
        this.valDouble = d;
    }

    protected void setBoolean(boolean bl) {
        this.unset();
        this.setBoolean(bl);
    }

    protected void _setBoolean(boolean bl) {
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = bl;
        this.mayForceToNumber = false;
    }

    protected void setString(String string) {
        this.unset();
        this._setString(string);
    }

    protected void _setString(String string) {
        this.isSet = true;
        this.isString = true;
        this.valString = string;
        this.mayForceToNumber = doStringToNumberPromotion;
    }

    protected void setURI(String string) {
        this.unset();
        this._setURI(string);
    }

    protected void _setURI(String string) {
        this.isSet = true;
        this.isURI = true;
        this.valURI = string;
        this.mayForceToNumber = false;
    }

    protected void setNode(Node node) {
        this.unset();
        this._setNode(node);
    }

    protected void _setNode(Node node) {
        this.isSet = true;
        this.isGraphNode = true;
        this.valGraphNode = node;
        this.mayForceToNumber = false;
        if (node.isLiteral()) {
            boolean bl;
            LiteralLabel literalLabel = node.getLiteral();
            boolean bl2 = literalLabel.language() == null || literalLabel.language().equals("");
            boolean bl3 = bl = literalLabel.getDatatypeURI() == null && bl2;
            if (bl) {
                this._setString(literalLabel.getLexicalForm());
                return;
            }
            if (sameValueAsString && XSDDatatype.XSDstring.isValidLiteral(literalLabel)) {
                this._setString(literalLabel.getLexicalForm());
                return;
            }
            if (XSDDatatype.XSDinteger.isValidLiteral(literalLabel)) {
                long l = ((Number)literalLabel.getValue()).longValue();
                this._setInteger(l);
                return;
            }
            if (XSDDatatype.XSDdouble.isValidLiteral(literalLabel)) {
                double d = ((Number)literalLabel.getValue()).doubleValue();
                this._setDouble(d);
                return;
            }
            if (XSDDatatype.XSDfloat.isValidLiteral(literalLabel)) {
                double d = ((Number)literalLabel.getValue()).floatValue();
                this._setDouble(d);
                return;
            }
            if (XSDDatatype.XSDdateTime.isValidLiteral(literalLabel)) {
                XSDDateTime xSDDateTime = (XSDDateTime)literalLabel.getValue();
                this._setDate(xSDDateTime.asCalendar());
                return;
            }
            if (XSDDatatype.XSDboolean.isValidLiteral(literalLabel)) {
                boolean bl4 = (Boolean)literalLabel.getValue();
                this._setBoolean(bl4);
            }
            LogFactory.getLog((Class)NodeValue.class).debug((Object)("Unrecognized literal: " + node));
            return;
        }
        if (node.isURI()) {
            this.valString = node.getURI();
            this.valURI = node.getURI();
            this.isURI = true;
            return;
        }
        if (node.isBlank()) {
            this.valGraphNode = node;
            this.isGraphNode = true;
            return;
        }
        NodeValue.raise(new ExprException("NodeValue._setNode: Unknown Node type: " + node));
    }

    protected void setDate(Calendar calendar) {
        this.unset();
        this._setDate(calendar);
    }

    protected void _setDate(Calendar calendar) {
        this.isSet = true;
        this.isDate = true;
        this.valDate = calendar;
    }

    private void forceInteger(boolean bl) {
        if (!this.isSet || !this.mayForceToNumber) {
            return;
        }
        this.mayForceToNumber = false;
    }

    private void _forceInteger(boolean bl) {
        if (!this.isSet || this.isInteger) {
            return;
        }
        if (this.isDouble) {
            return;
        }
        if (!doStringToNumberPromotion) {
            return;
        }
        if (!this.isString) {
            return;
        }
        this.mayForceToNumber = false;
        try {
            String string = this.valString;
            if (string.startsWith("+")) {
                string = string.substring(1);
            }
            long l = Long.parseLong(string);
            this._setInteger(l);
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                NodeValue.raise(new ExprException("Number format exception:" + this, numberFormatException));
            }
            return;
        }
    }

    private void forceDouble(boolean bl) {
        if (!this.isSet || !this.mayForceToNumber) {
            return;
        }
        this.mayForceToNumber = false;
        this._forceDouble(bl);
    }

    private void _forceDouble(boolean bl) {
        if (!this.isSet || this.isDouble) {
            return;
        }
        if (this.isInteger) {
            this.valDouble = this.valInteger;
            this.isDouble = true;
            return;
        }
        if (!doStringToNumberPromotion) {
            return;
        }
        if (!this.isString) {
            return;
        }
        try {
            double d = Double.parseDouble(this.valString);
            this._setDouble(d);
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                NodeValue.raise(new ExprException("Number format exception:" + this, numberFormatException));
            }
            return;
        }
    }

    private void forceNumber() {
        if (!this.isSet || !this.mayForceToNumber) {
            return;
        }
        if (this.isInteger || this.isDouble || !this.isString) {
            return;
        }
        this._forceInteger(false);
        if (!this.isInteger) {
            this._forceDouble(false);
        }
    }

    private static void raise(ExprException exprException) {
        throw exprException;
    }

    public void visit(ExprVisitor exprVisitor) {
        exprVisitor.visit(this);
    }

    public String asQuotedString() {
        return this.asQuotedString(null);
    }

    public String asQuotedString(Query query2) {
        PrefixMapping prefixMapping = null;
        if (query2 != null) {
            prefixMapping = query2.getPrefixMapping();
        }
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isGraphNode) {
            return QueryPrintUtils.stringForNode(this.valGraphNode, prefixMapping);
        }
        if (this.isInteger) {
            return Long.toString(this.valInteger);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isString) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\"");
            QueryPrintUtils.stringEsc(stringBuffer, this.valString, true);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        if (this.isURI) {
            return QueryPrintUtils.stringForURI(this.valURI, prefixMapping);
        }
        return "literal:unknown";
    }

    public String asPrefixString(Query query2) {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInteger) {
            return "int:" + Long.toString(this.valInteger);
        }
        if (this.isDouble) {
            return "double:" + Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return "boolean:" + (this.valBoolean ? "true" : "false");
        }
        if (this.isURI) {
            return "URI:" + this.valURI;
        }
        if (this.isString) {
            return "string:" + this.valString;
        }
        if (this.isGraphNode) {
            return "node:" + this.valGraphNode;
        }
        return "literal:unknown";
    }

    public void format(Query query2, IndentedWriter indentedWriter) {
        indentedWriter.print(this.asQuotedString(query2));
    }

    public String asString() {
        if (this.isString) {
            return this.valString;
        }
        if (this.isGraphNode && this.valGraphNode.isURI()) {
            return this.valGraphNode.getURI();
        }
        if (this.isGraphNode && this.valGraphNode.isBlank()) {
            return "";
        }
        if (this.isGraphNode && this.valGraphNode.isLiteral()) {
            String string = this.valGraphNode.getLiteral().getLexicalForm();
            return string;
        }
        if (this.isInteger) {
            return Long.toString(this.valInteger);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        NodeValue.raise(new ValueException("Can't be turned into a string: " + this));
        return "asString";
    }

    public String toString() {
        return this.asQuotedString();
    }
}

