/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.parser.rdql.EvalTypeException;
import com.hp.hpl.jena.query.parser.rdql.Expr;
import com.hp.hpl.jena.query.parser.rdql.ExprBoolean;
import com.hp.hpl.jena.query.parser.rdql.ExprNode;
import com.hp.hpl.jena.query.parser.rdql.NodeValue;
import com.hp.hpl.jena.query.parser.rdql.NodeValueSettable;
import com.hp.hpl.jena.query.parser.rdql.RDQLParser;
import com.hp.hpl.jena.query.parser.rdql.RDQLQueryPrintUtils;
import com.hp.hpl.jena.query.parser.rdql.WorkingVar;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class Q_GreaterThanOrEqual
extends ExprNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    private String printName = "ge";
    private String opSymbol = ">=";

    Q_GreaterThanOrEqual(int n) {
        super(n);
    }

    Q_GreaterThanOrEqual(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query2, indexValues);
        NodeValue nodeValue2 = this.right.eval(query2, indexValues);
        if (!nodeValue.isNumber()) {
            throw new EvalTypeException("Q_GreaterThanOrEqual: Wanted a numeric: " + nodeValue);
        }
        if (!nodeValue2.isNumber()) {
            throw new EvalTypeException("Q_GreaterThanOrEqual: Wanted a numeric: " + nodeValue2);
        }
        NodeValueSettable nodeValueSettable = nodeValue instanceof NodeValueSettable ? (NodeValueSettable)nodeValue : (nodeValue2 instanceof NodeValueSettable ? (NodeValueSettable)nodeValue2 : new WorkingVar());
        boolean bl = nodeValue.isInt() && nodeValue2.isInt() ? nodeValue.getInt() >= nodeValue2.getInt() : nodeValue.getDouble() >= nodeValue2.getDouble();
        nodeValueSettable.setBoolean(bl);
        return nodeValueSettable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_GreaterThanOrEqual: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void format(IndentedWriter indentedWriter) {
        RDQLQueryPrintUtils.format(indentedWriter, this.left, this.right, this.printName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

