/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.resultset.ResultSetMem;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;

public class ResultSetTextFormatter {
    protected ResultSet resultSet;
    protected PrefixMapping prefixMapping = null;
    static final String notThere = "    ";

    protected ResultSetTextFormatter(ResultSet resultSet, PrefixMapping prefixMapping) {
        this.resultSet = resultSet;
        this.prefixMapping = prefixMapping;
    }

    private int[] colWidths(ResultSetRewindable resultSetRewindable) {
        if (resultSetRewindable == null) {
            resultSetRewindable = new ResultSetMem(this.resultSet);
        }
        int n = resultSetRewindable.getResultVars().size();
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((String)resultSetRewindable.getResultVars().get(i)).length();
        }
        while (resultSetRewindable.hasNext()) {
            ++n2;
            QuerySolution querySolution = resultSetRewindable.nextSolution();
            int n3 = -1;
            Iterator iterator = resultSetRewindable.getResultVars().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getVarValueAsString(querySolution, string);
                if (nArray[++n3] >= string2.length()) continue;
                nArray[n3] = string2.length();
            }
        }
        resultSetRewindable.reset();
        return nArray;
    }

    public void dump(OutputStream outputStream, boolean bl) {
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)outputStream);
        this.dump(printWriter, bl);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter, boolean bl) {
        if (this.resultSet.getResultVars().size() == 0) {
            printWriter.println("# ==== No variables ====");
            return;
        }
        printWriter.println("# Variables:");
        Iterator iterator = this.resultSet.getResultVars().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            printWriter.print("?" + string + " ");
        }
        printWriter.println(".");
        printWriter.println("# Solutions:");
        printWriter.flush();
        if (bl) {
            this.dumpAligned(printWriter);
        } else {
            this.dumpRaw(printWriter);
        }
    }

    private void dumpRaw(PrintWriter printWriter) {
        while (this.resultSet.hasNext()) {
            QuerySolution querySolution = this.resultSet.nextSolution();
            Iterator iterator = this.resultSet.getResultVars().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getVarValueAsString(querySolution, string);
                printWriter.print("?");
                printWriter.print(string);
                printWriter.print(" ");
                printWriter.print(string2);
                printWriter.print(" ");
            }
            printWriter.println(".");
        }
    }

    private void dumpAligned(PrintWriter printWriter) {
        ResultSetMem resultSetMem = new ResultSetMem(this.resultSet);
        int n = this.resultSet.getResultVars().size();
        int[] nArray = this.colWidths(resultSetMem);
        while (resultSetMem.hasNext()) {
            QuerySolution querySolution = resultSetMem.nextSolution();
            for (int i = 0; i < n; ++i) {
                StringBuffer stringBuffer = new StringBuffer(120);
                String string = (String)this.resultSet.getResultVars().get(i);
                stringBuffer.append('?');
                stringBuffer.append(string);
                stringBuffer.append('=');
                String string2 = this.getVarValueAsString(querySolution, string);
                int n2 = nArray[i];
                stringBuffer.append(string2);
                for (int j = 0; j < n2 - string2.length(); ++j) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("  ");
                printWriter.print(stringBuffer);
            }
            printWriter.println();
        }
        resultSetMem = null;
    }

    public void printAll(PrintWriter printWriter) {
        this.printAll(printWriter, "| ", " | ", " |");
    }

    public void printAll(OutputStream outputStream) {
        this.printAll(outputStream, "| ", " | ", " |");
    }

    public void printAll(OutputStream outputStream, String string, String string2, String string3) {
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)outputStream);
        this.printAll(printWriter, string, string2, string3);
        printWriter.flush();
    }

    public void printAll(PrintWriter printWriter, String string, String string2, String string3) {
        int n;
        if (this.resultSet.getResultVars().size() == 0) {
            printWriter.println("==== No variables ====");
            return;
        }
        ResultSetMem resultSetMem = new ResultSetMem(this.resultSet);
        int n2 = resultSetMem.getResultVars().size();
        int[] nArray = this.colWidths(resultSetMem);
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            String string4;
            stringArray[n] = string4 = (String)this.resultSet.getResultVars().get(n);
            n3 += nArray[n];
            if (n <= 0) continue;
            n3 += string2.length();
        }
        if (string != null) {
            n3 += string.length();
        }
        if (string3 != null) {
            n3 += string3.length();
        }
        for (n = 0; n < n3; ++n) {
            printWriter.print('-');
        }
        printWriter.println();
        this.printRow(printWriter, stringArray, nArray, string, string2, string3);
        for (n = 0; n < n3; ++n) {
            printWriter.print('=');
        }
        printWriter.println();
        while (resultSetMem.hasNext()) {
            QuerySolution querySolution = resultSetMem.nextSolution();
            for (int i = 0; i < n2; ++i) {
                String string5 = (String)this.resultSet.getResultVars().get(i);
                stringArray[i] = this.getVarValueAsString(querySolution, string5);
            }
            this.printRow(printWriter, stringArray, nArray, string, string2, string3);
        }
        for (n = 0; n < n3; ++n) {
            printWriter.print('-');
        }
        printWriter.println();
        resultSetMem = null;
    }

    private void printRow(PrintWriter printWriter, String[] stringArray, int[] nArray, String string, String string2, String string3) {
        printWriter.print(string);
        for (int i = 0; i < nArray.length; ++i) {
            String string4 = stringArray[i];
            int n = nArray[i];
            StringBuffer stringBuffer = new StringBuffer(120);
            if (i > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string4);
            for (int j = 0; j < n - string4.length(); ++j) {
                stringBuffer.append(' ');
            }
            printWriter.print(stringBuffer);
        }
        printWriter.print(string3);
        printWriter.println();
    }

    private String getVarValueAsString(QuerySolution querySolution, String string) {
        RDFNode rDFNode = querySolution.get(string);
        if (rDFNode == null) {
            return notThere;
        }
        return QueryPrintUtils.stringForRDFNode(rDFNode, this.prefixMapping);
    }
}

