/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprNode1;
import com.hp.hpl.jena.query.expr.ExprNode2;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.serializer.FmtExpr;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class FmtExprARQ
extends FmtExpr {
    static final int INDENT = 2;
    IndentedWriter out;
    SerializationContext context;

    public FmtExprARQ(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        this.out = indentedWriter;
        this.context = serializationContext;
        if (this.context == null) {
            this.context = new SerializationContext(null, null, null);
        }
    }

    public static void format(IndentedWriter indentedWriter, SerializationContext serializationContext, Expr expr) {
        FmtExprARQ fmtExprARQ = new FmtExprARQ(indentedWriter, serializationContext);
        fmtExprARQ.startVisit();
        expr.visit(fmtExprARQ);
        fmtExprARQ.finishVisit();
    }

    public void startVisit() {
    }

    public void visit(ExprNode1 exprNode1) {
        this.out.print("( ");
        this.out.print(exprNode1.getOpSymbol());
        this.out.print(" ");
        exprNode1.getExpr().visit(this);
        this.out.print(" )");
    }

    public void visit(ExprNode2 exprNode2) {
        this.out.print("( ");
        exprNode2.getLeft().visit(this);
        this.out.print(" ");
        this.out.print(exprNode2.getOpSymbol());
        this.out.print(" ");
        exprNode2.getRight().visit(this);
        this.out.print(" )");
    }

    public void visit(ExprNodeFunction exprNodeFunction) {
        Expr expr;
        this.out.print(exprNodeFunction.getPrintName(this.context.getQuery()));
        this.out.print("(");
        int n = 1;
        while ((expr = exprNodeFunction.getArg(n)) != null) {
            if (n != 1) {
                this.out.print(", ");
            }
            expr.visit(this);
            ++n;
        }
        this.out.print(")");
    }

    public void visit(NodeValue nodeValue) {
        nodeValue.format(this.context.getQuery(), this.out);
    }

    public void visit(NodeVar nodeVar) {
        this.out.print("?");
        this.out.print(nodeVar.getName());
    }

    public void finishVisit() {
        this.out.flush();
    }
}

