/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util.iterator;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.QueryIterator;

public class QueryIterLimitOffset
implements QueryIterator {
    boolean finished = false;
    long count = 0L;
    long limit;
    long offset;
    QueryIterator base;

    public QueryIterLimitOffset(QueryIterator queryIterator, long l, long l2) {
        this.limit = l;
        if (this.limit < 0L) {
            throw new QueryException("Negative LIMIT: " + this.limit);
        }
        this.offset = l2;
        if (this.offset < 0L) {
            throw new QueryException("Negative OFFSET: " + this.offset);
        }
        this.base = queryIterator;
        this.count = 0L;
        int n = 0;
        while ((long)n < this.offset) {
            if (!queryIterator.hasNext()) {
                this.close();
                break;
            }
            queryIterator.next();
            ++n;
        }
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (!this.base.hasNext()) {
            this.close();
            return false;
        }
        if (this.count >= this.limit) {
            this.close();
            return false;
        }
        return true;
    }

    public Object next() {
        ++this.count;
        return this.base.next();
    }

    public void close() {
        if (!this.finished) {
            if (this.base != null) {
                this.base.close();
            }
            this.finished = true;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }
}

