/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractValuesComponent;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JScrollPane;

class ClsValuesComponent
extends AbstractValuesComponent
implements Selectable {
    private Project _project;
    private SelectableList _list;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;

    public ClsValuesComponent(Project project) {
        this._project = project;
        this._list = ComponentFactory.createSelectableList(null, true);
        this._list.setCellRenderer(FrameRenderer.createInstance());
        this._list.addListSelectionListener(new ListSelectionListenerAdapter(this));
        String string = LocalizedText.getText(ResourceKey.ALLOWED_SUPERCLASSES);
        LabeledComponent labeledComponent = new LabeledComponent(string, new JScrollPane(this._list));
        labeledComponent.addHeaderButton(this.getViewAction());
        labeledComponent.addHeaderButton(this.getAddAction());
        labeledComponent.addHeaderButton(this.getRemoveAction());
        this.add(labeledComponent);
    }

    public void clearSelection() {
        this._list.clearSelection();
    }

    private Action getAddAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD){

            public void onAdd() {
                Collection collection = DisplayUtilities.pickClses((Component)ClsValuesComponent.this._list, ClsValuesComponent.this.getKnowledgeBase(), ClsValuesComponent.this.getBaseClses());
                ComponentUtilities.addUniqueListValues(ClsValuesComponent.this._list, collection);
                ClsValuesComponent.this.valueChanged();
            }
        };
        return this._addAction;
    }

    private Collection getBaseClses() {
        Collection collection;
        if (this.isOverride()) {
            collection = this.getInheritedParents();
            if (collection.isEmpty()) {
                collection = this.getKnowledgeBase().getRootClses();
            }
        } else {
            collection = this.getKnowledgeBase().getRootClses();
        }
        return collection;
    }

    private Collection getInheritedParents() {
        HashSet hashSet = new HashSet();
        for (Cls cls : this.getAssociatedCls().getDirectSuperclasses()) {
            hashSet.addAll(cls.getTemplateSlotAllowedParents(this.getSlotInstance()));
        }
        return hashSet;
    }

    private Action getRemoveAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this){

            public void onRemove(Collection collection) {
                ComponentUtilities.removeListValues(ClsValuesComponent.this._list, collection);
                ClsValuesComponent.this.valueChanged();
            }
        };
        return this._removeAction;
    }

    public Collection getSelection() {
        return this._list.getSelection();
    }

    public Collection getValues() {
        Collection collection = ComponentUtilities.getListValues(this._list);
        return ValueTypeConstraint.getValues(ValueType.CLS, collection);
    }

    private Action getViewAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){

            public void onView(Object object) {
                Cls cls = (Cls)object;
                ClsValuesComponent.this._project.show(cls);
            }
        };
    }

    public void setEditable(boolean bl) {
        this._addAction.setAllowed(bl);
        this._removeAction.setAllowed(bl);
    }

    public void setValues(Collection collection) {
        Collection collection2 = ValueTypeConstraint.getAllowedParents(collection);
        ComponentUtilities.setListValues(this._list, collection2);
    }
}

