/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.Collection;
import javax.swing.Action;

public class SymbolListWidget
extends AbstractListWidget {
    private String edit(String string, Object object) {
        Collection collection = this.getCls().getTemplateSlotAllowedValues(this.getSlot());
        return (String)DisplayUtilities.pickSymbol(this, string, object, collection);
    }

    private Action getCreateAction() {
        return new CreateAction(ResourceKey.VALUE_ADD){

            public void onCreate() {
                SymbolListWidget.this.handleCreateAction();
            }
        };
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){

            public void onView(Object object) {
                SymbolListWidget.this.handleViewAction((String)object);
            }
        };
    }

    private Action getRemoveAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){

            public void onRemove(Collection collection) {
                SymbolListWidget.this.handleRemoveAction(collection);
            }
        };
    }

    protected void handleCreateAction() {
        String string = this.edit("Create Symbol", null);
        if (string != null) {
            this.addItem(string);
        }
    }

    protected void handleRemoveAction(Collection collection) {
        this.removeItems(collection);
    }

    protected void handleViewAction(String string) {
        String string2 = this.edit("Edit Symbol", string);
        if (string2 != null) {
            this.replaceItem(string, string2);
        }
    }

    public void initialize() {
        Action action = this.getEditAction();
        super.initialize(action);
        this.addButton(action);
        this.addButton(this.getCreateAction());
        this.addButton(this.getRemoveAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            boolean bl2 = SymbolListWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.SYMBOL);
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && bl3;
        }
        return bl;
    }
}

