/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.query.protege;

import de.uka.cmtm.serviceregistry.query.ClassNotFoundEvent;
import de.uka.cmtm.serviceregistry.query.ServiceLocatorEventListener;
import de.uka.cmtm.serviceregistry.query.ServiceProfileInfo;
import de.uka.cmtm.serviceregistry.query.ServiceProfileLocator;
import de.uka.cmtm.serviceregistry.query.ServiceProfileParameter;
import de.uka.cmtm.serviceregistry.query.protege.ProfileIndividualInfo;
import de.uka.cmtm.serviceregistry.query.protege.ProfileIndividualLocator;
import de.uka.cmtm.serviceregistry.query.protege.ProfileIndividualParameter;
import de.uka.cmtm.serviceregistry.query.protege.RelevanceCalculator;
import de.uka.cmtm.serviceregistry.query.protege.SimpleRelevanceCalculator;
import de.uka.cmtm.serviceregistry.query.protege.dig.DigProfileIndividualLocator;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtegeServiceProfileLocator
implements ServiceProfileLocator {
    private List<ServiceLocatorEventListener> listeners = new LinkedList<ServiceLocatorEventListener>();
    private static final Log log = LogFactory.getLog(ProtegeServiceProfileLocator.class);
    private OWLModel owlModel;
    private Set<String> namespacePrefixes = new TreeSet<String>();
    private RelevanceCalculator relevanceCalculator = new SimpleRelevanceCalculator();
    private ProfileIndividualLocator profileIndividualLocator;
    private int expectedSearchLevel = 0;
    private ProfileIndividualParameter piParameter;

    public ProtegeServiceProfileLocator(String digReasonerUrl, String serviceOntologyUrl, String upperServiceOntologyUrl, String topOntologyUrl) throws InstantiationException {
        try {
            this.owlModel = ProtegeOWL.createJenaOWLModelFromURI((String)serviceOntologyUrl);
            String logStr = "Found ontology prefixes:";
            for (OWLOntology ontology : this.owlModel.getOWLOntologies()) {
                log.trace((Object)("Found ontlogogy " + ontology.getURI()));
                String prefix = ontology.getNamespacePrefix();
                if (prefix != null && !"".equals(prefix)) {
                    this.namespacePrefixes.add(String.valueOf(prefix) + ":");
                }
                logStr = String.valueOf(logStr) + " " + prefix;
            }
            log.info((Object)logStr);
            this.profileIndividualLocator = new DigProfileIndividualLocator(this.owlModel, digReasonerUrl, upperServiceOntologyUrl, topOntologyUrl);
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Could not instantiate ProtegeServiceProfileLocator.");
            ie.initCause(e);
            throw ie;
        }
    }

    @Override
    public List<ServiceProfileInfo> findServiceProfiles(int searchLevel) throws IOException {
        log.debug((Object)("findServiceProfiles invoced with serach level " + searchLevel));
        if (searchLevel >= this.getAvailableSearchLevels()) {
            throw new IllegalArgumentException("SearchLevel " + searchLevel + " not supported.");
        }
        if (this.piParameter == null) {
            throw new IllegalStateException("The search parameter must be set prior to a call to findServiceProfiles");
        }
        if (searchLevel != this.expectedSearchLevel) {
            throw new IllegalStateException("Wrong search level: Given " + searchLevel + " Expected " + this.expectedSearchLevel);
        }
        this.expectedSearchLevel = (this.expectedSearchLevel + 1) % this.getAvailableSearchLevels();
        LinkedList<ServiceProfileInfo> foundProfiles = new LinkedList<ServiceProfileInfo>();
        List<ProfileIndividualInfo> profileIndividuals = this.profileIndividualLocator.findProfileIndividuals(searchLevel);
        for (ProfileIndividualInfo individual : profileIndividuals) {
            double relevance = this.relevanceCalculator.calculateRelevance(individual, this.piParameter, this.profileIndividualLocator.getConformClasses());
            foundProfiles.add(this.createServiceProfileInfo(individual, relevance));
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Found ServiceProfileInfos:\n");
            for (ServiceProfileInfo profile : foundProfiles) {
                sb.append("---------------\n").append(profile);
            }
            log.debug((Object)sb.toString());
        }
        return foundProfiles;
    }

    private ServiceProfileInfo createServiceProfileInfo(ProfileIndividualInfo profile, double relevance) {
        ServiceProfileInfo spInfo = new ServiceProfileInfo();
        spInfo.setRelevance(relevance);
        spInfo.setProfileUri(profile.getProfile().getURI());
        spInfo.setCategory(this.removePrefix(profile.getProfile().getRDFType().getName()));
        if (profile.getDescription() != null) {
            spInfo.setDescription(profile.getDescription().getString());
        }
        ArrayList<String> list = new ArrayList<String>(profile.getPreconditions().size());
        for (OWLIndividual ind : profile.getPreconditions()) {
            list.add(this.removePrefix(ind.getRDFType().getName()));
        }
        spInfo.setPreconditions(list);
        list = new ArrayList(profile.getEffects().size());
        for (OWLIndividual ind : profile.getEffects()) {
            list.add(this.removePrefix(ind.getRDFType().getName()));
        }
        spInfo.setEffects(list);
        list = new ArrayList(profile.getLogicalInputs().size());
        for (OWLIndividual ind : profile.getLogicalInputs()) {
            list.add(this.removePrefix(ind.getRDFType().getName()));
        }
        spInfo.setLogicalInputs(list);
        list = new ArrayList(profile.getLogicalOutputs().size());
        for (OWLIndividual ind : profile.getLogicalOutputs()) {
            list.add(this.removePrefix(ind.getRDFType().getName()));
        }
        spInfo.setLogicalOutputs(list);
        list = new ArrayList(profile.getUserRoles().size());
        for (OWLIndividual ind : profile.getUserRoles()) {
            list.add(this.removePrefix(ind.getRDFType().getName()));
        }
        spInfo.setUserRoles(list);
        return spInfo;
    }

    private String removePrefix(String name) {
        return name.substring(name.indexOf(":") + 1);
    }

    private OWLClass findClass(String name) {
        OWLNamedClass owlClass = null;
        if (name != null && !"".equals(name)) {
            owlClass = this.owlModel.getOWLNamedClass(name);
            if (owlClass == null) {
                Iterator<String> iter = this.namespacePrefixes.iterator();
                while (owlClass == null && iter.hasNext()) {
                    owlClass = this.owlModel.getOWLNamedClass(String.valueOf(iter.next()) + name);
                }
            }
            if (owlClass == null) {
                this.sendClassNotFoundEvent(name);
            }
        }
        return owlClass;
    }

    private ProfileIndividualParameter findParameterClasses(ServiceProfileParameter spParameter) {
        OWLClass owlClass;
        ProfileIndividualParameter piParameter = new ProfileIndividualParameter();
        piParameter.setCategory(this.findClass(spParameter.getCategory()));
        HashSet<Object> classes = new HashSet<OWLClass>(spParameter.getUserRoles().size());
        for (String className : spParameter.getUserRoles()) {
            owlClass = this.findClass(className);
            if (owlClass == null) continue;
            classes.add(owlClass);
        }
        piParameter.setUserRoles(classes);
        classes = new HashSet(spParameter.getPreconditions().size());
        for (String className : spParameter.getPreconditions()) {
            owlClass = this.findClass(className);
            if (owlClass == null) continue;
            classes.add(owlClass);
        }
        piParameter.setPreconditions(classes);
        classes = new HashSet(spParameter.getEffects().size());
        for (String className : spParameter.getEffects()) {
            owlClass = this.findClass(className);
            if (owlClass == null) continue;
            classes.add(owlClass);
        }
        piParameter.setEffects(classes);
        classes = new HashSet(spParameter.getLogicalInputs().size());
        for (String className : spParameter.getLogicalInputs()) {
            owlClass = this.findClass(className);
            if (owlClass == null) continue;
            classes.add(owlClass);
        }
        piParameter.setLogicalInputs(classes);
        classes = new HashSet(spParameter.getLogicalOutputs().size());
        for (String className : spParameter.getLogicalOutputs()) {
            owlClass = this.findClass(className);
            if (owlClass == null) continue;
            classes.add(owlClass);
        }
        piParameter.setLogicalOutputs(classes);
        return piParameter;
    }

    @Override
    public int getAvailableSearchLevels() {
        return this.profileIndividualLocator.getAvailableSearchLevels();
    }

    @Override
    public void addServiceLocatorEventListener(ServiceLocatorEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeServiceLocatorEventListener(ServiceLocatorEventListener listener) {
        this.listeners.remove(listener);
    }

    private void sendClassNotFoundEvent(String className) {
        ClassNotFoundEvent e = new ClassNotFoundEvent(this, className);
        for (ServiceLocatorEventListener listener : this.listeners) {
            listener.classNotFound(e);
        }
    }

    @Override
    public void setServiceProfileParameter(ServiceProfileParameter searchParameter) {
        this.piParameter = this.findParameterClasses(searchParameter);
        this.profileIndividualLocator.setProfileIndividualParameter(this.piParameter);
        this.expectedSearchLevel = 0;
    }
}

