/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.DataSetFactory;
import com.hp.hpl.jena.query.DescribeBNodeClosure;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingImmutable;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.resultset.QueryIterSorted;
import com.hp.hpl.jena.query.resultset.ResultSetStream;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.util.iterator.QueryIterDistinct;
import com.hp.hpl.jena.query.util.iterator.QueryIterLimitOffset;
import com.hp.hpl.jena.query.util.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.query.util.iterator.QueryIterSingleton;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngine
implements QueryExecution {
    static Log log = LogFactory.getLog((Class)QueryEngine.class);
    Query query;
    static int queryCount = 0;
    boolean queryInitialised = false;
    int idQueryExecution;
    QueryIterator resultsIter;
    boolean active = false;
    QuerySolution startBinding = null;
    FileManager fileManager = FileManager.get();
    DataSet dataset = null;

    public QueryEngine(Query query2) {
        this.query = query2;
        this.idQueryExecution = ++queryCount;
    }

    public Query getQuery() {
        return this.query;
    }

    public void init() {
        if (this.queryInitialised) {
            return;
        }
        if (this.getDataSet() == null) {
            if (!(this.query.getGraphURIs() != null && this.query.getGraphURIs().size() != 0 || this.query.getNamedGraphURIs() != null && this.query.getNamedGraphURIs().size() != 0)) {
                throw new QueryException("No model for query");
            }
            String string = this.query.getBaseURI();
            if (string == null) {
                string = RelURI.chooseBaseURI();
            }
            log.debug((Object)("init: baseURI for query is: " + string));
            this.dataset = DataSetFactory.create(this.query.getGraphURIs(), this.query.getNamedGraphURIs(), this.fileManager, string);
        } else {
            log.debug((Object)"External data source for query");
        }
        if (this.query.getQueryBlock() != null) {
            this.query.getQueryBlock().setDataSet(this.dataset);
        } else {
            this.query.setQueryBlock(new ElementBlock(this.dataset, null));
        }
        this.active = true;
        this.queryInitialised = true;
    }

    public void setInitialBinding(QuerySolution querySolution) {
        this.startBinding = querySolution;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public DataSet getDataSet() {
        return this.dataset;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataset = dataSet;
    }

    public Model execConstruct() {
        ResultBinding resultBinding;
        QuerySolution querySolution;
        Object object;
        this.init();
        if (!this.query.isConstructType()) {
            throw new QueryException("Attempt to get a CONSTRUCT model from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        Model model = ModelFactory.createDefaultModel();
        this.insertPrefixesInto(model);
        model.setNsPrefixes((PrefixMapping)this.query.getQueryBlock().getDataSet().getModel());
        ResultSet resultSet = this.execInternal();
        HashSet hashSet = new HashSet();
        Template template = this.query.getConstructTemplate();
        while (resultSet.hasNext()) {
            object = new HashMap();
            querySolution = resultSet.nextSolution();
            resultBinding = (ResultBinding)querySolution;
            template.subst(hashSet, (Map)object, resultBinding.getBinding());
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            querySolution = (Triple)object.next();
            resultBinding = QueryEngineUtils.tripleToStatement(model, (Triple)querySolution);
            model.add((Statement)resultBinding);
        }
        this.close();
        return model;
    }

    public Model execDescribe() {
        RDFNode rDFNode;
        String string;
        Object object;
        Object object2;
        this.init();
        if (!this.query.isDescribeType()) {
            throw new QueryException("Attempt to get a DESCRIBE result from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        Model model = ModelFactory.createDefaultModel();
        this.insertPrefixesInto(model);
        model.setNsPrefixes((PrefixMapping)this.query.getQueryBlock().getDataSet().getModel());
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        ResultSet resultSet = this.execInternal();
        while (resultSet.hasNext()) {
            object2 = resultSet.nextSolution();
            object = this.query.getResultVars().iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                rDFNode = object2.get(string);
                hashSet.add(rDFNode);
            }
        }
        object2 = this.query.getResultURIs().iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            string = this.query.getQueryBlock().getDataSet().getModel();
            rDFNode = QueryEngineUtils.convertGraphNodeToRDFNode((Node)object, (Model)string);
            hashSet.add(rDFNode);
        }
        object2 = new DescribeBNodeClosure();
        object = hashSet.iterator();
        while (object.hasNext()) {
            string = (RDFNode)object.next();
            if (!(string instanceof Resource)) continue;
            object2.describe(model, (Resource)string);
        }
        this.close();
        return model;
    }

    public ResultSet execSelect() {
        this.init();
        if (!this.query.isSelectType()) {
            throw new QueryException("Attempt to have ResultSet from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        return this.execInternal();
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryException("Attempt to have boolean from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        ResultSet resultSet = this.execInternal();
        boolean bl = resultSet.hasNext();
        this.close();
        return bl;
    }

    private ResultSet execInternal() {
        this.resultsIter = null;
        try {
            this.init();
            ElementBlock elementBlock = this.query.getQueryBlock();
            if (elementBlock == null) {
                return new ResultSetStream(this.query, (QueryIterator)new QueryIterNullIterator());
            }
            QueryIterSingleton queryIterSingleton = new QueryIterSingleton(Binding.START);
            if (this.startBinding != null) {
                Binding binding = null;
                if (this.startBinding instanceof ResultBinding) {
                    binding = ((ResultBinding)this.startBinding).getBinding();
                } else {
                    binding = new BindingMap();
                    Iterator iterator = this.startBinding.varNames();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        RDFNode rDFNode = this.startBinding.get(string);
                        binding.add(string, rDFNode.asNode());
                    }
                }
                queryIterSingleton = new QueryIterSingleton(binding);
            }
            elementBlock.setDataSet(this.dataset);
            this.resultsIter = elementBlock.exec(new Mark(), queryIterSingleton);
            if (this.query.isDistinct()) {
                this.resultsIter = BindingImmutable.makeConverterIterator(this.query.getResultVars(), this.resultsIter);
                this.resultsIter = new QueryIterDistinct(this.resultsIter);
            }
            if (this.query.hasOrderBy()) {
                this.resultsIter = new QueryIterSorted(this.resultsIter, this.query.getOrderBy());
            }
            if (this.query.hasLimit() || this.query.hasOffset()) {
                long l;
                long l2 = this.query.getLimit();
                if (l2 == Query.NOLIMIT) {
                    l2 = Long.MAX_VALUE;
                }
                if ((l = this.query.getOffset()) == Query.NOLIMIT) {
                    l = 0L;
                }
                this.resultsIter = new QueryIterLimitOffset(this.resultsIter, l2, l);
            }
            ResultSetStream resultSetStream = new ResultSetStream(this.query, this.resultsIter);
            if (this.query.hasOrderBy()) {
                resultSetStream.setOrdered(true);
            }
            return resultSetStream;
        }
        catch (RuntimeException runtimeException) {
            if (this.resultsIter != null) {
                this.resultsIter.close();
            }
            throw runtimeException;
        }
    }

    public void abort() {
        this.resultsIter.close();
    }

    public void close() {
        if (!this.isActive()) {
            return;
        }
        if (this.resultsIter != null) {
            this.resultsIter.close();
            this.resultsIter = null;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private void insertPrefixesInto(Model model) {
        try {
            Model model2 = this.query.getQueryBlock().getDataSet().getModel();
            model.setNsPrefixes((PrefixMapping)model2);
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception exception) {
            log.warn((Object)("Exception in insertPrefixes: " + exception.getMessage()));
        }
    }

    private static String labelForQuery(Query query2) {
        if (query2.isSelectType()) {
            return "SELECT";
        }
        if (query2.isConstructType()) {
            return "CONSTRUCT";
        }
        if (query2.isDescribeType()) {
            return "DESCRIBE";
        }
        if (query2.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }
}

