/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.junit.QueryTest;
import com.hp.hpl.jena.query.junit.SerializerTest;
import com.hp.hpl.jena.query.junit.SyntaxTest;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.junit.TestManifestList;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.vocabulary.TestManifestX;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import java.io.PrintStream;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestScripts
extends TestSuite {
    protected static Log log = LogFactory.getLog((Class)TestScripts.class);
    private int subManifestCounter = 0;
    static int arqTestCounter = 0;

    public TestScripts(String string) {
        super(string);
    }

    public static TestSuite makeTestSuite(String string, String string2) {
        TestScripts testScripts = new TestScripts(string, string2);
        return testScripts;
    }

    public TestScripts(String string, String string2) {
        super(string);
        this.addTests(string2);
    }

    public void addTest(TestItem testItem) {
        this.addTest("ARQ-test-" + ++arqTestCounter, testItem);
    }

    public void addTest(String string, TestItem testItem) {
        this.addTest(null, string, testItem);
    }

    public void addTest(Model model, String string, TestItem testItem) {
        FileManager fileManager = FileManager.get();
        TestCase testCase = null;
        if (testItem.getTestType() != null) {
            if (testItem.getTestType().equals(TestManifestX.TestSyntax)) {
                testCase = new SyntaxTest(string, testItem);
            }
            if (testItem.getTestType().equals(TestManifestX.TestBadSyntax)) {
                testCase = new SyntaxTest(string, testItem, false);
            }
            if (testItem.getTestType().equals(TestManifestX.TestSerialization)) {
                testCase = new SerializerTest(string, testItem);
            }
            if (testItem.getTestType().equals(TestManifestX.TestQuery)) {
                testCase = new QueryTest(model, string, fileManager, testItem);
            }
        }
        if (testCase == null) {
            testCase = new QueryTest(model, string, fileManager, testItem);
        }
        this.addTest((Test)testCase);
    }

    protected void addTests(String string) {
        this.addTests(null, string);
    }

    protected void addTests(Model model, String string) {
        Object object;
        PrintStream printStream = System.out;
        String string2 = RelURI.chooseBaseURI(string);
        Model model2 = null;
        try {
            model2 = FileManager.get().loadModel(string, string2, null);
        }
        catch (JenaException jenaException) {
            log.warn((Object)("Problems loading " + string + ": " + jenaException.getMessage()));
            return;
        }
        catch (Exception exception) {
            log.warn((Object)("Problems loading " + string), (Throwable)exception);
            return;
        }
        TestManifestList testManifestList = new TestManifestList(model2);
        Iterator iterator = testManifestList.includedManifests();
        while (iterator.hasNext()) {
            log.info((Object)"Untested : included manifests");
            object = (String)iterator.next();
            String string3 = this.getName() + ++this.subManifestCounter;
            TestSuite testSuite = TestScripts.makeTestSuite(string3, (String)object);
            this.addTest((Test)testSuite);
        }
        iterator = testManifestList.iterator();
        while (iterator.hasNext()) {
            object = (TestItem)iterator.next();
            ((TestItem)object).setBaseURI(string2);
            this.addTest(model, ((TestItem)object).getName(), (TestItem)object);
        }
    }
}

