/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.Set;

public abstract class CompositionBase
extends GraphBase {
    public int graphBaseSize() {
        return CompositionBase.countIterator(GraphUtil.findAll(this));
    }

    protected void die(String string) {
        throw new UnsupportedOperationException(string);
    }

    public static Filter reject(ClosableIterator closableIterator) {
        final Set set = IteratorCollection.iteratorToSet(closableIterator);
        return new Filter(){

            public boolean accept(Object object) {
                return !set.contains(object);
            }
        };
    }

    public static ClosableIterator butNot(ClosableIterator closableIterator, ClosableIterator closableIterator2) {
        return new FilterIterator(CompositionBase.reject(closableIterator2), closableIterator);
    }

    public static ExtendedIterator recording(final ClosableIterator closableIterator, final Set set) {
        return new NiceIterator(){

            public void remove() {
                closableIterator.remove();
            }

            public boolean hasNext() {
                return closableIterator.hasNext();
            }

            public Object next() {
                Object e = closableIterator.next();
                set.add(e);
                return e;
            }

            public void close() {
                closableIterator.close();
            }
        };
    }

    public static ExtendedIterator rejecting(ExtendedIterator extendedIterator, final Set set) {
        Filter filter = new Filter(){

            public boolean accept(Object object) {
                return set.contains(object);
            }
        };
        return extendedIterator.filterDrop(filter);
    }

    public static ExtendedIterator rejecting(ExtendedIterator extendedIterator, final Graph graph) {
        Filter filter = new Filter(){

            public boolean accept(Object object) {
                return graph.contains((Triple)object);
            }
        };
        return extendedIterator.filterDrop(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countIterator(ClosableIterator closableIterator) {
        try {
            int n = 0;
            while (closableIterator.hasNext()) {
                ++n;
                closableIterator.next();
            }
            int n2 = n;
            return n2;
        }
        finally {
            closableIterator.close();
        }
    }

    public static Filter ifIn(ClosableIterator closableIterator) {
        final Set set = IteratorCollection.iteratorToSet(closableIterator);
        return new Filter(){

            public boolean accept(Object object) {
                return set.contains(object);
            }
        };
    }

    public static Filter ifIn(final Graph graph) {
        return new Filter(){

            public boolean accept(Object object) {
                return graph.contains((Triple)object);
            }
        };
    }
}

