/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.List;
import java.util.Map;

public class PolyadicPrefixMappingImpl
extends PrefixMappingImpl
implements PrefixMapping {
    private Polyadic poly;
    private PrefixMapping pending = new PrefixMappingImpl();

    public PolyadicPrefixMappingImpl(Polyadic polyadic) {
        this.poly = polyadic;
    }

    private PrefixMapping getBaseMapping() {
        Graph graph = this.poly.getBaseGraph();
        return graph == null ? this.pending : graph.getPrefixMapping();
    }

    public PrefixMapping setNsPrefix(String string, String string2) {
        this.checkUnlocked();
        this.getBaseMapping().setNsPrefix(string, string2);
        return this;
    }

    public PrefixMapping removeNsPrefix(String string) {
        this.checkUnlocked();
        this.getBaseMapping().removeNsPrefix(string);
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping prefixMapping) {
        return this.setNsPrefixes(prefixMapping.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map map) {
        this.checkUnlocked();
        this.getBaseMapping().setNsPrefixes(map);
        return this;
    }

    public String getNsPrefixURI(String string) {
        PrefixMapping prefixMapping = this.getBaseMapping();
        String string2 = prefixMapping.getNsPrefixURI(string);
        if (string2 == null) {
            List list = this.poly.getSubGraphs();
            for (int i = 0; i < list.size(); ++i) {
                String string3 = ((Graph)list.get(i)).getPrefixMapping().getNsPrefixURI(string);
                if (string3 == null) continue;
                return string3;
            }
        }
        return string2;
    }

    public Map getNsPrefixMap() {
        Map map = CollectionFactory.createHashedMap();
        List list = this.poly.getSubGraphs();
        for (int i = 0; i < list.size(); ++i) {
            map.putAll(((Graph)list.get(i)).getPrefixMapping().getNsPrefixMap());
        }
        map.putAll(this.getBaseMapping().getNsPrefixMap());
        return map;
    }

    public String getNsURIPrefix(String string) {
        String string2 = this.getBaseMapping().getNsURIPrefix(string);
        if (string2 == null) {
            List list = this.poly.getSubGraphs();
            for (int i = 0; i < list.size(); ++i) {
                String string3 = ((Graph)list.get(i)).getPrefixMapping().getNsURIPrefix(string);
                if (string3 == null) continue;
                return string3;
            }
        }
        return string2;
    }

    public String expandPrefix(String string) {
        String string2 = this.getBaseMapping().expandPrefix(string);
        if (string2.equals(string)) {
            List list = this.poly.getSubGraphs();
            for (int i = 0; i < list.size(); ++i) {
                String string3 = ((Graph)list.get(i)).getPrefixMapping().expandPrefix(string);
                if (string3.equals(string)) continue;
                return string3;
            }
        }
        return string2;
    }

    public String toString() {
        return "<polyadic prefix map>";
    }

    public String shortForm(String string) {
        String string2 = this.getBaseMapping().shortForm(string);
        if (string2.equals(string)) {
            List list = this.poly.getSubGraphs();
            for (int i = 0; i < list.size(); ++i) {
                String string3 = ((Graph)list.get(i)).getPrefixMapping().shortForm(string);
                if (string3.equals(string)) continue;
                return string3;
            }
        }
        return string2;
    }

    public String qnameFor(String string) {
        String string2 = this.getBaseMapping().qnameFor(string);
        if (string2 == null) {
            List list = this.poly.getSubGraphs();
            for (int i = 0; i < list.size(); ++i) {
                String string3 = ((Graph)list.get(i)).getPrefixMapping().qnameFor(string);
                if (string3 == null) continue;
                return string3;
            }
        }
        return string2;
    }
}

