/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileGraphMaker
extends BaseGraphMaker {
    private String fileBase;
    private boolean deleteOnClose;
    private Map created = CollectionFactory.createHashedMap();
    private static Map1 unconvert = new Map1(){

        public Object map1(Object object) {
            return FileGraphMaker.toGraphname((String)object);
        }
    };

    public FileGraphMaker(String string) {
        this(string, ReificationStyle.Minimal);
    }

    public FileGraphMaker(String string, ReificationStyle reificationStyle) {
        this(string, reificationStyle, false);
    }

    public FileGraphMaker(String string, ReificationStyle reificationStyle, boolean bl) {
        super(reificationStyle);
        this.fileBase = string;
        this.deleteOnClose = bl;
    }

    public Node getMakerClass() {
        return JenaModelSpec.FileMakerSpec.asNode();
    }

    public String getFileBase() {
        return this.fileBase;
    }

    protected void augmentDescription(Graph graph, Node node) {
        graph.add(Triple.create(node, JenaModelSpec.fileBase.asNode(), Node.createLiteral(this.fileBase, "", false)));
    }

    public Graph createGraph() {
        return FileGraph.create();
    }

    public Graph createGraph(String string, boolean bl) {
        File file = this.withRoot(string);
        FileGraph fileGraph = (FileGraph)this.created.get(file);
        if (fileGraph == null) {
            return this.remember(file, new FileGraph(file, true, bl, this.style));
        }
        if (bl) {
            throw new AlreadyExistsException(string);
        }
        return fileGraph.openAgain();
    }

    public Graph openGraph(String string, boolean bl) {
        File file = this.withRoot(string);
        return this.created.containsKey(file) ? ((FileGraph)this.created.get(file)).openAgain() : this.remember(file, new FileGraph(file, false, bl, this.style));
    }

    private File withRoot(String string) {
        return new File(this.fileBase, FileGraphMaker.toFilename(string));
    }

    public static String toFilename(String string) {
        return FileGraphMaker.replaceBy(string, "_/:", "USC");
    }

    private static String replaceBy(String string, String string2, String string3) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 10);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = string2.indexOf(c);
            if (n2 < 0) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_').append(string3.charAt(n2));
        }
        return stringBuffer.toString();
    }

    public static String toGraphname(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while ((n = string.indexOf(95, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            char c = string.charAt(n + 1);
            if (c == 'S') {
                stringBuffer.append('/');
            } else if (c == 'U') {
                stringBuffer.append('_');
            } else if (c == 'C') {
                stringBuffer.append(':');
            }
            n2 = n + 2;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public void removeGraph(String string) {
        this.forget(this.withRoot(string)).delete();
    }

    private FileGraph remember(File file, FileGraph fileGraph) {
        this.created.put(file, fileGraph);
        return fileGraph;
    }

    private File forget(File file) {
        this.created.remove(file);
        return file;
    }

    public boolean hasGraph(String string) {
        File file = this.withRoot(string);
        return this.created.containsKey(file) || file.exists();
    }

    public void close() {
        if (this.deleteOnClose) {
            Iterator iterator = this.created.keySet().iterator();
            while (iterator.hasNext()) {
                ((File)iterator.next()).delete();
            }
        }
    }

    public static FilenameFilter graphName() {
        return new FilenameFilter(){

            public boolean accept(File file, String string) {
                return !new File(file, string).isDirectory() && FileGraph.isPlausibleGraphName(string);
            }
        };
    }

    public ExtendedIterator listGraphs() {
        String[] stringArray = new File(this.fileBase).list(FileGraphMaker.graphName());
        Set set = CollectionFactory.createHashedSet(Arrays.asList(stringArray));
        Iterator iterator = this.created.keySet().iterator();
        while (iterator.hasNext()) {
            set.add(((File)iterator.next()).getName());
        }
        return WrappedIterator.create(set.iterator()).mapWith(unconvert);
    }
}

