/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees;

import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTreeGenerator;
import com.hp.hpl.jena.graph.query.regexptrees.SimpleGenerator;
import com.hp.hpl.jena.graph.query.regexptrees.Text;
import java.util.ArrayList;

public class PerlPatternParser {
    protected final String toParse;
    protected int pointer;
    protected final int limit;
    protected RegexpTreeGenerator generator;
    protected int matchPointsSeen;
    public static final String digits = "0123456789";
    public static final String wordChars = "0123456789abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public PerlPatternParser(String string) {
        this(string, new SimpleGenerator());
    }

    public PerlPatternParser(String string, RegexpTreeGenerator regexpTreeGenerator) {
        this.toParse = string;
        this.limit = string.length();
        this.generator = regexpTreeGenerator;
    }

    public static RegexpTree parse(String string) {
        return new PerlPatternParser(string).parseAlts();
    }

    public static RegexpTree parse(String string, RegexpTreeGenerator regexpTreeGenerator) {
        return new PerlPatternParser(string, regexpTreeGenerator).parseAlts();
    }

    public String getString() {
        return this.toParse;
    }

    public int getPointer() {
        return this.pointer;
    }

    protected char nextChar() {
        return this.toParse.charAt(this.pointer++);
    }

    public RegexpTree parseAtom() {
        if (this.pointer < this.limit) {
            char c = this.nextChar();
            switch (c) {
                case '.': {
                    return this.generator.getAnySingle();
                }
                case '^': {
                    return this.generator.getStartOfLine();
                }
                case '$': {
                    return this.generator.getEndOfLine();
                }
                case '|': {
                    --this.pointer;
                    return this.generator.getNothing();
                }
                case '[': {
                    return this.parseClass();
                }
                case ')': {
                    --this.pointer;
                    return this.generator.getNothing();
                }
                case '(': {
                    return this.parseParens();
                }
                case '\\': {
                    return this.parseBackslash();
                }
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    throw new SyntaxException("unbound quantifier " + c);
                }
            }
            return this.generator.getText(c);
        }
        return this.generator.getNothing();
    }

    protected RegexpTree parseClass() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.parseClassNegation();
        while ((n = this.nextClassChar()) != 93) {
            if (n == 45 && stringBuffer.length() > 0) {
                char c = (char)(stringBuffer.charAt(stringBuffer.length() - 1) + '\u0001');
                char c2 = (char)Math.abs(this.nextClassChar());
                for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
                    stringBuffer.append(c3);
                }
                continue;
            }
            stringBuffer.append((char)Math.abs(n));
        }
        ++this.pointer;
        return this.generator.getClass(stringBuffer.toString(), bl);
    }

    private int nextClassChar() {
        char c = this.nextChar();
        if (c == '\\') {
            RegexpTree regexpTree = this.parseAtom();
            if (regexpTree instanceof Text) {
                return -((Text)regexpTree).getString().charAt(0);
            }
            throw new SyntaxException("not allowed in class");
        }
        return c;
    }

    protected boolean parseClassNegation() {
        if (this.toParse.charAt(this.pointer) == '^') {
            ++this.pointer;
            return true;
        }
        return false;
    }

    protected RegexpTree parseParens() {
        RegexpTree regexpTree = this.parseAlts();
        if (this.pointer < this.limit && this.toParse.charAt(this.pointer) == ')') {
            ++this.pointer;
        } else {
            throw new SyntaxException("missing closing bracket");
        }
        ++this.matchPointsSeen;
        return this.generator.getParen(regexpTree, this.matchPointsSeen);
    }

    private RegexpTree parseBackslash() {
        char c = this.nextChar();
        if ("bBAZnrtfdDwWSsxc0123456789".indexOf(c) < 0) {
            return this.generator.getText(c);
        }
        if (c == 'n') {
            return this.generator.getText('\n');
        }
        if (c == 'r') {
            return this.generator.getText('\r');
        }
        if (c == 'f') {
            return this.generator.getText('\f');
        }
        if (c == 't') {
            return this.generator.getText('\t');
        }
        if (c == 's') {
            return this.generator.getClass(" \r\n\t\f", false);
        }
        if (c == 'S') {
            return this.generator.getClass(" \r\n\t\f", true);
        }
        if (c == 'd') {
            return this.generator.getClass(digits, false);
        }
        if (c == 'D') {
            return this.generator.getClass(digits, true);
        }
        if (c == 'w') {
            return this.generator.getClass(wordChars, false);
        }
        if (c == 'W') {
            return this.generator.getClass(wordChars, true);
        }
        if ('0' <= c && c <= '9') {
            return this.backReferenceOrOctalChar(c);
        }
        if (c == 'x') {
            return this.hexEscape();
        }
        if (c == 'c') {
            return this.control(this.nextChar());
        }
        throw new SyntaxException("can't do \\" + c + " yet");
    }

    protected RegexpTree control(char c) {
        return Text.create((char)(c - 65 + 1));
    }

    protected RegexpTree hexEscape() {
        char c = this.nextChar();
        char c2 = this.nextChar();
        return Text.create((char)(this.deHex(c) * 16 + this.deHex(c2)));
    }

    private int deHex(char c) {
        if (Character.isDigit(c)) {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + c - 97;
        }
        if ('A' <= c && c <= 'F') {
            return 10 + c - 65;
        }
        throw new SyntaxException("'" + c + "' is not a hex digit");
    }

    protected RegexpTree backReferenceOrOctalChar(char c) {
        char[] cArray = new char[20];
        int n = 0;
        cArray[n++] = c;
        while (this.pointer < this.limit && Character.isDigit(c = this.nextChar())) {
            cArray[n++] = c;
        }
        char c2 = this.numeric(cArray, 10, n);
        return '\u0000' < c2 && c2 <= this.matchPointsSeen ? this.generator.getBackReference(c2) : this.generator.getText(this.numeric(cArray, 8, n));
    }

    protected char numeric(char[] cArray, int n, int n2) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            n4 = n4 * n + (cArray[i] - 48);
        }
        return (char)n4;
    }

    public RegexpTree parseQuantifier(RegexpTree regexpTree) {
        if (this.pointer < this.limit) {
            char c = this.toParse.charAt(this.pointer);
            switch (c) {
                case '*': {
                    ++this.pointer;
                    return this.generator.getZeroOrMore(regexpTree);
                }
                case '+': {
                    ++this.pointer;
                    return this.generator.getOneOrMore(regexpTree);
                }
                case '?': {
                    ++this.pointer;
                    return this.generator.getOptional(regexpTree);
                }
                case '{': {
                    throw new SyntaxException("numeric quantifiers not done yet");
                }
            }
        }
        return regexpTree;
    }

    public RegexpTree parseElement() {
        return this.parseQuantifier(this.parseAtom());
    }

    public RegexpTree parseSeq() {
        RegexpTree regexpTree;
        ArrayList<RegexpTree> arrayList = new ArrayList<RegexpTree>();
        while (!(regexpTree = this.parseElement()).equals(this.generator.getNothing())) {
            arrayList.add(regexpTree);
        }
        return this.generator.getSequence(arrayList);
    }

    public RegexpTree parseAlts() {
        ArrayList<RegexpTree> arrayList = new ArrayList<RegexpTree>();
        while (true) {
            arrayList.add(this.parseSeq());
            if (this.pointer >= this.limit || this.toParse.charAt(this.pointer) != '|') break;
            ++this.pointer;
        }
        return this.generator.getAlternatives(arrayList);
    }

    public static class SyntaxException
    extends RuntimeException {
        public SyntaxException(String string) {
            super(string);
        }
    }
}

