/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees.test;

import com.hp.hpl.jena.graph.query.regexptrees.Alternatives;
import com.hp.hpl.jena.graph.query.regexptrees.AnyOf;
import com.hp.hpl.jena.graph.query.regexptrees.AnySingle;
import com.hp.hpl.jena.graph.query.regexptrees.BackReference;
import com.hp.hpl.jena.graph.query.regexptrees.EndOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.NoneOf;
import com.hp.hpl.jena.graph.query.regexptrees.Nothing;
import com.hp.hpl.jena.graph.query.regexptrees.OneOrMore;
import com.hp.hpl.jena.graph.query.regexptrees.Optional;
import com.hp.hpl.jena.graph.query.regexptrees.Paren;
import com.hp.hpl.jena.graph.query.regexptrees.PerlPatternParser;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import com.hp.hpl.jena.graph.query.regexptrees.Sequence;
import com.hp.hpl.jena.graph.query.regexptrees.SimpleGenerator;
import com.hp.hpl.jena.graph.query.regexptrees.StartOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.Text;
import com.hp.hpl.jena.graph.query.regexptrees.ZeroOrMore;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.Arrays;
import junit.framework.TestSuite;

public class TestPerlyParser
extends GraphTestBase {
    public TestPerlyParser(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPerlyParser.class);
    }

    public void testAlternateGenerator() {
        SimpleGenerator simpleGenerator = new SimpleGenerator(){

            public RegexpTree getAnySingle() {
                throw new FlagException();
            }
        };
        PerlPatternParser perlPatternParser = new PerlPatternParser(".", simpleGenerator);
        try {
            perlPatternParser.parseAtom();
            TestPerlyParser.fail((String)"should be using supplied generator");
        }
        catch (FlagException flagException) {
            TestPerlyParser.pass();
        }
    }

    public void testLit() {
        TestPerlyParser.assertEquals((Object)Text.create("a"), (Object)Text.create("a"));
        TestPerlyParser.assertDiffer(Text.create("a"), Text.create("b"));
        TestPerlyParser.assertEquals((int)Text.create("aga").hashCode(), (int)Text.create("aga").hashCode());
    }

    public void testInitialParserState() {
        TestPerlyParser.assertEquals((int)0, (int)new PerlPatternParser("hello").getPointer());
        TestPerlyParser.assertEquals((String)"hello", (String)new PerlPatternParser("hello").getString());
    }

    public void testLetterAtoms() {
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            if (!Character.isLetter(c)) continue;
            PerlPatternParser perlPatternParser = new PerlPatternParser("" + c);
            TestPerlyParser.assertEquals((Object)Text.create(c), (Object)perlPatternParser.parseAtom());
            TestPerlyParser.assertEquals((int)1, (int)perlPatternParser.getPointer());
        }
    }

    public void testEmptyExpression() {
        TestPerlyParser.assertEquals((Object)new Nothing(), (Object)this.element(""));
    }

    public void testDotAtom() {
        this.testSimpleSpecialAtom(RegexpTree.ANY, ".");
    }

    public void testHatAtom() {
        this.testSimpleSpecialAtom(RegexpTree.SOL, "^");
    }

    public void testDollarAtom() {
        this.testSimpleSpecialAtom(RegexpTree.EOL, "$");
    }

    public void testTerminatorsReturnNull() {
        TestPerlyParser.assertEquals((Object)new Nothing(), (Object)this.element("|"));
    }

    public void testSimpleBackslashEscapes() {
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            if ("bBAZnrtfdDwWSsxc0123456789".indexOf(c) >= 0) continue;
            TestPerlyParser.assertEquals((Object)Text.create(c), (Object)new PerlPatternParser("\\" + c).parseAtom());
        }
    }

    public void testSpecialBackslashEscapes() {
        String string = "bBAZ";
        for (int i = 0; i < string.length(); ++i) {
            try {
                new PerlPatternParser("\\" + string.charAt(i)).parseAtom();
                TestPerlyParser.fail((String)("backslash escape " + string.charAt(i)));
                continue;
            }
            catch (PerlPatternParser.SyntaxException syntaxException) {
                TestPerlyParser.pass();
            }
        }
    }

    public void testWordEscapes() {
        String string = "abcdefghijklmnopqrstuvwxyz";
        String string2 = "0123456789" + string + "_" + string.toUpperCase();
        TestPerlyParser.assertEquals((Object)new AnyOf(string2), (Object)this.element("\\w"));
        TestPerlyParser.assertEquals((Object)new NoneOf(string2), (Object)this.element("\\W"));
    }

    public void testDigitEscapes() {
        TestPerlyParser.assertEquals((Object)new AnyOf("0123456789"), (Object)this.element("\\d"));
        TestPerlyParser.assertEquals((Object)new NoneOf("0123456789"), (Object)this.element("\\D"));
    }

    public void testWhitespaceEscapes() {
        TestPerlyParser.assertEquals((Object)Text.create("\n"), (Object)this.element("\\n"));
        TestPerlyParser.assertEquals((Object)Text.create("\t"), (Object)this.element("\\t"));
        TestPerlyParser.assertEquals((Object)Text.create("\f"), (Object)this.element("\\f"));
        TestPerlyParser.assertEquals((Object)Text.create("\r"), (Object)this.element("\\r"));
        TestPerlyParser.assertEquals((Object)new AnyOf(" \r\n\t\f"), (Object)this.element("\\s"));
        TestPerlyParser.assertEquals((Object)new NoneOf(" \r\n\t\f"), (Object)this.element("\\S"));
    }

    public void testHexEscapes() {
        this.assertParse(Text.create("\u00ac"), "\\xac");
        this.assertParse(Text.create("\u00ff"), "\\xff");
        this.assertParse(Text.create("\u0012"), "\\x12");
        this.assertParse(Text.create("\u00af"), "\\xAF");
    }

    public void testControlEscapes() {
        this.assertParse(Text.create("\u0001"), "\\cA");
        this.assertParse(Text.create("\u001a"), "\\cZ");
    }

    public void testNoQuantifier() {
        RegexpTree regexpTree = RegexpTree.ANY;
        TestPerlyParser.assertSame((Object)regexpTree, (Object)this.quantifier("", regexpTree));
        TestPerlyParser.assertSame((Object)regexpTree, (Object)this.quantifier("x", regexpTree));
        TestPerlyParser.assertSame((Object)regexpTree, (Object)this.quantifier("[", regexpTree));
        TestPerlyParser.assertSame((Object)regexpTree, (Object)this.quantifier("(", regexpTree));
        TestPerlyParser.assertSame((Object)regexpTree, (Object)this.quantifier(".", regexpTree));
        TestPerlyParser.assertSame((Object)regexpTree, (Object)this.quantifier("\\", regexpTree));
    }

    public void testStarQuantifier() {
        RegexpTree regexpTree = RegexpTree.EOL;
        TestPerlyParser.assertEquals((Object)new ZeroOrMore(regexpTree), (Object)this.quantifier("*", regexpTree));
    }

    public void testPlusQuantifier() {
        RegexpTree regexpTree = RegexpTree.SOL;
        TestPerlyParser.assertEquals((Object)new OneOrMore(regexpTree), (Object)this.quantifier("+", regexpTree));
    }

    public void testQueryQuantifier() {
        RegexpTree regexpTree = RegexpTree.ANY;
        TestPerlyParser.assertEquals((Object)new Optional(regexpTree), (Object)this.quantifier("?", regexpTree));
    }

    public void testUnboundQuantifiers() {
        this.testUnboundQuantifier("*");
        this.testUnboundQuantifier("+");
        this.testUnboundQuantifier("?");
        this.testUnboundQuantifier("{");
    }

    private void testUnboundQuantifier(String string) {
        PerlPatternParser perlPatternParser = new PerlPatternParser(string);
        try {
            perlPatternParser.parseElement();
            TestPerlyParser.fail((String)("must trap unbound quantifier " + string));
        }
        catch (PerlPatternParser.SyntaxException syntaxException) {
            TestPerlyParser.pass();
        }
    }

    public void testUnitSeq() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("x");
        TestPerlyParser.assertEquals((Object)Text.create("x"), (Object)perlPatternParser.parseSeq());
    }

    public void testSeq() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("^.$");
        TestPerlyParser.assertEquals((Object)this.seq3(new StartOfLine(), new AnySingle(), new EndOfLine()), (Object)perlPatternParser.parseSeq());
    }

    public void testBracketConstruction() {
        this.assertParse(new Paren(Text.create("x")), "(x)");
    }

    public void testBracketClosure() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("()y");
        TestPerlyParser.assertEquals((Object)this.seq2(new Paren(new Nothing()), Text.create("y")), (Object)perlPatternParser.parseAlts());
    }

    public void testDetectsMissingClosingBracket() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("(x");
        try {
            perlPatternParser.parseAlts();
            TestPerlyParser.fail((String)"should detect missing close bracket");
        }
        catch (PerlPatternParser.SyntaxException syntaxException) {
            TestPerlyParser.pass();
        }
    }

    public void testAlt() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("abc");
        PerlPatternParser perlPatternParser2 = new PerlPatternParser("def");
        PerlPatternParser perlPatternParser3 = new PerlPatternParser("abc|def");
        TestPerlyParser.assertEquals((Object)this.alt(perlPatternParser.parseSeq(), perlPatternParser2.parseSeq()), (Object)perlPatternParser3.parseAlts());
    }

    public void testSimpleClass() {
        this.assertParse(new AnyOf("x1B"), "[x1B]");
    }

    public void testSimpleClassNegated() {
        this.assertParse(new NoneOf("b0#"), "[^b0#]");
    }

    public void testClassRangeAlphabet() {
        this.assertParse(new AnyOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "[A-Z]");
    }

    public void testClassRangeSomeLetters() {
        this.assertParse(new AnyOf("abcdef"), "[a-f]");
    }

    public void testClassRangeDigits() {
        this.assertParse(new AnyOf("abc0123456789rst"), "[a-c0-9r-t]");
    }

    public void testClassHats() {
        this.assertParse(new AnyOf("ab^cd"), "[ab^cd]");
    }

    public void testClassRange() {
        this.assertParse(new AnyOf("-R"), "[-R]");
    }

    public void testClassBackslash() {
        this.assertParse(new AnyOf("]"), "[\\]]");
    }

    public void testBackReference() {
        this.assertParse(this.seq2(new Paren(Text.create("x")), new BackReference(1)), "(x)\\1");
    }

    public void testOctalNonBackReference() {
        this.assertParse(this.seq2(new Paren(Text.create("x")), Text.create("\b")), "(x)\\10");
    }

    protected RegexpTree seq2(RegexpTree regexpTree, RegexpTree regexpTree2) {
        return Sequence.create(Arrays.asList(regexpTree, regexpTree2));
    }

    protected RegexpTree seq3(RegexpTree regexpTree, RegexpTree regexpTree2, RegexpTree regexpTree3) {
        return Sequence.create(Arrays.asList(regexpTree, regexpTree2, regexpTree3));
    }

    protected RegexpTree alt(RegexpTree regexpTree, RegexpTree regexpTree2) {
        return Alternatives.create(Arrays.asList(regexpTree, regexpTree2));
    }

    public void testPerlParse() {
        TestPerlyParser.assertTrue((boolean)(PerlPatternParser.parse("this is|a pattern") instanceof Alternatives));
        TestPerlyParser.assertTrue((boolean)(PerlPatternParser.parse("this is|a pattern", new SimpleGenerator()) instanceof Alternatives));
    }

    public void testOldSeq() {
        PerlPatternParser perlPatternParser = new PerlPatternParser("hello");
        TestPerlyParser.assertEquals((Object)Text.create("h"), (Object)perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals((int)1, (int)perlPatternParser.getPointer());
        TestPerlyParser.assertEquals((Object)Text.create("e"), (Object)perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals((int)2, (int)perlPatternParser.getPointer());
        TestPerlyParser.assertEquals((Object)Text.create("l"), (Object)perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals((int)3, (int)perlPatternParser.getPointer());
        TestPerlyParser.assertEquals((Object)Text.create("l"), (Object)perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals((int)4, (int)perlPatternParser.getPointer());
        TestPerlyParser.assertEquals((Object)Text.create("o"), (Object)perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals((int)5, (int)perlPatternParser.getPointer());
        TestPerlyParser.assertEquals((Object)new Nothing(), (Object)perlPatternParser.parseAtom());
    }

    public void assertParse(RegexpTree regexpTree, String string) {
        TestPerlyParser.assertEquals((Object)regexpTree, (Object)new PerlPatternParser(string).parseAlts());
    }

    public void testSimpleSpecialAtom(Object object, String string) {
        PerlPatternParser perlPatternParser = new PerlPatternParser(string);
        TestPerlyParser.assertEquals((Object)object, (Object)perlPatternParser.parseAtom());
        TestPerlyParser.assertEquals((int)1, (int)perlPatternParser.getPointer());
    }

    protected RegexpTree quantifier(String string, RegexpTree regexpTree) {
        return new PerlPatternParser(string).parseQuantifier(regexpTree);
    }

    protected RegexpTree element(String string) {
        return new PerlPatternParser(string).parseElement();
    }

    protected static class FlagException
    extends RuntimeException {
        protected FlagException() {
        }
    }
}

