/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

public class TestExpressionConstraints
extends QueryTestBase {
    protected static final Expression eTRUE = Expression.TRUE;
    protected static final Expression eFALSE = Expression.FALSE;

    public TestExpressionConstraints(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestExpressionConstraints.class);
    }

    public void testConstraintFALSE() {
        Graph graph = TestExpressionConstraints.graphWith("x R y; a P b");
        Query query = new Query().addMatch(X, ANY, ANY).addConstraint(eFALSE);
        TestExpressionConstraints.assertFalse((boolean)query.executeBindings(graph, this.justX).hasNext());
    }

    public void testConstraintTRUE() {
        Graph graph = TestExpressionConstraints.graphWith("x R y; a P b");
        Query query = new Query().addMatch(X, ANY, ANY).addConstraint(eTRUE);
        TestExpressionConstraints.assertTrue((boolean)query.executeBindings(graph, this.justX).hasNext());
    }

    public void testConstraintNE1() {
        Graph graph = TestExpressionConstraints.graphWith("x R y; a P a");
        Query query = new Query().addMatch(X, ANY, Y).addConstraint(this.notEqual(X, Y));
        Set set = CollectionFactory.createHashedSet();
        set.add(TestExpressionConstraints.node("x"));
        TestExpressionConstraints.assertEquals((Object)set, (Object)TestExpressionConstraints.iteratorToSet(query.executeBindings(graph, this.justX).mapWith(getFirst)));
    }

    public void testConstraintNE2() {
        Graph graph = TestExpressionConstraints.graphWith("x R y; a P a");
        Query query = new Query().addMatch(X, ANY, Y).addConstraint(this.notEqual(X, Y));
        Set set = CollectionFactory.createHashedSet();
        set.add(TestExpressionConstraints.node("x"));
        TestExpressionConstraints.assertEquals((Object)set, (Object)TestExpressionConstraints.iteratorToSet(query.executeBindings(graph, this.justX).mapWith(getFirst)));
    }

    public void testConstraintNE3() {
        Graph graph = TestExpressionConstraints.graphWith("x R a; y P b; z Q c");
        Query query = new Query().addMatch(X, ANY, ANY).addConstraint(this.notEqual(X, TestExpressionConstraints.node("y")));
        Set set = CollectionFactory.createHashedSet();
        set.add(TestExpressionConstraints.node("x"));
        set.add(TestExpressionConstraints.node("z"));
        TestExpressionConstraints.assertEquals((Object)set, (Object)TestExpressionConstraints.iteratorToSet(query.executeBindings(graph, this.justX).mapWith(getFirst)));
    }

    public void testConstraintNE4() {
        Graph graph = TestExpressionConstraints.graphWith("x R a; y P b; z Q c");
        Query query = new Query().addMatch(X, ANY, ANY).addConstraint(this.notEqual(X, TestExpressionConstraints.node("y"))).addConstraint(this.notEqual(X, TestExpressionConstraints.node("x")));
        Set set = CollectionFactory.createHashedSet();
        set.add(TestExpressionConstraints.node("z"));
        TestExpressionConstraints.assertEquals((Object)set, (Object)TestExpressionConstraints.iteratorToSet(query.executeBindings(graph, this.justX).mapWith(getFirst)));
    }

    public void testVI() {
        VI vI = new VI().set("X", 1).set("Y", 2).set("Z", 3);
        TestExpressionConstraints.assertEquals((int)1, (int)vI.indexOf("X"));
        TestExpressionConstraints.assertEquals((int)2, (int)vI.indexOf("Y"));
        TestExpressionConstraints.assertEquals((int)3, (int)vI.indexOf("Z"));
    }

    public void testNE() {
        Expression expression = this.areEqual(X, Y);
        VI vI = new VI().set("X", 1).set("Y", 2);
        IV iV = new IV().set(1, "something").set(2, "else");
        TestExpressionConstraints.assertEquals((boolean)false, (boolean)expression.prepare(vI).evalBool(iV));
    }

    public void testVVTrue() {
        TestExpressionConstraints.assertEquals((boolean)true, (boolean)Expression.TRUE.prepare(this.noVariables).evalBool(noIVs));
    }

    public void testVVFalse() {
        TestExpressionConstraints.assertEquals((boolean)false, (boolean)Expression.FALSE.prepare(this.noVariables).evalBool(noIVs));
    }

    public void testVVMatches() {
        VI vI = new VI().set("X", 0).set("Y", 1);
        IV iV = new IV().set(0, "hello").set(1, "ell");
        TestExpressionConstraints.assertEquals((boolean)true, (boolean)this.matches(X, Y).prepare(vI).evalBool(iV));
    }

    public void testPrepareNE() {
        Expression expression = this.notEqual(X, Y);
        Mapping mapping = new Mapping(new Node[0]);
    }

    public void testURIs() {
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/NE", (String)this.notEqual(X, Y).getFun());
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/EQ", (String)this.areEqual(X, Y).getFun());
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/MATCHES", (String)this.matches(X, Y).getFun());
    }

    public void testNotConstant() {
        TestExpressionConstraints.assertFalse((boolean)this.notEqual(X, Y).isConstant());
    }

    public void testDetectAnd() {
        Expression expression = this.notEqual(X, Y);
        Expression expression2 = this.notEqual(X, Z);
        Query query = new Query().addConstraint(Dyadic.and(expression, expression2));
        Set set = CollectionFactory.createHashedSet();
        set.add(expression);
        set.add(expression2);
        Set set2 = TestExpressionConstraints.iteratorToSet(query.getConstraints().iterator());
        TestExpressionConstraints.assertEquals((Object)set, (Object)set2);
    }

    public void testUnknownExpression() {
        Expression.Base base = new Expression.Base(){

            public Valuator prepare(VariableIndexes variableIndexes) {
                return null;
            }
        };
        TestExpressionConstraints.assertFalse((boolean)Expression.Util.containsAllVariablesOf(CollectionFactory.createHashedSet(), base));
    }

    public static class IV
    implements IndexValues {
        private Map values = CollectionFactory.createHashedMap();

        public IV set(int n, String string) {
            this.values.put(new Integer(n), Node.createLiteral(string));
            return this;
        }

        public Object get(int n) {
            return this.values.get(new Integer(n));
        }
    }

    public static class VI
    implements VariableIndexes {
        private Map values = CollectionFactory.createHashedMap();

        public VI set(String string, int n) {
            this.values.put(string, new Integer(n));
            return this;
        }

        public int indexOf(String string) {
            return (Integer)this.values.get(string);
        }
    }
}

