/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class NodeToTriplesMap {
    private Map map = CollectionFactory.createHashedMap();
    private int size = 0;

    public Iterator domain() {
        return this.map.keySet().iterator();
    }

    public abstract Node getIndexNode(Triple var1);

    public boolean add(Node node, Triple triple) {
        Set set = (Set)this.map.get(node);
        if (set == null) {
            set = CollectionFactory.createHashedSet();
            this.map.put(node, set);
        }
        if (set.add(triple)) {
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean remove(Node node, Triple triple) {
        Set set = (Set)this.map.get(node);
        if (set == null) {
            return false;
        }
        boolean bl = set.remove(triple);
        if (bl) {
            --this.size;
        }
        if (set.isEmpty()) {
            this.map.put(node, null);
        }
        return bl;
    }

    public Iterator iterator(Node node) {
        Set set = (Set)this.map.get(node);
        return set == null ? NullIterator.instance : set.iterator();
    }

    public ExtendedIterator iterator() {
        final Iterator iterator = this.domain();
        return new NiceIterator(){
            private Iterator current = NullIterator.instance;

            public Object next() {
                if (!this.hasNext()) {
                    this.noElements("NodeToTriples iterator");
                }
                return this.current.next();
            }

            public boolean hasNext() {
                while (!this.current.hasNext()) {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    this.current = NodeToTriplesMap.this.iterator((Node)iterator.next());
                }
                return true;
            }

            public void remove() {
                this.current.remove();
                NodeToTriplesMap.this.size -= 1;
            }
        };
    }

    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ExtendedIterator iterator(Triple triple) {
        return this.iterator().filterKeep(new TripleMatchFilter(triple));
    }

    public ExtendedIterator iterator(Node node, Triple triple) {
        return new FilterIterator(new TripleMatchFilter(triple), this.iterator(node));
    }

    public boolean remove(Triple triple) {
        return this.remove(this.getIndexNode(triple), triple);
    }

    public boolean contains(Triple triple) {
        Set set = (Set)this.map.get(this.getIndexNode(triple));
        return set == null ? false : set.contains(triple);
    }
}

