/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.ParserSupport;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.URI;
import java.util.HashMap;
import java.util.Map;

class XMLContext {
    private final String base;
    private final String lang;
    private final URI uri;
    private final Map namespaces;
    XMLContext document;

    XMLContext(String string) throws MalformedURIException {
        this(string, new URI(string));
    }

    XMLContext(String string, URI uRI) {
        this(null, uRI, string, "", ParserSupport.xmlNameSpace());
        this.document = this;
    }

    XMLContext(XMLContext xMLContext, URI uRI, String string, String string2, Map map) {
        this.base = string;
        this.lang = string2;
        this.uri = uRI;
        this.document = xMLContext;
        this.namespaces = map;
    }

    XMLContext withBase(String string) throws MalformedURIException {
        return new XMLContext(this.document, new URI(string), string, this.lang, this.namespaces);
    }

    XMLContext revertToDocument() {
        return this.document.withLang(this.lang);
    }

    XMLContext withLang(String string) {
        return this.clone(this.document, this.uri, this.base, string, this.namespaces);
    }

    String getLang() {
        return this.lang;
    }

    String getBase() {
        return this.base;
    }

    Map getNamespaces() {
        return this.namespaces;
    }

    XMLContext addNamespace(Token token, Token token2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.namespaces);
        hashMap.put(((StrToken)token).value, ((StrToken)token2).value);
        return this.clone(this.document, this.uri, this.base, this.lang, hashMap);
    }

    URI getURI() {
        return this.uri;
    }

    boolean isSameAsDocument() {
        return this == this.document || this.uri.equals(this.document.uri);
    }

    XMLContext getDocument() {
        return this.document;
    }

    XMLContext clone(XMLContext xMLContext, URI uRI, String string, String string2, Map map) {
        return new XMLContext(xMLContext, uRI, string, string2, map);
    }

    String resolve(Location location, String string) throws MalformedURIException, ParseException {
        return new URI(this.getURI(), string).getURIString();
    }

    String resolveSameDocRef(Location location, String string) throws ParseException {
        return this.base + string;
    }
}

