/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementBase;
import com.hp.hpl.jena.shared.JenaException;

public class StatementImpl
extends StatementBase
implements Statement {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;
    protected static ModelCom empty = (ModelCom)ModelFactory.createDefaultModel();

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode, ModelCom modelCom) {
        super(modelCom);
        this.subject = (Resource)resource.inModel(modelCom);
        this.predicate = (Property)property.inModel(modelCom);
        this.object = rDFNode.inModel(modelCom);
    }

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode) {
        super(empty);
        this.subject = (Resource)resource.inModel(this.model);
        this.predicate = (Property)property.inModel(this.model);
        this.object = rDFNode.inModel(this.model);
    }

    public static Statement toStatement(Triple triple, ModelCom modelCom) {
        ResourceImpl resourceImpl = new ResourceImpl(triple.getSubject(), modelCom);
        PropertyImpl propertyImpl = new PropertyImpl(triple.getPredicate(), (EnhGraph)modelCom);
        RDFNode rDFNode = StatementImpl.createObject(triple.getObject(), modelCom);
        return new StatementImpl(resourceImpl, propertyImpl, rDFNode, modelCom);
    }

    public Resource getSubject() {
        return this.subject;
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public RDFNode getObject() {
        return this.object;
    }

    public Statement getStatementProperty(Property property) {
        return this.asResource().getRequiredProperty(property);
    }

    public Resource getResource() {
        return this.mustBeResource(this.object);
    }

    public Resource getResource(ResourceF resourceF) {
        return resourceF.createResource(this.getResource());
    }

    public Statement getProperty(Property property) {
        return this.getResource().getRequiredProperty(property);
    }

    public Literal getLiteral() {
        if (this.object instanceof Literal) {
            return (Literal)this.object;
        }
        throw new LiteralRequiredException(this.object);
    }

    public Object getObject(ObjectF objectF) {
        try {
            return objectF.createObject(this.getLiteral().toString());
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    private EnhNode get(Class clazz) {
        return (EnhNode)((Object)this.object.as(clazz));
    }

    public Bag getBag() {
        return (Bag)((Object)this.get(Bag.class));
    }

    public Alt getAlt() {
        return (Alt)((Object)this.get(Alt.class));
    }

    public Seq getSeq() {
        return (Seq)((Object)this.get(Seq.class));
    }

    protected StatementImpl replace(RDFNode rDFNode) {
        StatementImpl statementImpl = new StatementImpl(this.subject, this.predicate, rDFNode, this.model);
        this.model.remove(this).add(statementImpl);
        return statementImpl;
    }

    public boolean equals(Object object) {
        return object instanceof Statement && this.sameAs((Statement)object);
    }

    private final boolean sameAs(Statement statement) {
        return ((Object)this.subject).equals(statement.getSubject()) && this.predicate.equals(statement.getPredicate()) && this.object.equals(statement.getObject());
    }

    public int hashCode() {
        return this.asTriple().hashCode();
    }

    public Resource asResource() {
        return this.model.getAnyReifiedStatement(this);
    }

    public Statement remove() {
        this.model.remove(this);
        return this;
    }

    public void removeReification() {
        this.model.removeAllReifications(this);
    }

    public Triple asTriple() {
        return Triple.create(this.subject.asNode(), this.predicate.asNode(), this.object.asNode());
    }

    public static Triple[] asTriples(Statement[] statementArray) {
        Triple[] tripleArray = new Triple[statementArray.length];
        for (int i = 0; i < statementArray.length; ++i) {
            tripleArray[i] = statementArray[i].asTriple();
        }
        return tripleArray;
    }

    public boolean isReified() {
        return this.model.isReified(this);
    }

    public ReifiedStatement createReifiedStatement() {
        return ReifiedStatementImpl.create(this);
    }

    public ReifiedStatement createReifiedStatement(String string) {
        return ReifiedStatementImpl.create((ModelCom)this.getModel(), string, (Statement)this);
    }

    public RSIterator listReifiedStatements() {
        return this.model.listReifiedStatements(this);
    }

    public static RDFNode createObject(Node node, EnhGraph enhGraph) {
        return node.isLiteral() ? new LiteralImpl(node, enhGraph) : new ResourceImpl(node, enhGraph);
    }
}

