/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestSuite;

public class TestModelBulkUpdate
extends ModelTestBase {
    public TestModelBulkUpdate(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelBulkUpdate.class);
    }

    public void testMBU() {
        this.testMBU(ModelFactory.createDefaultModel());
    }

    public void testContains(Model model, Statement[] statementArray) {
        for (int i = 0; i < statementArray.length; ++i) {
            TestModelBulkUpdate.assertTrue((String)"it should be here", (boolean)model.contains(statementArray[i]));
        }
    }

    public void testContains(Model model, List list) {
        for (int i = 0; i < list.size(); ++i) {
            TestModelBulkUpdate.assertTrue((String)"it should be here", (boolean)model.contains((Statement)list.get(i)));
        }
    }

    public void testOmits(Model model, Statement[] statementArray) {
        for (int i = 0; i < statementArray.length; ++i) {
            TestModelBulkUpdate.assertFalse((String)"it should not be here", (boolean)model.contains(statementArray[i]));
        }
    }

    public void testOmits(Model model, List list) {
        for (int i = 0; i < list.size(); ++i) {
            TestModelBulkUpdate.assertFalse((String)"it should not be here", (boolean)model.contains((Statement)list.get(i)));
        }
    }

    public void testMBU(Model model) {
        Statement[] statementArray = TestModelBulkUpdate.statements(model, "moon orbits earth; earth orbits sun");
        List<Statement> list = Arrays.asList(TestModelBulkUpdate.statements(model, "I drink tea; you drink coffee"));
        model.add(statementArray);
        this.testContains(model, statementArray);
        model.add(list);
        this.testContains(model, list);
        this.testContains(model, statementArray);
        model.remove(statementArray);
        this.testOmits(model, statementArray);
        this.testContains(model, list);
        model.remove(list);
        this.testOmits(model, statementArray);
        this.testOmits(model, list);
    }

    public void testBulkByModel() {
        this.testBulkByModel(ModelFactory.createDefaultModel());
    }

    public void testBulkByModel(Model model) {
        TestModelBulkUpdate.assertEquals((String)"precondition: model must be empty", (long)0L, (long)model.size());
        Model model2 = TestModelBulkUpdate.modelWithStatements("clouds offer rain; trees offer shelter");
        Model model3 = TestModelBulkUpdate.modelWithStatements("x R y; y Q z; z P x");
        model.add(model2);
        this.assertIsoModels(model2, model);
        model.add(model3);
        model.remove(model2);
        this.assertIsoModels(model3, model);
        model.remove(model3);
        TestModelBulkUpdate.assertEquals((String)"", (long)0L, (long)model.size());
    }

    public void testBulkRemoveSelf() {
        Model model = TestModelBulkUpdate.modelWithStatements("they sing together; he sings alone");
        model.remove(model);
        TestModelBulkUpdate.assertEquals((String)"", (long)0L, (long)model.size());
    }

    public void testBulkByModelReifying() {
        this.testBulkByModelReifying(false);
        this.testBulkByModelReifying(true);
    }

    public void testBulkByModelReifying(boolean bl) {
        Model model = TestModelBulkUpdate.modelWithStatements(ReificationStyle.Minimal, "a P b");
        this.addReification(model, "x", "S P O");
        this.addReification(model, "a", "x R y");
        Model model2 = TestModelBulkUpdate.modelWithStatements(ReificationStyle.Minimal, "");
        model2.add(model, bl);
        model2.setNsPrefixes(PrefixMapping.Standard);
        this.assertIsoModels(bl ? TestModelBulkUpdate.modelWithStatements("a P b") : model, model2);
    }

    public void testBulkDeleteByModelReifying() {
        this.testBulkDeleteByModelReifying(false);
        this.testBulkDeleteByModelReifying(true);
    }

    public void testBulkDeleteByModelReifying(boolean bl) {
        Model model = TestModelBulkUpdate.modelWithStatements(ReificationStyle.Minimal, "");
        this.addReification(model, "x", "S P O");
        this.addReification(model, "y", "A P B");
        Model model2 = TestModelBulkUpdate.modelWithStatements("");
        this.addReification(model2, "y", "A P B");
        Model model3 = TestModelBulkUpdate.modelWithStatements("");
        this.addReification(model3, "x", "S P O");
        if (bl) {
            this.addReification(model3, "y", "A P B");
        }
        model.remove(model2, bl);
        this.assertIsoModels(model3, model);
    }

    public void addReification(Model model, String string, String string2) {
        model.createReifiedStatement(string, TestModelBulkUpdate.statement(model, string2));
    }
}

