/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.rdql.EvalTypeException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.ExprNode;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.WorkingVar;
import java.io.PrintWriter;

public class Q_UnaryNot
extends ExprNode
implements Expr,
ExprBoolean {
    private String printName = "unaryminus";
    private String opSymbol = "!";
    Expr expr;

    Q_UnaryNot(int n) {
        super(n);
    }

    Q_UnaryNot(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryNot: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public NodeValue eval(Query query, IndexValues indexValues) {
        NodeValue nodeValue = this.expr.eval(query, indexValues);
        if (!nodeValue.isBoolean()) {
            throw new EvalTypeException("Q_UnaryNot: Wanted a number: got " + this.expr);
        }
        WorkingVar workingVar = new WorkingVar();
        workingVar.setBoolean(!nodeValue.getBoolean());
        return workingVar;
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 1;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.expr instanceof Expression) {
            return (Expression)((Object)this.expr);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.print(printWriter, this.expr, null, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

