/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGConnectionPool;
import com.hp.hpl.jena.reasoner.dig.DIGIdentifier;
import com.hp.hpl.jena.reasoner.dig.DIGProfile;
import com.hp.hpl.jena.reasoner.dig.DIGQueryAllConceptsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryAncestorsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryClassHierarchyTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryDifferentFromTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryDisjointTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryEquivalentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryInstanceTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryInstancesTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsConceptTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsEquivalentTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsIndividualTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsRoleTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryParentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleAncestorsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleFillerTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleFillersTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleHierarchyTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleParentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQuerySubsumesTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTypesTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DIGAdapter {
    public static final DIGProfile RACER_17_PROFILE = new DIGProfile(){

        public String getDIGNamespace() {
            return "http://dl.kr.org/dig/lang";
        }

        public String getSchemaLocation() {
            return "http://potato.cs.man.ac.uk/dig/level0/dig.xsd";
        }

        public String getContentType() {
            return "application/x-www-form-urlencoded";
        }
    };
    private static final int UNION = 1;
    private static final int INTERSECTION = 2;
    private static final int COMPLEMENT = 3;
    private static final int ENUMERATED = 4;
    private static final int RESTRICTION = 5;
    public static final String ANON_MARKER = "anon:";
    public static final List KNOWN_CONCEPTS = Arrays.asList(OWL.Thing.getURI(), OWL.Nothing.getURI(), DAML_OIL.Thing.getURI(), DAML_OIL.Thing.getURI());
    public static final List XSD_INT_TYPES = Arrays.asList(XSDDatatype.XSDint.getURI(), XSDDatatype.XSDinteger.getURI(), XSDDatatype.XSDnonNegativeInteger.getURI(), XSDDatatype.XSDbyte.getURI(), XSDDatatype.XSDshort.getURI(), XSDDatatype.XSDlong.getURI(), XSDDatatype.XSDunsignedByte.getURI(), XSDDatatype.XSDunsignedLong.getURI(), XSDDatatype.XSDunsignedInt.getURI(), XSDDatatype.XSDunsignedShort.getURI());
    private static int s_queryID = 0;
    protected static DIGQueryTranslator[] s_queryTable = new DIGQueryTranslator[]{new DIGQuerySubsumesTranslator(RDFS.subClassOf.getURI()), new DIGQuerySubsumesTranslator(DAML_OIL.subClassOf.getURI()), new DIGQueryDisjointTranslator(OWL.disjointWith.getURI()), new DIGQueryDisjointTranslator(DAML_OIL.disjointWith.getURI()), new DIGQueryAncestorsTranslator(RDFS.subClassOf.getURI(), true), new DIGQueryAncestorsTranslator(RDFS.subClassOf.getURI(), false), new DIGQueryAncestorsTranslator(DAML_OIL.subClassOf.getURI(), true), new DIGQueryAncestorsTranslator(DAML_OIL.subClassOf.getURI(), false), new DIGQueryParentsTranslator(ReasonerVocabulary.directSubClassOf.getURI(), true), new DIGQueryParentsTranslator(ReasonerVocabulary.directSubClassOf.getURI(), false), new DIGQueryParentsTranslator(null, ReasonerVocabulary.directSubClassOf.getURI(), null, true), new DIGQueryParentsTranslator(null, ReasonerVocabulary.directSubClassOf.getURI(), null, false), new DIGQueryClassHierarchyTranslator(RDFS.subClassOf.getURI()), new DIGQueryClassHierarchyTranslator(DAML_OIL.subClassOf.getURI()), new DIGQueryEquivalentsTranslator(OWL.equivalentClass.getURI(), true), new DIGQueryEquivalentsTranslator(OWL.equivalentClass.getURI(), false), new DIGQueryEquivalentsTranslator(DAML_OIL.sameClassAs.getURI(), true), new DIGQueryEquivalentsTranslator(DAML_OIL.sameClassAs.getURI(), false), new DIGQueryIsEquivalentTranslator(OWL.equivalentClass.getURI()), new DIGQueryIsEquivalentTranslator(DAML_OIL.sameClassAs.getURI()), new DIGQueryRoleAncestorsTranslator(RDFS.subPropertyOf.getURI(), true), new DIGQueryRoleAncestorsTranslator(RDFS.subPropertyOf.getURI(), false), new DIGQueryRoleAncestorsTranslator(DAML_OIL.subPropertyOf.getURI(), true), new DIGQueryRoleAncestorsTranslator(DAML_OIL.subPropertyOf.getURI(), false), new DIGQueryRoleParentsTranslator(ReasonerVocabulary.directSubPropertyOf.getURI(), true), new DIGQueryRoleParentsTranslator(ReasonerVocabulary.directSubPropertyOf.getURI(), false), new DIGQueryRoleHierarchyTranslator(RDFS.subPropertyOf.getURI()), new DIGQueryRoleHierarchyTranslator(DAML_OIL.subPropertyOf.getURI()), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), RDFS.Class.getURI()), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), OWL.Class.getURI()), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), DAML_OIL.Class.getURI()), new DIGQueryInstancesTranslator(RDF.type.getURI()), new DIGQueryInstancesTranslator(DAML_OIL.type.getURI()), new DIGQueryTypesTranslator(RDF.type.getURI()), new DIGQueryTypesTranslator(DAML_OIL.type.getURI()), new DIGQueryInstanceTranslator(RDF.type.getURI()), new DIGQueryInstanceTranslator(DAML_OIL.type.getURI()), new DIGQueryDifferentFromTranslator(OWL.differentFrom.getURI()), new DIGQueryDifferentFromTranslator(DAML_OIL.differentIndividualFrom.getURI()), new DIGQueryRoleFillersTranslator(), new DIGQueryRoleFillerTranslator(), new DIGQueryIsConceptTranslator(), new DIGQueryIsRoleTranslator(), new DIGQueryIsIndividualTranslator()};
    protected DIGProfile m_profile = RACER_17_PROFILE;
    protected OntModel m_sourceData;
    private int m_skolemCounter = 0;
    private DIGConnection m_connection;
    protected Set m_indNames = new HashSet();
    protected boolean m_indNamesAsked = false;
    protected Set m_conceptNames = new HashSet();
    protected boolean m_conceptNamesAsked = false;
    protected Set m_roleNames = new HashSet();
    protected boolean m_roleNamesAsked = false;
    protected Model m_axioms = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ObjectProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$DatatypeProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AllDifferent;

    public DIGAdapter(OntModelSpec ontModelSpec, Graph graph) {
        this(ontModelSpec, graph, DIGConnectionPool.getInstance().allocate(), null);
    }

    public DIGAdapter(OntModelSpec ontModelSpec, Graph graph, DIGConnection dIGConnection, Model model) {
        this.m_connection = dIGConnection;
        this.m_axioms = model;
        this.m_sourceData = ModelFactory.createOntologyModel(ontModelSpec, ModelFactory.createModelForGraph(graph));
        this.m_sourceData.setStrictMode(false);
    }

    public DIGProfile getProfile() {
        return this.m_profile;
    }

    public void setProfile(DIGProfile dIGProfile) {
        this.m_profile = dIGProfile;
    }

    public Profile getOntLanguage() {
        return this.m_sourceData.getProfile();
    }

    public DIGIdentifier getDigIdentifier() {
        Document document = this.getConnection().createDigVerb("getIdentifier", this.getProfile());
        return new DigIdentifierImpl(this.getConnection().sendDigVerb(document, this.getProfile()));
    }

    public boolean uploadKB() {
        this.getConnection().bindKB(false, this.getProfile());
        Document document = this.translateKbToDig();
        Document document2 = this.getConnection().sendDigVerb(document, this.getProfile());
        return !this.getConnection().warningCheck(document2);
    }

    public Iterator getRecentWarnings() {
        return this.getConnection().getWarnings();
    }

    public Document translateKbToDig() {
        Document document = this.getConnection().createDigVerb("tells", this.getProfile());
        Element element = document.getDocumentElement();
        this.addNamedEntities(element);
        this.translateClasses(element);
        this.translateRoles(element);
        this.translateAttributes(element);
        this.translateIndividuals(element);
        this.translateAllDifferentAxioms(element);
        return document;
    }

    public void resetKB() {
        this.getConnection().bindKB(true, this.getProfile());
        this.m_indNames.clear();
        this.m_indNamesAsked = false;
        this.m_conceptNames.clear();
        this.m_conceptNamesAsked = false;
        this.m_roleNames.clear();
        this.m_roleNamesAsked = false;
    }

    public DIGConnection getConnection() {
        return this.m_connection;
    }

    public void close() {
        this.getConnection().release();
        this.m_connection = null;
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        DIGQueryTranslator dIGQueryTranslator = this.getQueryTranslator(triplePattern, null);
        ExtendedIterator extendedIterator = dIGQueryTranslator == null ? null : dIGQueryTranslator.find(triplePattern, this);
        Node node = this.normaliseNode(triplePattern.getSubject());
        Node node2 = this.normaliseNode(triplePattern.getPredicate());
        Node node3 = this.normaliseNode(triplePattern.getObject());
        ExtendedIterator extendedIterator2 = this.m_sourceData.getGraph().find(node, node2, node3);
        ExtendedIterator extendedIterator3 = extendedIterator == null ? extendedIterator2 : extendedIterator.andThen(extendedIterator2);
        extendedIterator3 = this.m_axioms == null ? extendedIterator3 : extendedIterator3.andThen(this.m_axioms.getGraph().find(node, node2, node3));
        return UniqueExtendedIterator.create(extendedIterator3);
    }

    public ExtendedIterator find(TriplePattern triplePattern, Model model) {
        DIGQueryTranslator dIGQueryTranslator = this.getQueryTranslator(triplePattern, model);
        if (dIGQueryTranslator == null) {
            LogFactory.getLog(this.getClass()).debug((Object)("Could not find DIG query translator for " + triplePattern));
        }
        ExtendedIterator extendedIterator = dIGQueryTranslator == null ? null : dIGQueryTranslator.find(triplePattern, this, model);
        Node node = this.normaliseNode(triplePattern.getSubject());
        Node node2 = this.normaliseNode(triplePattern.getPredicate());
        Node node3 = this.normaliseNode(triplePattern.getObject());
        ExtendedIterator extendedIterator2 = this.m_sourceData.getGraph().find(node, node2, node3);
        ExtendedIterator extendedIterator3 = extendedIterator == null ? extendedIterator2 : extendedIterator.andThen(extendedIterator2);
        extendedIterator3 = this.m_axioms == null ? extendedIterator3 : extendedIterator3.andThen(this.m_axioms.getGraph().find(node, node2, node3));
        return UniqueExtendedIterator.create(extendedIterator3);
    }

    public DIGQueryTranslator getQueryTranslator(TriplePattern triplePattern, Model model) {
        for (int i = 0; i < s_queryTable.length; ++i) {
            DIGQueryTranslator dIGQueryTranslator = s_queryTable[i];
            if (!s_queryTable[i].trigger(triplePattern, this, model)) continue;
            return s_queryTable[i];
        }
        return null;
    }

    public Graph getGraph() {
        return this.m_sourceData.getGraph();
    }

    public String getResourceID(Resource resource) {
        return this.getNodeID(resource.asNode());
    }

    public String getNodeID(Node node) {
        if (node.isBlank()) {
            return ANON_MARKER + node.getBlankNodeId().toString();
        }
        return node.getURI();
    }

    public void addClassDescription(Element element, Node node) {
        this.addClassDescription(element, node, (Model)this.m_sourceData);
    }

    public void addClassDescription(Element element, Node node, Model model) {
        Model model2 = model == null ? this.m_sourceData : model;
        this.addClassDescription(element, (Resource)model2.getRDFNode(node), model2);
    }

    public void addClassDescription(Element element, Resource resource, Model model) {
        Resource resource2;
        Resource resource3 = resource2 = resource.getModel() != model ? model.getResource(resource.getURI()) : resource;
        if (!resource2.isAnon() || this.m_conceptNames.contains(this.getNodeID(resource2.getNode()))) {
            this.translateClassIdentifier(element, resource2);
        } else {
            this.translateClassDescription(element, (OntClass)resource2.as(OntClass.class), model);
        }
    }

    public boolean isIndividual(Node node) {
        return node.isConcrete() && !node.isLiteral() && this.getKnownIndividuals().contains(this.getNodeID(node));
    }

    public boolean isRole(Node node, Model model) {
        return node.isConcrete() && (this.getKnownRoles().contains(this.getNodeID(node)) || model != null && this.isPremisesRole(node, model));
    }

    public boolean isConcept(Node node, Model model) {
        return node.isConcrete() && !node.isLiteral() && (this.getKnownConcepts().contains(this.getNodeID(node)) || model != null && this.isPremisesClass(node, model) || KNOWN_CONCEPTS.contains(this.getNodeID(node)));
    }

    public OntModelSpec getSourceSpecification() {
        return this.m_sourceData.getSpecification();
    }

    public Element createQueryElement(Document document, String string) {
        Element element = this.addElement(document.getDocumentElement(), string);
        element.setAttribute("id", "q" + s_queryID++);
        return element;
    }

    protected void addNamedEntities(Element element) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        this.addAll(this.m_sourceData.listClasses(), hashSet3);
        this.addAll(this.m_sourceData.listDatatypeProperties(), hashSet2);
        this.addAll(this.m_sourceData.listIndividuals(), hashSet4);
        this.collectRoleProperties(hashSet);
        this.addNamedDefs(element, hashSet3.iterator(), "defconcept", this.m_conceptNames);
        this.addNamedDefs(element, hashSet.iterator(), "defrole", this.m_roleNames);
        this.addNamedDefs(element, hashSet2.iterator(), "defattribute", null);
        this.addNamedDefs(element, hashSet4.iterator(), "defindividual", this.m_indNames);
    }

    protected void collectRoleProperties(Collection collection) {
        this.addAll(this.m_sourceData.listObjectProperties(), collection);
        this.addAll(this.m_sourceData.listInverseFunctionalProperties(), collection);
        this.addAll(this.m_sourceData.listTransitiveProperties(), collection);
        if (this.m_sourceData.getProfile().SYMMETRIC_PROPERTY() != null) {
            this.addAll(this.m_sourceData.listSymmetricProperties(), collection);
        }
    }

    protected void addNamedDefs(Element element, Iterator iterator, String string, Set set) {
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!(resource instanceof Resource)) continue;
            String string2 = this.getNodeID(resource.asNode());
            this.addNamedElement(element, string, this.getNodeID(resource.asNode()));
            if (set == null) continue;
            set.add(string2);
        }
    }

    protected Element addNamedElement(Element element, String string, String string2) {
        Element element2 = this.addElement(element, string);
        element2.setAttribute("name", string2);
        return element2;
    }

    protected Element addElement(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement(string);
        return (Element)element.appendChild(element2);
    }

    private void addAll(Iterator iterator, Collection collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    protected void translateClasses(Element element) {
        this.translateSubClassAxioms(element);
        this.translateClassEquivalences(element);
        this.translateClassDisjointAxioms(element);
        this.translateRestrictions(element);
        this.translateClassExpressions(element, this.getOntLanguage().INTERSECTION_OF(), 2);
        this.translateClassExpressions(element, this.getOntLanguage().UNION_OF(), 1);
        this.translateClassExpressions(element, this.getOntLanguage().COMPLEMENT_OF(), 3);
        this.translateClassExpressions(element, this.getOntLanguage().ONE_OF(), 4);
    }

    protected void translateSubClassAxioms(Element element) {
        StmtIterator stmtIterator = this.m_sourceData.listStatements(null, this.getOntLanguage().SUB_CLASS_OF(), (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Element element2 = this.addElement(element, "impliesc");
            this.addClassDescription(element2, statement.getSubject(), (Model)this.m_sourceData);
            this.addClassDescription(element2, statement.getResource(), (Model)this.m_sourceData);
        }
    }

    protected void translateClassEquivalences(Element element) {
        StmtIterator stmtIterator = this.m_sourceData.listStatements(null, this.getOntLanguage().EQUIVALENT_CLASS(), (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Element element2 = this.addElement(element, "equalc");
            this.addClassDescription(element2, statement.getSubject(), (Model)this.m_sourceData);
            this.addClassDescription(element2, statement.getResource(), (Model)this.m_sourceData);
        }
    }

    protected void translateClassExpressions(Element element, Property property, int n) {
        this.translateClassExpressions(element, this.m_sourceData.listStatements(null, property, (RDFNode)null), n, this.m_sourceData);
    }

    protected void translateRestrictions(Element element) {
        this.translateClassExpressions(element, this.m_sourceData.listStatements(null, RDF.type, this.getOntLanguage().RESTRICTION()), 5, this.m_sourceData);
    }

    protected void translateClassExpressions(Element element, StmtIterator stmtIterator, int n, Model model) {
        while (stmtIterator.hasNext()) {
            OntClass ontClass = (OntClass)stmtIterator.nextStatement().getSubject().as(class$com$hp$hpl$jena$ontology$OntClass == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass);
            Element element2 = this.addElement(element, "equalc");
            this.addClassDescription(element2, ontClass, model);
            switch (n) {
                case 1: {
                    this.translateUnionClass(element2, ontClass, model);
                    break;
                }
                case 2: {
                    this.translateIntersectionClass(element2, ontClass, model);
                    break;
                }
                case 3: {
                    this.translateComplementClass(element2, ontClass, model);
                    break;
                }
                case 4: {
                    this.translateEnumeratedClass(element2, ontClass, model);
                    break;
                }
                case 5: {
                    this.translateRestrictionClass(element2, ontClass, model);
                }
            }
        }
    }

    protected void translateClassDescription(Element element, OntClass ontClass, Model model) {
        if (ontClass.isUnionClass()) {
            this.translateUnionClass(element, ontClass, model);
        } else if (ontClass.isIntersectionClass()) {
            this.translateIntersectionClass(element, ontClass, model);
        } else if (ontClass.isComplementClass()) {
            this.translateComplementClass(element, ontClass, model);
        } else if (ontClass.isEnumeratedClass()) {
            this.translateEnumeratedClass(element, ontClass, model);
        } else if (ontClass.isRestriction()) {
            this.translateRestrictionClass(element, ontClass, model);
        }
    }

    protected void translateClassDisjointAxioms(Element element) {
        StmtIterator stmtIterator = this.m_sourceData.listStatements(null, this.getOntLanguage().DISJOINT_WITH(), (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Element element2 = this.addElement(element, "disjoint");
            this.addClassDescription(element2, statement.getSubject(), (Model)this.m_sourceData);
            this.addClassDescription(element2, statement.getResource(), (Model)this.m_sourceData);
        }
    }

    protected void translateClassIdentifier(Element element, Resource resource) {
        if (((Object)resource).equals(this.getOntLanguage().THING())) {
            this.addElement(element, "top");
            return;
        }
        if (((Object)resource).equals(this.getOntLanguage().NOTHING())) {
            this.addElement(element, "bottom");
            return;
        }
        Element element2 = this.addElement(element, "catom");
        String string = this.getNodeID(resource.asNode());
        element2.setAttribute("name", string);
    }

    protected void translateRestrictionClass(Element element, Resource resource, Model model) {
        Restriction restriction = (Restriction)resource.as(Restriction.class);
        if (restriction.isAllValuesFromRestriction()) {
            Element element2 = this.addElement(element, "all");
            this.addNamedElement(element2, "ratom", restriction.getOnProperty().getURI());
            this.addClassDescription(element2, restriction.asAllValuesFromRestriction().getAllValuesFrom(), model);
        } else if (restriction.isSomeValuesFromRestriction()) {
            Element element3 = this.addElement(element, "some");
            this.addNamedElement(element3, "ratom", restriction.getOnProperty().getURI());
            this.addClassDescription(element3, restriction.asSomeValuesFromRestriction().getSomeValuesFrom(), model);
        } else if (restriction.isHasValueRestriction()) {
            this.translateHasValueRestriction(element, restriction.asHasValueRestriction());
        } else if (restriction.isMinCardinalityRestriction()) {
            this.translateCardinalityRestriction(element, restriction.asMinCardinalityRestriction().getMinCardinality(), restriction, "atleast", this.getOntLanguage().THING(), model);
        } else if (restriction.isMaxCardinalityRestriction()) {
            this.translateCardinalityRestriction(element, restriction.asMaxCardinalityRestriction().getMaxCardinality(), restriction, "atmost", this.getOntLanguage().THING(), model);
        } else if (restriction.isCardinalityRestriction()) {
            Element element4 = this.addElement(element, "and");
            this.translateCardinalityRestriction(element4, restriction.asCardinalityRestriction().getCardinality(), restriction, "atmost", this.getOntLanguage().THING(), model);
            this.translateCardinalityRestriction(element4, restriction.asCardinalityRestriction().getCardinality(), restriction, "atleast", this.getOntLanguage().THING(), model);
        }
    }

    protected void translateEnumeratedClass(Element element, OntClass ontClass, Model model) {
        Element element2 = this.addElement(element, "iset");
        ExtendedIterator extendedIterator = ontClass.asEnumeratedClass().listOneOf();
        while (extendedIterator.hasNext()) {
            RDFNode rDFNode = (RDFNode)extendedIterator.next();
            if (rDFNode instanceof Resource) {
                this.addNamedElement(element2, "individual", ((Resource)rDFNode).getURI());
                continue;
            }
            LogFactory.getLog(this.getClass()).warn((Object)("DIG language cannot yet represent enumerations of concrete literals: " + ((Literal)rDFNode).getLexicalForm()));
        }
    }

    protected void translateComplementClass(Element element, OntClass ontClass, Model model) {
        Element element2 = this.addElement(element, "not");
        this.addClassDescription(element2, ontClass.asComplementClass().getOperand(), model);
    }

    protected void translateIntersectionClass(Element element, OntClass ontClass, Model model) {
        Element element2 = this.addElement(element, "and");
        this.translateClassList(element2, ontClass.asIntersectionClass().getOperands(), model);
    }

    protected void translateUnionClass(Element element, OntClass ontClass, Model model) {
        Element element2 = this.addElement(element, "or");
        this.translateClassList(element2, ontClass.asUnionClass().getOperands(), model);
    }

    private void translateCardinalityRestriction(Element element, int n, Restriction restriction, String string, Resource resource, Model model) {
        Element element2 = this.addElement(element, string);
        element2.setAttribute("num", Integer.toString(n));
        this.addNamedElement(element2, "ratom", restriction.getOnProperty().getURI());
        this.addClassDescription(element2, resource, model);
    }

    protected void translateHasValueRestriction(Element element, HasValueRestriction hasValueRestriction) {
        RDFNode rDFNode = hasValueRestriction.getHasValue();
        OntProperty ontProperty = hasValueRestriction.getOnProperty();
        if (rDFNode instanceof Literal) {
            Literal literal = (Literal)rDFNode;
            boolean bl = this.isIntegerType(literal.getDatatype());
            Element element2 = this.addElement(element, bl ? "intequals" : "stringequals");
            element2.setAttribute("val", literal.getLexicalForm());
            this.addNamedElement(element2, "attribute", ontProperty.getURI());
        } else {
            Element element3 = this.addElement(element, "some");
            this.addNamedElement(element3, "ratom", ontProperty.getURI());
            Element element4 = this.addElement(element3, "iset");
            this.addNamedElement(element4, "individual", ((Resource)rDFNode).getURI());
        }
    }

    protected void translateClassList(Element element, RDFList rDFList, Model model) {
        ExtendedIterator extendedIterator = rDFList.iterator();
        while (extendedIterator.hasNext()) {
            this.addClassDescription(element, (Resource)extendedIterator.next(), model);
        }
    }

    protected void translateIndividuals(Element element) {
        ExtendedIterator extendedIterator = this.m_sourceData.listIndividuals();
        while (extendedIterator.hasNext()) {
            this.translateIndividual(element, (Resource)extendedIterator.next());
        }
    }

    protected void translateIndividual(Element element, Resource resource) {
        Individual individual = (Individual)resource.as(Individual.class);
        this.translateInstanceTypes(element, individual);
        StmtIterator stmtIterator = individual.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            OntProperty ontProperty = (OntProperty)statement.getPredicate().as(class$com$hp$hpl$jena$ontology$OntProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.OntProperty") : class$com$hp$hpl$jena$ontology$OntProperty);
            if (ontProperty.equals(this.getOntLanguage().DIFFERENT_FROM())) {
                this.translateDifferentIndividuals(element, individual, (Individual)statement.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (ontProperty.equals(this.getOntLanguage().SAME_AS())) {
                this.translateSameIndividuals(element, individual, (Individual)statement.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (ontProperty.isObjectProperty() || ontProperty.isTransitiveProperty() || ontProperty.isSymmetricProperty() || ontProperty.isInverseFunctionalProperty()) {
                this.translateInstanceRole(element, individual, ontProperty, (Individual)statement.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (!ontProperty.isDatatypeProperty()) continue;
            this.translateInstanceAttrib(element, individual, ontProperty, statement.getLiteral());
        }
    }

    protected void translateInstanceTypes(Element element, Individual individual) {
        ExtendedIterator extendedIterator = individual.listRDFTypes(true);
        while (extendedIterator.hasNext()) {
            Resource resource = (Resource)extendedIterator.next();
            Element element2 = this.addElement(element, "instanceof");
            this.addNamedElement(element2, "individual", this.getResourceID(individual));
            this.addClassDescription(element2, (OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass), (Model)this.m_sourceData);
        }
    }

    protected void translateInstanceRole(Element element, Individual individual, OntProperty ontProperty, Individual individual2) {
        Element element2 = this.addElement(element, "related");
        this.addNamedElement(element2, "individual", this.getResourceID(individual));
        this.addNamedElement(element2, "ratom", ontProperty.getURI());
        this.addNamedElement(element2, "individual", this.getResourceID(individual2));
    }

    protected void translateInstanceAttrib(Element element, Individual individual, OntProperty ontProperty, Literal literal) {
        Element element2 = this.addElement(element, "value");
        this.addNamedElement(element2, "individual", this.getResourceID(individual));
        this.addNamedElement(element2, "attribute", ontProperty.getURI());
        this.translateLiteral(literal, element2);
    }

    protected void translateLiteral(Literal literal, Element element) {
        if (this.isIntegerType(literal.getDatatype())) {
            Element element2 = this.addElement(element, "ival");
            element2.appendChild(element.getOwnerDocument().createTextNode(literal.getLexicalForm()));
        } else {
            Element element3 = this.addElement(element, "sval");
            element3.appendChild(element.getOwnerDocument().createTextNode(literal.getLexicalForm()));
        }
    }

    protected void translateDifferentIndividuals(Element element, Individual individual, Individual individual2) {
        Element element2 = this.addElement(element, "disjoint");
        Element element3 = this.addElement(element2, "iset");
        this.addNamedElement(element3, "individual", this.getResourceID(individual));
        Element element4 = this.addElement(element2, "iset");
        this.addNamedElement(element4, "individual", this.getResourceID(individual2));
    }

    protected void translateSameIndividuals(Element element, Individual individual, Individual individual2) {
        Element element2 = this.addElement(element, "equalc");
        Element element3 = this.addElement(element2, "iset");
        this.addNamedElement(element3, "individual", this.getResourceID(individual));
        Element element4 = this.addElement(element2, "iset");
        this.addNamedElement(element4, "individual", this.getResourceID(individual2));
    }

    protected void translateRoles(Element element) {
        HashSet hashSet = new HashSet();
        this.collectRoleProperties(hashSet);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.translateRole(element, (ObjectProperty)((Property)iterator.next()).as(class$com$hp$hpl$jena$ontology$ObjectProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.ObjectProperty") : class$com$hp$hpl$jena$ontology$ObjectProperty), this.m_sourceData);
        }
    }

    protected void translateRole(Element element, ObjectProperty objectProperty, Model model) {
        this.translateBinaryPropertyAxioms(element, objectProperty.getURI(), "impliesr", objectProperty.listSuperProperties(), "ratom");
        this.translateBinaryPropertyAxioms(element, objectProperty.getURI(), "equalr", objectProperty.listEquivalentProperties(), "ratom");
        this.translateDomainRangeAxioms(element, objectProperty.getURI(), "domain", objectProperty.listDomain(), "ratom", model);
        this.translateDomainRangeAxioms(element, objectProperty.getURI(), "range", objectProperty.listRange(), "ratom", model);
        this.translateInverseAxioms(element, objectProperty, "ratom");
        if (objectProperty.isTransitiveProperty()) {
            this.translateUnaryPropertyAxiom(element, objectProperty.getURI(), "transitive", "ratom");
        }
        if (objectProperty.isFunctionalProperty()) {
            this.translateUnaryPropertyAxiom(element, objectProperty.getURI(), "functional", "ratom");
        }
        if (objectProperty.isInverseFunctionalProperty()) {
            this.translateInverseFunctionalAxiom(element, objectProperty, "ratom");
        }
        if (objectProperty.isSymmetricProperty()) {
            this.translateInverseAxiom(element, objectProperty, "ratom", objectProperty);
        }
    }

    protected void translateAttributes(Element element) {
        ExtendedIterator extendedIterator = this.m_sourceData.listDatatypeProperties();
        while (extendedIterator.hasNext()) {
            this.translateAttribute(element, (DatatypeProperty)((Property)extendedIterator.next()).as(class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.DatatypeProperty") : class$com$hp$hpl$jena$ontology$DatatypeProperty), this.m_sourceData);
        }
    }

    protected void translateAttribute(Element element, DatatypeProperty datatypeProperty, Model model) {
        this.translateBinaryPropertyAxioms(element, datatypeProperty.getURI(), "impliesr", datatypeProperty.listSuperProperties(), "attribute");
        this.translateBinaryPropertyAxioms(element, datatypeProperty.getURI(), "equalr", datatypeProperty.listEquivalentProperties(), "attribute");
        this.translateDomainRangeAxioms(element, datatypeProperty.getURI(), "domain", datatypeProperty.listDomain(), "attribute", model);
        this.translateAttribRangeAxioms(element, datatypeProperty.getURI(), datatypeProperty.listRange(), "attribute");
        if (datatypeProperty.isFunctionalProperty()) {
            this.translateUnaryPropertyAxiom(element, datatypeProperty.getURI(), "functional", "attribute");
        }
    }

    protected void translateBinaryPropertyAxioms(Element element, String string, String string2, Iterator iterator, String string3) {
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            Element element2 = this.addElement(element, string2);
            this.addNamedElement(element2, string3, string);
            this.addNamedElement(element2, string3, property.getURI());
        }
    }

    protected void translateUnaryPropertyAxiom(Element element, String string, String string2, String string3) {
        Element element2 = this.addElement(element, string2);
        this.addNamedElement(element2, string3, string);
    }

    protected void translateDomainRangeAxioms(Element element, String string, String string2, Iterator iterator, String string3, Model model) {
        while (iterator.hasNext()) {
            Element element2 = this.addElement(element, string2);
            this.addNamedElement(element2, string3, string);
            this.addClassDescription(element2, (Resource)iterator.next(), model);
        }
    }

    protected void translateAttribRangeAxioms(Element element, String string, Iterator iterator, String string2) {
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getTypeByName(resource.getURI());
            Element element2 = this.addElement(element, this.isIntegerType(rDFDatatype) ? "rangeint" : "rangestring");
            this.addNamedElement(element2, string2, string);
        }
    }

    protected void translateInverseAxioms(Element element, ObjectProperty objectProperty, String string) {
        ExtendedIterator extendedIterator = objectProperty.listInverse();
        while (extendedIterator.hasNext()) {
            this.translateInverseAxiom(element, objectProperty, string, (Property)extendedIterator.next());
        }
    }

    protected void translateInverseAxiom(Element element, Property property, String string, Property property2) {
        Element element2 = this.addElement(element, "equalr");
        this.addNamedElement(element2, string, property.getURI());
        Element element3 = this.addElement(element2, "inverse");
        this.addNamedElement(element3, string, property2.getURI());
    }

    protected void translateInverseFunctionalAxiom(Element element, ObjectProperty objectProperty, String string) {
        String string2 = this.getSkolemName(objectProperty.getLocalName());
        this.addNamedElement(element, "defrole", string2);
        Element element2 = this.addElement(element, "functional");
        this.addNamedElement(element2, string, string2);
        Element element3 = this.addElement(element, "equalr");
        this.addNamedElement(element3, string, objectProperty.getURI());
        Element element4 = this.addElement(element3, "inverse");
        this.addNamedElement(element4, string, string2);
    }

    protected void translateAllDifferentAxioms(Element element) {
        if (this.m_sourceData.getProfile().ALL_DIFFERENT() != null) {
            ExtendedIterator extendedIterator = this.m_sourceData.listAllDifferent();
            while (extendedIterator.hasNext()) {
                AllDifferent allDifferent = (AllDifferent)((Resource)extendedIterator.next()).as(class$com$hp$hpl$jena$ontology$AllDifferent == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.AllDifferent") : class$com$hp$hpl$jena$ontology$AllDifferent);
                this.translateAllDifferent(element, allDifferent.getDistinctMembers());
            }
        }
    }

    protected void translateAllDifferent(Element element, RDFList rDFList) {
        List list = rDFList.asJavaList();
        for (int i = 0; i < list.size(); ++i) {
            Individual individual = (Individual)((Resource)list.get(i)).as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
            for (int j = i + 1; j < list.size(); ++j) {
                Individual individual2 = (Individual)((Resource)list.get(j)).as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
                this.translateDifferentIndividuals(element, individual, individual2);
            }
        }
    }

    private boolean isIntegerType(RDFDatatype rDFDatatype) {
        String string = rDFDatatype != null ? rDFDatatype.getURI() : null;
        return string != null && XSD_INT_TYPES.contains(string);
    }

    private String getSkolemName(String string) {
        return "skolem(" + string + "," + this.m_skolemCounter++ + ")";
    }

    protected Set getKnownIndividuals() {
        if (!this.m_indNamesAsked) {
            this.m_indNames.addAll(this.collectNamedTerms("allIndividuals", new String[]{"individualSet", "individual"}));
            this.m_indNamesAsked = true;
        }
        return this.m_indNames;
    }

    protected Set getKnownConcepts() {
        if (!this.m_conceptNamesAsked) {
            this.m_conceptNames.addAll(this.collectNamedTerms("allConceptNames", new String[]{"conceptSet", "synonyms", "catom"}));
            this.m_conceptNamesAsked = true;
        }
        return this.m_conceptNames;
    }

    protected Set getKnownRoles() {
        if (!this.m_roleNamesAsked) {
            this.m_roleNames.addAll(this.collectNamedTerms("allRoleNames", new String[]{"roleSet", "synonyms", "ratom"}));
            this.m_roleNamesAsked = true;
        }
        return this.m_roleNames;
    }

    protected Set collectNamedTerms(String string, String[] stringArray) {
        HashSet hashSet = new HashSet();
        Document document = this.getConnection().createDigVerb("asks", this.getProfile());
        this.createQueryElement(document, string);
        Document document2 = this.getConnection().sendDigVerb(document, this.getProfile());
        SimpleXMLPath simpleXMLPath = new SimpleXMLPath(true);
        for (int i = 0; i < stringArray.length; ++i) {
            simpleXMLPath.appendElementPath(stringArray[i]);
        }
        simpleXMLPath.appendAttrPath("name");
        this.addAll(simpleXMLPath.getAll(document2), hashSet);
        return hashSet;
    }

    private boolean isPremisesClass(Node node, Model model) {
        RDFNode rDFNode = model.getRDFNode(node);
        Profile profile = this.getOntLanguage();
        if (rDFNode instanceof Resource) {
            Resource resource = (Resource)rDFNode;
            Resource resource2 = null;
            return profile.CLASS() != null && model.contains(resource, RDF.type, profile.CLASS()) || profile.RESTRICTION() != null && model.contains(resource, RDF.type, profile.RESTRICTION()) || profile.SUB_CLASS_OF() != null && model.contains(resource, profile.SUB_CLASS_OF(), resource2) || profile.SUB_CLASS_OF() != null && model.contains(resource2, profile.SUB_CLASS_OF(), resource) || profile.UNION_OF() != null && model.contains(resource, profile.SUB_CLASS_OF(), resource2) || profile.INTERSECTION_OF() != null && model.contains(resource, profile.SUB_CLASS_OF(), resource2) || profile.COMPLEMENT_OF() != null && model.contains(resource, profile.SUB_CLASS_OF(), resource2) || profile.DISJOINT_WITH() != null && model.contains(resource, profile.DISJOINT_WITH(), resource2) || profile.EQUIVALENT_CLASS() != null && model.contains(resource, profile.EQUIVALENT_CLASS(), resource2);
        }
        return false;
    }

    private boolean isPremisesRole(Node node, Model model) {
        RDFNode rDFNode = model.getRDFNode(node);
        Profile profile = this.getOntLanguage();
        if (rDFNode instanceof Resource) {
            Resource resource = (Resource)rDFNode;
            Resource resource2 = null;
            return profile.PROPERTY() != null && model.contains(resource, RDF.type, profile.PROPERTY()) || profile.OBJECT_PROPERTY() != null && model.contains(resource, RDF.type, profile.OBJECT_PROPERTY()) || profile.DATATYPE_PROPERTY() != null && model.contains(resource, RDF.type, profile.DATATYPE_PROPERTY()) || profile.TRANSITIVE_PROPERTY() != null && model.contains(resource, RDF.type, profile.TRANSITIVE_PROPERTY()) || profile.FUNCTIONAL_PROPERTY() != null && model.contains(resource, RDF.type, profile.FUNCTIONAL_PROPERTY()) || profile.INVERSE_FUNCTIONAL_PROPERTY() != null && model.contains(resource, RDF.type, profile.INVERSE_FUNCTIONAL_PROPERTY()) || profile.SYMMETRIC_PROPERTY() != null && model.contains(resource, RDF.type, profile.SYMMETRIC_PROPERTY()) || profile.SUB_PROPERTY_OF() != null && model.contains(resource, profile.SUB_PROPERTY_OF(), resource2) || profile.SUB_PROPERTY_OF() != null && model.contains(resource2, profile.SUB_PROPERTY_OF(), resource) || profile.INVERSE_OF() != null && model.contains(resource, profile.INVERSE_OF(), resource2) || profile.INVERSE_OF() != null && model.contains(resource2, profile.INVERSE_OF(), resource);
        }
        return false;
    }

    private Node normaliseNode(Node node) {
        return node.isConcrete() ? node : Node.ANY;
    }

    private class DigIdentifierImpl
    implements DIGIdentifier {
        private Document m_id;

        private DigIdentifierImpl(Document document) {
            this.m_id = document;
        }

        public String getName() {
            return this.m_id.getDocumentElement().getAttribute("name");
        }

        public String getVersion() {
            return this.m_id.getDocumentElement().getAttribute("version");
        }

        public String getMessage() {
            return this.m_id.getDocumentElement().getAttribute("message");
        }

        public Iterator supportsLanguage() {
            return this.supports("language");
        }

        public Iterator supportsTell() {
            return this.supports("tell");
        }

        public Iterator supportsAsk() {
            return this.supports("ask");
        }

        private Iterator supports(String string) {
            Element element = this.getChild(this.m_id.getDocumentElement(), "supports");
            return this.childElementNames(this.getChild(element, string));
        }

        private Iterator childElementNames(Element element) {
            ArrayList<String> arrayList = new ArrayList<String>();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                org.w3c.dom.Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                arrayList.add(node.getNodeName());
            }
            return arrayList.iterator();
        }

        private Element getChild(Element element, String string) {
            return (Element)element.getElementsByTagName(string).item(0);
        }
    }
}

