/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

public abstract class BaseBuiltin
implements Builtin {
    public static final String BASE_URI = "http://jena.hpl.hp.com/2003/RuleBuiltin/";

    public String getURI() {
        return BASE_URI + this.getName();
    }

    public int getArgLength() {
        return 0;
    }

    public void checkArgs(int n, RuleContext ruleContext) {
        int n2 = this.getArgLength();
        if (n2 > 0 && n2 != n) {
            throw new BuiltinException(this, ruleContext, "builtin " + this.getName() + " requires " + n2 + " arguments but saw " + n);
        }
    }

    public boolean bodyCall(Node[] nodeArray, int n, RuleContext ruleContext) {
        throw new BuiltinException(this, ruleContext, "builtin " + this.getName() + " not usable in rule bodies");
    }

    public void headAction(Node[] nodeArray, int n, RuleContext ruleContext) {
        throw new BuiltinException(this, ruleContext, "builtin " + this.getName() + " not usable in rule heads");
    }

    public boolean isSafe() {
        return true;
    }

    public Node getArg(int n, Node[] nodeArray, RuleContext ruleContext) {
        return ruleContext.getEnv().getGroundVersion(nodeArray[n]);
    }
}

