/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;

public final class WrappedReasonerFactory
implements ReasonerFactory {
    protected final ReasonerFactory factory;
    protected final Resource config;
    protected final Model schemaUnion = ModelFactory.createDefaultModel();

    public WrappedReasonerFactory(ReasonerFactory reasonerFactory, Resource resource) {
        this.factory = reasonerFactory;
        this.config = resource;
        WrappedReasonerFactory.loadSchemas(this.schemaUnion, resource);
    }

    public Reasoner create(Resource resource) {
        Reasoner reasoner = this.factory.create(this.config);
        return this.schemaUnion.isEmpty() ? reasoner : reasoner.bindSchema(this.schemaUnion);
    }

    private static Model loadSchemas(Model model, Resource resource) {
        StmtIterator stmtIterator = resource.listProperties(JenaModelSpec.schemaURL);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource2 = statement.getResource();
            FileManager.get().readModel(model, resource2.getURI());
        }
        return model;
    }

    public Model getCapabilities() {
        return this.factory.getCapabilities();
    }

    public String getURI() {
        return this.factory.getURI();
    }
}

