/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTransitiveGraphCache
extends TestCase {
    TransitiveGraphCache cache;
    String NS = "urn:x-hp-test:ex/";
    Node directP = Node.createURI(this.NS + "directSubProperty");
    Node closedP = Node.createURI(this.NS + "subProperty");
    Node a = Node.createURI(this.NS + "a");
    Node b = Node.createURI(this.NS + "b");
    Node c = Node.createURI(this.NS + "c");
    Node d = Node.createURI(this.NS + "d");
    Node e = Node.createURI(this.NS + "e");
    Node f = Node.createURI(this.NS + "f");
    Node g = Node.createURI(this.NS + "g");

    public TestTransitiveGraphCache(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTransitiveGraphCache.class);
    }

    public void testBasicCache() {
        this.initCache();
        this.cache.setCaching(false);
        this.doBasicTest(this.cache);
    }

    public void testCachingCache() {
        this.initCache();
        this.cache.setCaching(true);
        this.doBasicTest(this.cache);
    }

    public void testCloning() {
        this.initCache();
        TransitiveGraphCache transitiveGraphCache = this.cache.deepCopy();
        this.cache.addRelation(new Triple(this.a, this.closedP, this.d));
        this.cache.addRelation(new Triple(this.g, this.closedP, this.a));
        this.doBasicTest(transitiveGraphCache);
    }

    private void initCache() {
        this.cache = new TransitiveGraphCache(this.directP, this.closedP);
        this.cache.addRelation(new Triple(this.a, this.closedP, this.b));
        this.cache.addRelation(new Triple(this.b, this.closedP, this.e));
        this.cache.addRelation(new Triple(this.b, this.closedP, this.c));
        this.cache.addRelation(new Triple(this.e, this.closedP, this.f));
        this.cache.addRelation(new Triple(this.c, this.closedP, this.f));
        this.cache.addRelation(new Triple(this.f, this.closedP, this.g));
        this.cache.addRelation(new Triple(this.d, this.closedP, this.c));
        this.cache.addRelation(new Triple(this.d, this.closedP, this.e));
        this.cache.addRelation(new Triple(this.d, this.closedP, this.g));
        this.cache.addRelation(new Triple(this.a, this.closedP, this.e));
        this.cache.addRelation(new Triple(this.d, this.closedP, this.b));
        this.cache.addRelation(new Triple(this.a, this.closedP, this.a));
        this.cache.addRelation(new Triple(this.b, this.closedP, this.b));
        this.cache.addRelation(new Triple(this.c, this.closedP, this.c));
        this.cache.addRelation(new Triple(this.d, this.closedP, this.d));
        this.cache.addRelation(new Triple(this.e, this.closedP, this.e));
        this.cache.addRelation(new Triple(this.f, this.closedP, this.f));
        this.cache.addRelation(new Triple(this.g, this.closedP, this.g));
    }

    public void doBasicTest(TransitiveGraphCache transitiveGraphCache) {
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.directP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.e), new Triple(this.a, this.closedP, this.f), new Triple(this.a, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, this.g)), new Object[]{new Triple(this.a, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, this.f)), new Object[]{new Triple(this.e, this.closedP, this.f), new Triple(this.f, this.closedP, this.f), new Triple(this.c, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.closedP, this.f)), new Object[]{new Triple(this.f, this.closedP, this.f), new Triple(this.e, this.closedP, this.f), new Triple(this.b, this.closedP, this.f), new Triple(this.c, this.closedP, this.f), new Triple(this.a, this.closedP, this.f), new Triple(this.d, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.d, this.closedP, this.d), new Triple(this.d, this.closedP, this.b), new Triple(this.b, this.closedP, this.b), new Triple(this.b, this.closedP, this.e), new Triple(this.b, this.closedP, this.c), new Triple(this.e, this.closedP, this.e), new Triple(this.e, this.closedP, this.f), new Triple(this.c, this.closedP, this.c), new Triple(this.c, this.closedP, this.f), new Triple(this.f, this.closedP, this.f), new Triple(this.f, this.closedP, this.g), new Triple(this.g, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.e), new Triple(this.a, this.closedP, this.f), new Triple(this.a, this.closedP, this.g), new Triple(this.d, this.closedP, this.d), new Triple(this.d, this.closedP, this.b), new Triple(this.d, this.closedP, this.e), new Triple(this.d, this.closedP, this.c), new Triple(this.d, this.closedP, this.f), new Triple(this.d, this.closedP, this.g), new Triple(this.b, this.closedP, this.b), new Triple(this.b, this.closedP, this.e), new Triple(this.b, this.closedP, this.c), new Triple(this.b, this.closedP, this.f), new Triple(this.b, this.closedP, this.g), new Triple(this.e, this.closedP, this.e), new Triple(this.e, this.closedP, this.f), new Triple(this.e, this.closedP, this.g), new Triple(this.c, this.closedP, this.c), new Triple(this.c, this.closedP, this.f), new Triple(this.c, this.closedP, this.g), new Triple(this.f, this.closedP, this.f), new Triple(this.f, this.closedP, this.g), new Triple(this.g, this.closedP, this.g)});
        transitiveGraphCache.addRelation(new Triple(this.g, this.closedP, this.e));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.e, this.directP, null)), new Object[]{new Triple(this.e, this.closedP, this.e), new Triple(this.e, this.closedP, this.f), new Triple(this.e, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.f, this.directP, null)), new Object[]{new Triple(this.f, this.closedP, this.f), new Triple(this.f, this.closedP, this.g), new Triple(this.f, this.closedP, this.e)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.g, this.directP, null)), new Object[]{new Triple(this.g, this.closedP, this.g), new Triple(this.g, this.closedP, this.e), new Triple(this.g, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, this.e)), new Object[]{new Triple(this.e, this.closedP, this.e), new Triple(this.f, this.closedP, this.e), new Triple(this.b, this.closedP, this.e), new Triple(this.c, this.closedP, this.e), new Triple(this.g, this.closedP, this.e)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, this.f)), new Object[]{new Triple(this.f, this.closedP, this.f), new Triple(this.g, this.closedP, this.f), new Triple(this.b, this.closedP, this.f), new Triple(this.c, this.closedP, this.f), new Triple(this.e, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, this.g)), new Object[]{new Triple(this.g, this.closedP, this.g), new Triple(this.e, this.closedP, this.g), new Triple(this.b, this.closedP, this.g), new Triple(this.c, this.closedP, this.g), new Triple(this.f, this.closedP, this.g)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.g, this.closedP, null)), new Object[]{new Triple(this.g, this.closedP, this.g), new Triple(this.g, this.closedP, this.e), new Triple(this.g, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.e, this.closedP, null)), new Object[]{new Triple(this.e, this.closedP, this.g), new Triple(this.e, this.closedP, this.e), new Triple(this.e, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.f, this.closedP, null)), new Object[]{new Triple(this.f, this.closedP, this.g), new Triple(this.f, this.closedP, this.e), new Triple(this.f, this.closedP, this.f)});
    }

    public void testBug1() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directP, this.closedP);
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.a));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.c));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.directP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c)});
    }

    public void testRemove() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directP, this.closedP);
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.c));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.d, this.closedP, this.e));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.d), new Triple(this.a, this.closedP, this.e)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.b, this.closedP, null)), new Object[]{new Triple(this.b, this.closedP, this.b), new Triple(this.b, this.closedP, this.d), new Triple(this.b, this.closedP, this.e)});
        transitiveGraphCache.removeRelation(new Triple(this.b, this.closedP, this.d));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.d), new Triple(this.a, this.closedP, this.e)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.b, this.closedP, null)), new Object[]{new Triple(this.b, this.closedP, this.b)});
        transitiveGraphCache.removeRelation(new Triple(this.a, this.closedP, this.c));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.closedP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.b, this.closedP, null)), new Object[]{new Triple(this.b, this.closedP, this.b)});
    }

    public void testDirect() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directP, this.closedP);
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.c));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.directP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b)});
    }

    public void testCycle() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directP, this.closedP);
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.c));
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.c));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.b));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.directP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c)});
    }

    public void testCycle2() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directP, this.closedP);
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.c));
        transitiveGraphCache.addRelation(new Triple(this.f, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.g));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.d, this.closedP, this.c));
        transitiveGraphCache.addRelation(new Triple(this.d, this.closedP, this.e));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.e));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.b));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.c, this.directP, null)), new Object[]{new Triple(this.c, this.closedP, this.e), new Triple(this.c, this.closedP, this.g), new Triple(this.c, this.closedP, this.b), new Triple(this.c, this.closedP, this.d), new Triple(this.c, this.closedP, this.c)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, this.c)), new Object[]{new Triple(this.a, this.closedP, this.c), new Triple(this.b, this.closedP, this.c), new Triple(this.d, this.closedP, this.c), new Triple(this.f, this.closedP, this.c), new Triple(this.c, this.closedP, this.c)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.f, this.closedP, null)), new Object[]{new Triple(this.f, this.closedP, this.f), new Triple(this.f, this.closedP, this.b), new Triple(this.f, this.closedP, this.c), new Triple(this.f, this.closedP, this.d), new Triple(this.f, this.closedP, this.g), new Triple(this.f, this.closedP, this.e)});
    }

    public void testCycle3() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directP, this.closedP);
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.c));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.a));
        transitiveGraphCache.addRelation(new Triple(this.d, this.closedP, this.e));
        transitiveGraphCache.addRelation(new Triple(this.e, this.closedP, this.f));
        transitiveGraphCache.addRelation(new Triple(this.f, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.f, this.closedP, this.c));
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(this.a, this.directP, null)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.a, this.closedP, this.b), new Triple(this.a, this.closedP, this.c), new Triple(this.a, this.closedP, this.d), new Triple(this.a, this.closedP, this.e), new Triple(this.a, this.closedP, this.f)});
        TestUtil.assertIteratorValues(this, transitiveGraphCache.find(new TriplePattern(null, this.directP, this.a)), new Object[]{new Triple(this.a, this.closedP, this.a), new Triple(this.b, this.closedP, this.a), new Triple(this.c, this.closedP, this.a), new Triple(this.d, this.closedP, this.a), new Triple(this.e, this.closedP, this.a), new Triple(this.f, this.closedP, this.a)});
    }

    public void testEquivalences() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directP, this.closedP);
        transitiveGraphCache.addRelation(new Triple(this.a, this.closedP, this.b));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.a));
        transitiveGraphCache.addRelation(new Triple(this.c, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.d, this.closedP, this.c));
        transitiveGraphCache.addRelation(new Triple(this.b, this.closedP, this.d));
        transitiveGraphCache.addRelation(new Triple(this.d, this.closedP, this.b));
        TestTransitiveGraphCache.assertTrue((String)"Test eq", (boolean)transitiveGraphCache.contains(new TriplePattern(this.a, this.closedP, this.d)));
    }
}

