/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelLoader {
    static Log log = LogFactory.getLog((Class)ModelLoader.class);
    public static final String langXML = "RDF/XML";
    public static final String langXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langN3 = "N3";
    public static final String langBDB = "RDF/BDB";
    public static final String langSQL = "RDF/SQL";

    public static Model loadModel(String string) {
        return ModelLoader.loadModel(string, null);
    }

    public static Model loadModel(String string, String string2) {
        try {
            return FileManager.get().loadModel(string, string2);
        }
        catch (JenaException jenaException) {
            return null;
        }
    }

    public static Model loadModel(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string2 == null) {
            string2 = ModelLoader.guessLang(string);
        }
        if (string2 == null) {
            string2 = langXML;
        }
        if (string2.equals(langBDB)) {
            LogFactory.getLog((Class)ModelLoader.class).fatal((Object)"Failed to open Berkeley database");
            return null;
        }
        if (string2.equals(langSQL)) {
            return ModelLoader.connectToDB(string, string3, string4, string5, string6, string7);
        }
        Model model = ModelFactory.createDefaultModel();
        model.setReaderClassName(langXML, JenaReader.class.getName());
        model.setReaderClassName(langXMLAbbrev, JenaReader.class.getName());
        try {
            FileManager.get().readModel(model, string, null, string2);
        }
        catch (JenaException jenaException) {
            log.warn((Object)"Error loading data source", (Throwable)jenaException);
            return null;
        }
        return model;
    }

    public static Model loadModel(Model model, String string) {
        return ModelLoader.loadModel(model, string, null);
    }

    public static Model loadModel(Model model, String string, String string2) {
        try {
            return FileManager.get().readModel(model, string, null, string2);
        }
        catch (Exception exception) {
            LogFactory.getLog((Class)ModelLoader.class).warn((Object)("No such data source: " + string));
            return null;
        }
    }

    public static Model connectToDB(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            if (string6 != null) {
                Class.forName(string6).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IDBConnection iDBConnection = ModelFactory.createSimpleRDBConnection(string, string2, string3, string5);
            return ModelRDB.open(iDBConnection, string4);
        }
        catch (JenaException jenaException) {
            LogFactory.getLog((Class)ModelLoader.class).error((Object)"Failed to open SQL database: ModelLoader.connectToDB", (Throwable)jenaException);
            throw jenaException;
        }
    }

    public static String guessLang(String string, String string2) {
        if (string.startsWith("jdbc:") || string.startsWith("JDBC:")) {
            return langSQL;
        }
        return FileUtils.guessLang(string, string2);
    }

    public static String guessLang(String string) {
        return FileUtils.guessLang(string);
    }
}

