/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.io.InputStream;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestFileManager
extends TestCase {
    static Log log = LogFactory.getLog((Class)TestFileManager.class);
    static final String testingDir = "testing/FileManager";
    static final String filename = "fmgr-test-file";
    static final String filenameNonExistent = "fmgr-test-file-1421";
    static final String zipname = "testing/FileManager/fmgr-test.zip";

    public TestFileManager(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileManager.class);
    }

    public void testFileManagerFileLocator() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile();
        InputStream inputStream = fileManager.open("testing/FileManager/fmgr-test-file");
        TestFileManager.assertNotNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    public void testFileManagerFileLocatorWithDir() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile(testingDir);
        InputStream inputStream = fileManager.open(filename);
        TestFileManager.assertNotNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    public void testFileManagerNoFile() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile();
        InputStream inputStream = fileManager.open(filenameNonExistent);
        TestFileManager.assertNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    public void testFileManagerLocatorClassLoader() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        InputStream inputStream = fileManager.open("java/lang/String.class");
        TestFileManager.assertNotNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    public void testFileManagerLocatorClassLoaderNotFound() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        InputStream inputStream = fileManager.open("not/java/lang/String.class");
        TestFileManager.assertNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    public void testFileManagerLocatorZip() {
        FileManager fileManager = new FileManager();
        try {
            fileManager.addLocatorZip(zipname);
        }
        catch (Exception exception) {
            TestFileManager.fail((String)"Failed to create a filemanager and add a zip locator");
        }
        InputStream inputStream = fileManager.open(filename);
        TestFileManager.assertNotNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    public void testFileManagerLocatorZipNonFound() {
        FileManager fileManager = new FileManager();
        try {
            fileManager.addLocatorZip(zipname);
        }
        catch (Exception exception) {
            TestFileManager.fail((String)"Failed to create a filemanager and add a zip locator");
        }
        InputStream inputStream = fileManager.open(filenameNonExistent);
        TestFileManager.assertNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    public void testLocationMappingURLtoFileOpen() {
        LocationMapper locationMapper = new LocationMapper("location-mapping-test.n3;testing/FileManager/location-mapping-test.n3");
        FileManager fileManager = new FileManager(locationMapper);
        fileManager.addLocatorFile();
        InputStream inputStream = fileManager.open("http://example.org/file");
        TestFileManager.assertNotNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    public void testLocationMappingURLtoFileOpenNotFound() {
        LocationMapper locationMapper = new LocationMapper("location-mapping-test.n3;testing/FileManager/location-mapping-test.n3");
        FileManager fileManager = new FileManager(locationMapper);
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        InputStream inputStream = fileManager.open("http://example.org/file");
        TestFileManager.assertNull((Object)inputStream);
        this.closeInputStream(inputStream);
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

