/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public class ElementSubstVisitor
implements ElementVisitor {
    Model model;
    Collection acc;
    Binding binding;

    ElementSubstVisitor(Model model, Collection collection, Binding binding) {
        this.model = model;
        this.acc = collection;
        this.binding = binding;
    }

    public void visit(ElementBasePattern elementBasePattern) {
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            Triple triple = (Triple)listIterator.next();
            Triple triple2 = QueryEngineUtils.substituteIntoTriple(triple, this.binding);
            this.acc.add(triple2);
        }
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        Triple triple = QueryEngineUtils.substituteIntoTriple(elementTriplePattern.getTriple(), this.binding);
        this.acc.add(triple);
    }

    public void visit(ElementBlock elementBlock) {
        if (elementBlock.getQueryElement() != null) {
            ((Element)elementBlock.getQueryElement()).visit(this);
        }
    }

    public void visit(ElementConstraints elementConstraints) {
    }

    public void visit(ElementUnion elementUnion) {
        ListIterator listIterator = elementUnion.getElements().listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            element.visit(this);
        }
    }

    public void visit(ElementGroup elementGroup) {
        Iterator iterator = elementGroup.getElements().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
        }
    }

    public void visit(ElementOptional elementOptional) {
        elementOptional.getElement().visit(this);
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        throw new UnsupportedOperationException("ElementSubstVisitor.visit(ElementNamedGraph");
    }

    public void visit(ElementUnsaid elementUnsaid) {
    }
}

