/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.VariableNotBoundException;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class NodeVar
extends ExprNode {
    String name;

    public NodeVar(String string) {
        this.name = string;
    }

    public NodeVar(Node node) {
        if (!node.isVariable()) {
            throw new ARQInternalErrorException("Attempt to create a NodeVar from a non variable Node: " + node);
        }
        this.name = node.getName();
    }

    public NodeValue eval(Binding binding) {
        if (binding == null) {
            throw new VariableNotBoundException(this.name);
        }
        Node node = binding.get(this.name);
        if (node == null) {
            throw new VariableNotBoundException(this.name);
        }
        return NodeValue.makeNode(node);
    }

    public void check() {
    }

    public String getName() {
        return this.name;
    }

    public void visit(ExprVisitor exprVisitor) {
        exprVisitor.visit(this);
    }

    public void format(Query query2, IndentedWriter indentedWriter) {
        indentedWriter.print('?');
        indentedWriter.print(this.name);
    }

    public String toString() {
        return "?" + this.name;
    }
}

