/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.TripleCollector;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.util.LabelToNodeMap;
import com.hp.hpl.jena.vocabulary.RDF;

public class ParserBase {
    protected Node XSD_TRUE = Node.createLiteral((String)"true", null, (RDFDatatype)XSDDatatype.XSDboolean);
    protected Node XSD_FALSE = Node.createLiteral((String)"false", null, (RDFDatatype)XSDDatatype.XSDboolean);
    protected Node nRDFtype = RDF.type.getNode();
    protected Node nRDFnil = RDF.nil.getNode();
    protected Node nRDFfirst = RDF.first.getNode();
    protected Node nRDFrest = RDF.rest.getNode();
    protected Node nRDFsubject = RDF.subject.getNode();
    protected Node nRDFpredicate = RDF.predicate.getNode();
    protected Node nRDFobject = RDF.object.getNode();
    LabelToNodeMap bNodeLabels = new LabelToNodeMap();
    Query query;

    public void setQuery(Query query2) {
        this.query = query2;
    }

    public Query getQuery() {
        return this.query;
    }

    protected Element compressGroupOfOneGroup(ElementGroup elementGroup) {
        Element element;
        if (elementGroup.getElements().size() == 1 && (element = (Element)elementGroup.getElements().get(0)) instanceof ElementGroup) {
            return element;
        }
        return elementGroup;
    }

    protected Node makeNodeInteger(String string) {
        return Node.createLiteral((String)string, null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    protected Node makeNodeInteger(long l) {
        return Node.createLiteral((String)Long.toString(l), null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    protected Node makeNodeDouble(String string) {
        return Node.createLiteral((String)string, null, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    protected Node makeNode(String string, String string2, Node node) {
        String string3 = node == null ? null : node.getURI();
        return this.makeNode(string, string2, string3);
    }

    protected Node makeNode(String string, String string2, String string3) {
        Node node = null;
        if (string3 != null) {
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string3);
            node = Node.createLiteral((String)string, null, (RDFDatatype)rDFDatatype);
        } else {
            node = Node.createLiteral((String)string, (String)string2, null);
        }
        return node;
    }

    protected long integerValue(String string) {
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        if (string.startsWith("0x")) {
            string = string.substring(2);
            return Long.parseLong(string, 16);
        }
        return Long.parseLong(string);
    }

    protected double doubleValue(String string) {
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        double d = Double.parseDouble(string);
        return d;
    }

    protected String stripQuotes(String string) {
        return string.substring(1, string.length() - 1);
    }

    protected String stripChars(String string, int n) {
        return string.substring(n, string.length());
    }

    protected String unescape(String string) {
        return ParserBase.unescape(string, '\\');
    }

    protected Node createBNode() {
        return Node.createAnon();
    }

    protected Node createBNode(String string) {
        return this.bNodeLabels.asNode(string);
    }

    protected void insert(TripleCollector tripleCollector, Node node, Node node2, Node node3) {
        tripleCollector.addTriple(new Triple(node, node2, node3));
    }

    protected void insert(TripleCollector tripleCollector, int n, Node node, Node node2, Node node3) {
        tripleCollector.addTriple(n, new Triple(node, node2, node3));
    }

    protected Expr asExpr(Node node) {
        if (node.isVariable()) {
            return new NodeVar(node.getName());
        }
        return NodeValue.makeNode(node);
    }

    protected static String unescape(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c || i >= string.length() - 1) continue;
            char c2 = string.charAt(i + 1);
            if (c2 == 'n') {
                c2 = '\n';
            }
            if (c2 == 't') {
                c2 = '\t';
            }
            if (c2 == 'r') {
                c2 = '\r';
            }
            if (c2 == 'b') {
                c2 = '\b';
            }
            string = string.substring(0, i) + c2 + string.substring(i + 2);
        }
        return string;
    }
}

