/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import junit.framework.TestSuite;

public class TestNsPrefix
extends AbstractTestPrefixMapping {
    public TestNsPrefix(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNsPrefix.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    protected PrefixMapping getMapping() {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        return ModelRDB.createModel(iDBConnection);
    }

    public void testSinglePrefix() throws Exception {
        String string = "testPrefix";
        String string2 = "http://someTestURI#";
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB.setNsPrefix(string, string2);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 1 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        modelRDB.close();
        iDBConnection.close();
    }

    public void testDuplicatePrefix() throws Exception {
        String string = "testPrefix";
        String string2 = "http://someTestURI#";
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB.setNsPrefix(string, string2);
        modelRDB.setNsPrefix(string, string2);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 1 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        modelRDB.close();
        iDBConnection.close();
    }

    public void testChangingPrefixMapping() throws Exception {
        String string = "testPrefix";
        String string2 = "http://someTestURI#";
        String string3 = "http://someOtherTestURI#";
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB.setNsPrefix(string, string2);
        modelRDB.setNsPrefix(string, string3);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 1 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string2) != 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string3) == 0 ? 1 : 0) != 0);
        modelRDB.close();
        iDBConnection.close();
    }

    public void testPersistenceOfPrefixes() throws Exception {
        String string = "testPrefix";
        String string2 = "http://someTestURI#";
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB.setNsPrefix(string, string2);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 1 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName");
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB2.remove();
        modelRDB2.close();
        ModelRDB modelRDB3 = ModelRDB.open(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixMap().size() == 1 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        modelRDB3.close();
        iDBConnection.close();
    }

    public void testIdependenceOfPrefixes() throws Exception {
        String string = "testPrefix1";
        String string2 = "http://someTestURI1#";
        String string3 = "testPrefix2";
        String string4 = "http://someTestURI2#";
        String string5 = "testPrefix3";
        String string6 = "http://someTestURI3#";
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB.setNsPrefix(string, string2);
        modelRDB.setNsPrefix(string3, string4);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string3).compareTo(string4) == 0 ? 1 : 0) != 0);
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "secondGraph");
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB2.setNsPrefix(string3, string4);
        modelRDB2.setNsPrefix(string5, string6);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string3).compareTo(string4) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string5).compareTo(string6) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string3).compareTo(string4) == 0 ? 1 : 0) != 0);
        modelRDB2.remove();
        modelRDB2.close();
        modelRDB2 = null;
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string3).compareTo(string4) == 0 ? 1 : 0) != 0);
        modelRDB.close();
        modelRDB = null;
        ModelRDB modelRDB3 = ModelRDB.open(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixURI(string3).compareTo(string4) == 0 ? 1 : 0) != 0);
        modelRDB3.close();
        iDBConnection.close();
    }

    public void testPersistedChangedPrefixes() throws Exception {
        String string = "testPrefix1";
        String string2 = "http://someTestURI/1#";
        String string3 = "http://someTestURI/1b#";
        String string4 = "testPrefix2";
        String string5 = "http://someTestURI/2#";
        String string6 = "testPrefix3";
        String string7 = "http://someTestURI/3#";
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB.setNsPrefix(string, string2);
        modelRDB.setNsPrefix(string4, string5);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string4).compareTo(string5) == 0 ? 1 : 0) != 0);
        modelRDB.close();
        modelRDB = null;
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string).compareTo(string2) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string4).compareTo(string5) == 0 ? 1 : 0) != 0);
        modelRDB2.setNsPrefix(string, string3);
        modelRDB2.setNsPrefix(string6, string7);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixMap().size() == 3 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string).compareTo(string3) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string4).compareTo(string5) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string6).compareTo(string7) == 0 ? 1 : 0) != 0);
        modelRDB2.close();
        modelRDB2 = null;
        ModelRDB modelRDB3 = ModelRDB.open(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixMap().size() == 3 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixURI(string).compareTo(string3) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixURI(string4).compareTo(string5) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB3.getNsPrefixURI(string6).compareTo(string7) == 0 ? 1 : 0) != 0);
        modelRDB3.close();
        iDBConnection.close();
    }

    public void testCopyPersistentPrefixMapping() throws Exception {
        String string = "testPrefix1";
        String string2 = "testPrefix2";
        String string3 = "http://someTestURI/1#";
        String string4 = "http://someTestURI/2#";
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB.setNsPrefix(string, string3);
        modelRDB.setNsPrefix(string2, string4);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string3) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string2).compareTo(string4) == 0 ? 1 : 0) != 0);
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "secondModel");
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB2.setNsPrefixes(modelRDB.getNsPrefixMap());
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string).compareTo(string3) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB2.getNsPrefixURI(string2).compareTo(string4) == 0 ? 1 : 0) != 0);
        modelRDB.close();
        modelRDB2.close();
        iDBConnection.close();
    }

    public void testCopyMemoryPrefixMapping() throws Exception {
        String string = "testPrefix1";
        String string2 = "testPrefix2";
        String string3 = "http://someTestURI/1#";
        String string4 = "http://someTestURI/2#";
        PrefixMappingImpl prefixMappingImpl = new PrefixMappingImpl();
        prefixMappingImpl.setNsPrefix(string, string3);
        prefixMappingImpl.setNsPrefix(string2, string4);
        TestNsPrefix.assertTrue((prefixMappingImpl.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((prefixMappingImpl.getNsPrefixURI(string).compareTo(string3) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((prefixMappingImpl.getNsPrefixURI(string2).compareTo(string4) == 0 ? 1 : 0) != 0);
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 0 ? 1 : 0) != 0);
        modelRDB.setNsPrefixes(prefixMappingImpl);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixMap().size() == 2 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string).compareTo(string3) == 0 ? 1 : 0) != 0);
        TestNsPrefix.assertTrue((modelRDB.getNsPrefixURI(string2).compareTo(string4) == 0 ? 1 : 0) != 0);
        modelRDB.close();
        iDBConnection.close();
    }
}

