/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.enhanced.UnsupportedPolymorphismException;
import com.hp.hpl.jena.graph.FrontsNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.RDFNode;

public class EnhNode
extends Polymorphic
implements FrontsNode {
    protected final Node node;
    protected final EnhGraph enhGraph;

    public EnhNode(Node node, EnhGraph enhGraph) {
        this.node = node;
        this.enhGraph = enhGraph;
    }

    public Node asNode() {
        return this.node;
    }

    public EnhGraph getGraph() {
        return this.enhGraph;
    }

    public EnhNode viewAs(Class clazz) {
        return (EnhNode)this.asInternal(clazz);
    }

    public RDFNode as(Class clazz) {
        return (RDFNode)((Object)this.viewAs(clazz));
    }

    public boolean canAs(Class clazz) {
        return this.canSupport(clazz);
    }

    public final int hashCode() {
        return this.node.hashCode();
    }

    public final boolean equals(Object object) {
        return object instanceof FrontsNode && this.node.equals(((FrontsNode)object).asNode());
    }

    public boolean isValid() {
        return true;
    }

    protected Polymorphic convertTo(Class clazz) {
        EnhGraph enhGraph = this.getGraph();
        Implementation implementation = this.getPersonality().getImplementation(clazz);
        if (implementation == null) {
            throw new UnsupportedPolymorphismException(enhGraph, clazz);
        }
        EnhNode enhNode = implementation.wrap(this.asNode(), enhGraph);
        this.addView(enhNode);
        return enhNode;
    }

    protected boolean canSupport(Class clazz) {
        return this.getPersonality().getImplementation(clazz).canWrap(this.asNode(), this.getGraph());
    }

    protected Personality getPersonality() {
        return ((GraphPersonality)this.getGraph().getPersonality()).nodePersonality();
    }
}

