/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestSuite;

public class TestModelSpecWithSchema
extends ModelTestBase {
    protected static final Filter inJMS = new Filter(){

        public boolean accept(Object object) {
            Statement statement = (Statement)object;
            return statement.getSubject().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#") && statement.getResource().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#");
        }
    };

    public TestModelSpecWithSchema(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecWithSchema.class);
    }

    public void testReificationMode() {
        this.testDomain("jms:reificationMode rdfs:domain jms:MakerSpec");
    }

    public void testMaker() {
        this.testDomain("jms:maker rdfs:domain jms:PlainModelSpec");
    }

    public void testImportMaker() {
        this.testDomain("jms:importMaker rdfs:domain jms:OntModelSpec");
    }

    public void testOntLanguage() {
        this.testDomain("jms:ontLanguage rdfs:domain jms:OntModelSpec");
    }

    public void testReasonsWith() {
        this.testDomain("jms:reasonsWith rdfs:domain jms:InfModelSpec");
    }

    public void testModelName() {
        this.testDomain("jms:modelName rdfs:domain jms:ModelSpec");
    }

    public void testFileBase() {
        this.testDomain("jms:fileBase rdfs:domain jms:FileMakerSpec");
    }

    public void testSubclasses() {
        Set set;
        Model model = JenaModelSpec.getSchema();
        Model model2 = ModelSpecFactory.withSpecSchema(((InfModel)JenaModelSpec.getSchema()).getRawModel());
        Set set2 = TestModelSpecWithSchema.iteratorToSet(model.listStatements(null, RDFS.subClassOf, (RDFNode)null).filterKeep(inJMS));
        if (!((Object)set2).equals(set = TestModelSpecWithSchema.iteratorToSet(model2.listStatements(null, RDFS.subClassOf, (RDFNode)null)))) {
            HashSet hashSet = new HashSet(set);
            hashSet.removeAll(set2);
            HashSet hashSet2 = new HashSet(set2);
            hashSet2.remove(set);
            System.err.println(">> " + hashSet);
            System.err.println(">> " + hashSet2);
            TestModelSpecWithSchema.fail((String)"not equal");
        }
    }

    protected void testDomain(String string) {
        Statement statement = TestModelSpecWithSchema.statement(string);
        Property property = (Property)statement.getSubject().as(Property.class);
        Resource resource = statement.getResource();
        Resource resource2 = ResourceFactory.createResource();
        Resource resource3 = ResourceFactory.createResource();
        Model model = ModelFactory.createDefaultModel().add(resource2, property, resource3);
        Model model2 = ModelSpecFactory.withSpecSchema(model);
        StmtIterator stmtIterator = model2.listStatements(resource, RDFS.subClassOf, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            TestModelSpecWithSchema.assertTrue((boolean)model2.contains(resource2, RDF.type, stmtIterator.nextStatement().getObject()));
        }
    }

    protected void testOK(String string, String string2) {
        this.assertIsoModels(this.m(string), ModelSpecFactory.withSpecSchema(this.m(string2)));
    }

    public Model m(String string) {
        return TestModelSpecWithSchema.modelWithStatements(string);
    }
}

