/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGConnectionPool;
import com.hp.hpl.jena.reasoner.dig.DIGErrorResponseException;
import com.hp.hpl.jena.reasoner.dig.DIGQueryEquivalentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTypesTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGValueToNodeMapper;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;

public class DIGInfGraph
extends BaseInfGraph {
    protected DIGAdapter m_adapter;

    public DIGInfGraph(Graph graph, DIGReasoner dIGReasoner) {
        super(graph, dIGReasoner);
        if (dIGReasoner.getSchema() != null) {
            this.fdata = new FGraph(new MultiUnion(new Graph[]{graph, dIGReasoner.getSchema()}));
        }
        DIGConnection dIGConnection = DIGConnectionPool.getInstance().allocate(dIGReasoner.getReasonerURL());
        this.m_adapter = new DIGAdapter(dIGReasoner.getOntLangModelSpec(), this.fdata.getGraph(), dIGConnection, dIGReasoner.getAxioms());
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.m_adapter.resetKB();
            this.m_adapter.uploadKB();
            this.isPrepared = true;
        }
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.prepare();
        return this.m_adapter.find(triplePattern);
    }

    public ExtendedIterator find(Node node, Node node2, Node node3, Graph graph) {
        OntModel ontModel = ModelFactory.createOntologyModel(this.m_adapter.getSourceSpecification(), ModelFactory.createModelForGraph(graph));
        ontModel.setStrictMode(false);
        this.prepare();
        return this.m_adapter.find(new TriplePattern(node, node2, node3), ontModel);
    }

    public Graph getSchemaGraph() {
        return ((DIGReasoner)this.reasoner).getSchema();
    }

    public synchronized void performAdd(Triple triple) {
        this.fdata.getGraph().add(triple);
        this.isPrepared = false;
    }

    public void performDelete(Triple triple) {
        this.fdata.getGraph().delete(triple);
        this.isPrepared = false;
    }

    public void rebind(Graph graph) {
        this.fdata = this.getSchemaGraph() == null ? new FGraph(graph) : new FGraph(new MultiUnion(new Graph[]{graph, this.getSchemaGraph()}));
        this.isPrepared = false;
    }

    public void setDerivationLogging(boolean bl) {
        throw new UnsupportedOperationException("Cannot set derivation logging on DIG reasoner");
    }

    public ValidityReport validate() {
        Object object;
        Object object2;
        this.checkOpen();
        this.prepare();
        StandardValidityReport standardValidityReport = new StandardValidityReport();
        try {
            this.m_adapter.collectNamedTerms("allIndividuals", new String[]{"individualSet", "individual"});
        }
        catch (DIGErrorResponseException dIGErrorResponseException) {
            standardValidityReport.add(true, "DIG KB incoherent", dIGErrorResponseException.getMessage());
        }
        Profile profile = this.m_adapter.getOntLanguage();
        Node node = profile.NOTHING().asNode();
        Property property = profile.EQUIVALENT_CLASS();
        DIGQueryEquivalentsTranslator dIGQueryEquivalentsTranslator = new DIGQueryEquivalentsTranslator(property.getURI(), true);
        ExtendedIterator extendedIterator = dIGQueryEquivalentsTranslator.find(new TriplePattern(null, property.asNode(), profile.NOTHING().asNode()), this.m_adapter);
        while (extendedIterator.hasNext()) {
            object2 = (Triple)extendedIterator.next();
            object = ((Triple)object2).getSubject();
            if (object == node) continue;
            standardValidityReport.add(true, "unsatisfiable class", ((Node)object).isBlank() ? ((Node)object).getBlankNodeId().toString() : ((Node)object).getURI(), ((Triple)object2).getSubject());
        }
        object2 = new DIGQueryTypesTranslator(RDF.type.getURI());
        object = new DIGValueToNodeMapper();
        Iterator iterator = this.m_adapter.getKnownIndividuals().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Node node2 = (Node)((DIGValueToNodeMapper)object).map1(string);
            try {
                ExtendedIterator extendedIterator2 = ((DIGQueryTranslator)object2).find(new TriplePattern(node2, RDF.type.asNode(), null), this.m_adapter);
            }
            catch (DIGErrorResponseException dIGErrorResponseException) {
                standardValidityReport.add(true, "meaningless individual", node2.isBlank() ? node2.getBlankNodeId().toString() : node2.getURI(), string);
            }
        }
        return standardValidityReport;
    }
}

