/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.publish.uddi.wsdls;

import de.uka.cmtm.serviceregistry.publish.uddi.UddiTModels;
import de.uka.cmtm.serviceregistry.publish.uddi.UddiUtils;
import de.uka.cmtm.serviceregistry.publish.uddi.WsdlPublisher;
import de.uka.cmtm.serviceregistry.publish.uddi.wsdl.WsdlPublisherV01_08;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.AuthToken;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class SaWsdlPublisherV01_08
extends WsdlPublisherV01_08
implements WsdlPublisher {
    private static final QName MODEL_REFERENCE_QNAME = new QName("http://www.w3.org/2002/ws/sawsdl/spec/sawsdl#", "modelReference");
    private String upperServiceOntologyUrl;
    private UddiUtils uddiUtils;

    public SaWsdlPublisherV01_08(UDDIProxy uddiProxy, AuthToken authToken, String upperServiceOntologyUrl) {
        super(uddiProxy, authToken);
        this.uddiUtils = new UddiUtils(uddiProxy, authToken);
        this.upperServiceOntologyUrl = upperServiceOntologyUrl;
    }

    protected void addServiceCategoryBagKeyedReferences(CategoryBag categoryBag, Service service) throws UDDIException, TransportException {
        HashSet<String> profiles = new HashSet<String>();
        Collection ports = service.getPorts().values();
        for (Port port : ports) {
            List operations = port.getBinding().getPortType().getOperations();
            for (Operation operation : operations) {
                Object attr = operation.getExtensionAttribute(MODEL_REFERENCE_QNAME);
                if (attr == null) continue;
                profiles.add(attr.toString());
            }
        }
        if (!profiles.isEmpty()) {
            TModel serviceProfileTModel = this.publishServiceProfileTModel();
            for (String profile : profiles) {
                KeyedReference kRef = new KeyedReference();
                kRef.setTModelKey(serviceProfileTModel.getTModelKey());
                kRef.setKeyName("ServiceProfile");
                kRef.setKeyValue(profile);
                categoryBag.add(kRef);
            }
        }
    }

    private TModel publishServiceProfileTModel() throws UDDIException, TransportException {
        CategoryBag cBag = new CategoryBag();
        KeyedReference kRef = new KeyedReference();
        kRef.setTModelKey(UddiTModels.TYPES.getKey());
        kRef.setKeyName(UddiTModels.TYPES.getName());
        kRef.setKeyValue("categorization");
        cBag.add(kRef);
        return this.uddiUtils.publishTModel(UddiTModels.SERVICE_PROFILE.getName(), "Service Profile Reference", this.upperServiceOntologyUrl, cBag);
    }
}

