/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.query.uddi;

import de.uka.cmtm.serviceregistry.publish.uddi.UddiTModels;
import de.uka.cmtm.serviceregistry.publish.uddi.UddiUtils;
import de.uka.cmtm.serviceregistry.query.ServiceInstanceInfo;
import de.uka.cmtm.serviceregistry.query.ServiceInstanceLocator;
import de.uka.cmtm.serviceregistry.query.ServiceInstanceParameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.binding.TModelInstanceInfo;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UddiServiceInstanceLocatorV01_08
implements ServiceInstanceLocator {
    private UddiUtils uddiUtils;
    private Map<String, String> wsdlLocationCache = new HashMap<String, String>();
    private Map<String, String> businessNameCache = new HashMap<String, String>();

    public UddiServiceInstanceLocatorV01_08(UDDIProxy uddiProxy) {
        this.uddiUtils = new UddiUtils(uddiProxy);
    }

    @Override
    public List<ServiceInstanceInfo> findSeviceInstances(ServiceInstanceParameter searchParameter) throws IOException {
        try {
            LinkedList<ServiceInstanceInfo> results = new LinkedList<ServiceInstanceInfo>();
            TModel serviceProfileTModel = this.findServiceProfileTModel();
            if (serviceProfileTModel != null) {
                List<Object> businessInfos;
                String businessName = searchParameter.getBusinessName();
                if (businessName != null && !"".equals(businessName)) {
                    businessInfos = this.uddiUtils.findBusinesses(businessName, Integer.MAX_VALUE);
                } else {
                    businessInfos = new ArrayList<BusinessInfo>(1);
                    businessInfos.add(new BusinessInfo(null, null, null));
                }
                CategoryBag categoryBag = new CategoryBag();
                KeyedReference kRef = new KeyedReference();
                kRef.setTModelKey(serviceProfileTModel.getTModelKey());
                kRef.setKeyValue(searchParameter.getProfileUri());
                categoryBag.add(kRef);
                for (BusinessInfo businessInfo : businessInfos) {
                    this.wsdlLocationCache.clear();
                    this.businessNameCache.clear();
                    List<ServiceInfo> serviceInfos = this.uddiUtils.findServices(businessInfo.getBusinessKey(), categoryBag, Integer.MAX_VALUE);
                    if (businessInfo.getBusinessKey() != null && businessInfo.getDefaultNameString() != null) {
                        this.businessNameCache.put(businessInfo.getBusinessKey(), businessInfo.getDefaultNameString());
                    }
                    for (ServiceInfo serviceInfo : serviceInfos) {
                        ServiceInstanceInfo sif = new ServiceInstanceInfo();
                        sif.setBusinessName(this.findBusinessName(serviceInfo.getBusinessKey()));
                        sif.setProfileUri(searchParameter.getProfileUri());
                        sif.setRelevance(0.0);
                        sif.setServiceName(serviceInfo.getDefaultNameString());
                        sif.setWsdlLocation(this.findWsdlLocation(serviceInfo.getServiceKey()));
                        results.add(sif);
                    }
                }
            }
            return results;
        }
        catch (UDDIException e) {
            IOException ioe = new IOException("Problem while communicating with UDDI.");
            ioe.initCause(e);
            throw ioe;
        }
        catch (TransportException e) {
            IOException ioe = new IOException("Problem while communicating with UDDI.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private String findBusinessName(String businessKey) throws UDDIException, TransportException {
        String businessName = this.businessNameCache.get(businessKey);
        if (businessName == null) {
            BusinessEntity businessEntity = this.uddiUtils.getBusinessEntity(businessKey);
            businessName = businessEntity.getDefaultNameString();
            this.businessNameCache.put(businessKey, businessName);
        }
        return businessName;
    }

    private String findWsdlLocation(String serviceKey) throws UDDIException, TransportException {
        String wsdlLocation = this.wsdlLocationCache.get(serviceKey);
        if (wsdlLocation == null) {
            BusinessService businessService = this.uddiUtils.getBusinessService(serviceKey);
            Vector bindingTemplates = businessService.getBindingTemplates().getBindingTemplateVector();
            for (BindingTemplate bindingTemplate : bindingTemplates) {
                Vector tModelInstanceInfos = bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfoVector();
                for (TModelInstanceInfo tModelInstanceInfo : tModelInstanceInfos) {
                    TModel tModel = this.uddiUtils.getTModel(tModelInstanceInfo.getTModelKey());
                    Vector keyedReferences = tModel.getCategoryBag().getKeyedReferenceVector();
                    for (KeyedReference keyedReference : keyedReferences) {
                        if (!UddiTModels.TYPES.getKey().equals(keyedReference.getTModelKey()) || !"wsdlSpec".equals(keyedReference.getKeyValue())) continue;
                        wsdlLocation = tModel.getOverviewDoc().getOverviewURLString();
                        this.wsdlLocationCache.put(serviceKey, wsdlLocation);
                        return wsdlLocation;
                    }
                }
            }
        }
        return wsdlLocation;
    }

    private TModel findServiceProfileTModel() throws UDDIException, TransportException {
        CategoryBag cBag = new CategoryBag();
        KeyedReference kRef = new KeyedReference();
        kRef.setTModelKey(UddiTModels.TYPES.getKey());
        kRef.setKeyName(UddiTModels.TYPES.getName());
        kRef.setKeyValue("categorization");
        cBag.add(kRef);
        return this.uddiUtils.findTModel(UddiTModels.SERVICE_PROFILE.getName(), cBag);
    }
}

