/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.cleandispatch;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.cleandispatch.Dispatch;
import edu.stanford.smi.protege.util.Log;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

abstract class AbstractRedirectingDispatch
implements Dispatch {
    AbstractRedirectingDispatch() {
    }

    public List getDirectOwnSlotValues(FrameStore frameStore, Frame frame, Slot slot) {
        List list;
        if (this.isCorrectFrameType(frame)) {
            list = this.getCurrentValues(frameStore, frame);
        } else {
            Log.getLogger().warning("Invalid frame type: " + frame);
            list = frameStore.getDirectOwnSlotValues(frame, slot);
        }
        return list;
    }

    public void setDirectOwnSlotValues(FrameStore frameStore, Frame frame, Slot slot, Collection collection) {
        if (this.isCorrectFrameType(frame)) {
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.getCurrentValues(frameStore, frame));
            this.addValues(frameStore, frame, linkedHashSet, collection);
            this.removeValues(frameStore, frame, linkedHashSet, collection);
        } else {
            Log.getLogger().warning("Invalid frame type: " + frame);
            frameStore.setDirectOwnSlotValues(frame, slot, collection);
        }
    }

    private void addValues(FrameStore frameStore, Frame frame, Collection collection, Collection collection2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(collection2);
        linkedHashSet.removeAll(collection);
        for (Object e : linkedHashSet) {
            if (this.isCorrectValueType(e)) {
                this.addValue(frameStore, frame, e);
                continue;
            }
            Log.getLogger().warning("Ignoring invalid value: " + e);
        }
    }

    private void removeValues(FrameStore frameStore, Frame frame, Collection collection, Collection collection2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(collection);
        linkedHashSet.removeAll(collection2);
        for (Object e : linkedHashSet) {
            if (this.isCorrectValueType(e)) {
                this.removeValue(frameStore, frame, e);
                continue;
            }
            Log.getLogger().warning("Ignoring invalid value: " + e);
        }
    }

    abstract List getCurrentValues(FrameStore var1, Frame var2);

    abstract void addValue(FrameStore var1, Frame var2, Object var3);

    abstract void removeValue(FrameStore var1, Frame var2, Object var3);

    abstract boolean isCorrectFrameType(Frame var1);

    abstract boolean isCorrectValueType(Object var1);
}

