/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteSession;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Session
implements RemoteSession,
Externalizable {
    private static int nextId = 100;
    private int id;
    private String userName;
    private String userIpAddress;
    private long startTime;
    private long lastAccessTime;

    public Session(String string, String string2) {
        this.id = nextId++;
        this.userName = string;
        this.userIpAddress = string2;
        this.lastAccessTime = this.startTime = Session.currentTime();
    }

    public Session() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.id);
        objectOutput.writeUTF(this.userName);
        objectOutput.writeUTF(this.userIpAddress);
        objectOutput.writeLong(this.startTime);
        objectOutput.writeLong(this.lastAccessTime);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.id = objectInput.readInt();
        this.userName = objectInput.readUTF();
        this.userIpAddress = objectInput.readUTF();
        this.startTime = objectInput.readLong();
        this.lastAccessTime = objectInput.readLong();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserIpAddress() {
        return this.userIpAddress;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void updateAccessTime() {
        this.lastAccessTime = Session.currentTime();
    }

    private static long currentTime() {
        return System.currentTimeMillis();
    }

    public boolean equals(Object object) {
        return this.id == ((Session)object).id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "Session(id=" + this.id + ", user=" + this.userName + ")";
    }
}

