/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FormParentChildRoot;
import edu.stanford.smi.protege.ui.FormRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.widget.ClsWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class FormsPanel
extends SelectableContainer {
    private Project _project;
    private SelectableTree _tree;
    private LabeledComponent _labeledComponent;
    private ProjectListener _projectListener = new ProjectAdapter(){

        public void formChanged(ProjectEvent projectEvent) {
            TreePath treePath = FormsPanel.this._tree.getSelectionPath();
            if (treePath != null) {
                LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
                lazyTreeNode.notifyNodeChanged(lazyTreeNode);
            }
            FormsPanel.this._tree.repaint();
        }
    };

    public FormsPanel(Project project) {
        this._project = project;
        this._project.addProjectListener(this._projectListener);
        this._tree = this.createTree();
        String string = LocalizedText.getText(ResourceKey.FORM_BROWSER_FORMS_LABEL);
        this._labeledComponent = new LabeledComponent(string, ComponentFactory.createScrollPane(this._tree));
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this._labeledComponent.addHeaderButton(this.createCustomizationsAction());
        this._labeledComponent.addHeaderButton(this.createRemoveCustomizationsAction());
        this._labeledComponent.addHeaderButton(this.createRelayoutAction());
        this._labeledComponent.addHeaderButton(this.createLayoutLikeOtherFormAction());
        this._labeledComponent.setFooterComponent(this.createFinderControl());
        this._tree.setCellRenderer(new FormRenderer(this._project));
        this.add((Component)this._labeledComponent, "Center");
        this.add((Component)this.createHeader(), "North");
        this.setSelectable(this._tree);
    }

    private JComponent createHeader() {
        JLabel jLabel = ComponentFactory.createLabel(Icons.getProjectIcon());
        jLabel.setText(this._project.getName());
        String string = LocalizedText.getText(ResourceKey.FORM_BROWSER_TITLE);
        String string2 = LocalizedText.getText(ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent headerComponent = new HeaderComponent(string, string2, jLabel);
        headerComponent.setColor(Colors.getFormColor());
        return headerComponent;
    }

    private JComponent createFinderControl() {
        return new ClsTreeFinder(this.getKnowledgeBase(), (JTree)this._tree, ResourceKey.FORM_SEARCH_FOR);
    }

    private Action createLayoutLikeOtherFormAction() {
        StandardAction standardAction = new StandardAction(ResourceKey.FORM_LAYOUT_LIKE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Cls cls;
                Collection collection = FormsPanel.this.getSelection();
                if (!collection.isEmpty() && (cls = DisplayUtilities.pickForm(FormsPanel.this, FormsPanel.this._project)) != null) {
                    WaitCursor waitCursor = new WaitCursor(FormsPanel.this);
                    try {
                        for (Cls cls2 : collection) {
                            ClsWidget clsWidget = FormsPanel.this.getClsWidget(cls2);
                            clsWidget.layoutLikeCls(cls);
                        }
                    }
                    finally {
                        waitCursor.hide();
                    }
                }
            }
        };
        return standardAction;
    }

    private Action createRelayoutAction() {
        return new StandardAction(ResourceKey.FORM_RELAYOUT){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Cls cls : FormsPanel.this.getSelection()) {
                    ClsWidget clsWidget = FormsPanel.this.getClsWidget(cls);
                    clsWidget.relayout();
                }
            }
        };
    }

    private Action createRemoveCustomizationsAction() {
        return new StandardAction(ResourceKey.FORM_REMOVE_CUSTOMIZATIONS){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Cls cls : FormsPanel.this.getSelection()) {
                    ClsWidget clsWidget = FormsPanel.this.getClsWidget(cls);
                    clsWidget.removeCustomizations();
                }
            }
        };
    }

    private Action createCustomizationsAction() {
        return new StandardAction(ResourceKey.FORM_VIEW_CUSTOMIZATIONS){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Cls cls : FormsPanel.this.getSelection()) {
                    ClsWidget clsWidget = FormsPanel.this.getClsWidget(cls);
                    clsWidget.configure();
                }
            }
        };
    }

    public LazyTreeRoot createRoot() {
        return new FormParentChildRoot(this.getKnowledgeBase().getRootCls());
    }

    private SelectableTree createTree() {
        Cls cls = this.getKnowledgeBase().getRootCls();
        SelectableTree selectableTree = ComponentFactory.createSelectableTree(null, new ParentChildRoot(cls));
        selectableTree.setLargeModel(true);
        selectableTree.addMouseListener(new TreePopupMenuMouseListener(selectableTree){

            public JPopupMenu getPopupMenu() {
                return FormsPanel.this.getPopupMenu();
            }
        });
        return selectableTree;
    }

    public void dispose() {
        this._project.removeProjectListener(this._projectListener);
    }

    public JTree getFormsTree() {
        return this._tree;
    }

    private ClsWidget getClsWidget(Cls cls) {
        return this._project.getDesignTimeClsWidget(cls);
    }

    private KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    public LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = null;
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.getRemoveDecendentCustomizations());
        }
        return jPopupMenu;
    }

    private Action getRemoveDecendentCustomizations() {
        return new AbstractAction("Remove subclass customizations"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                WaitCursor waitCursor = new WaitCursor(FormsPanel.this);
                try {
                    FormsPanel.this.removeCustomizations();
                }
                finally {
                    waitCursor.hide();
                }
            }
        };
    }

    private void removeCustomizations() {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(this.getSelection());
        for (Cls cls2 : cls.getSubclasses()) {
            if (!this._project.hasCustomizedDescriptor(cls2)) continue;
            ClsWidget clsWidget = this.getClsWidget(cls2);
            clsWidget.removeCustomizations();
        }
    }
}

