/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ArchiveRecord;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class ArchiveManager {
    private static final ArchiveManager THE_INSTANCE = new ArchiveManager();
    private static final DateFormat THE_FORMAT = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss");

    public static ArchiveManager getArchiveManager() {
        return THE_INSTANCE;
    }

    public static DateFormat getDateFormat() {
        return THE_FORMAT;
    }

    private ArchiveManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archive(Project project, String string) {
        String string2 = project.getProjectName();
        File file = ArchiveManager.getProjectDirectoryFile(project);
        File file2 = ArchiveManager.createArchiveDir(string2, file, new Date());
        File file3 = ArchiveManager.getEmptyTempDir(string2, file2);
        ArchiveManager.moveProject(string2, file, file3);
        try {
            ArrayList arrayList = new ArrayList();
            project.save(arrayList);
            ArchiveManager.moveProject(string2, file, file2);
            ArchiveManager.createComment(file2, string);
        }
        finally {
            ArchiveManager.moveProject(string2, file3, file);
            file3.delete();
        }
    }

    private static File getProjectDirectoryFile(Project project) {
        URI uRI = project.getProjectURI();
        return uRI == null ? null : new File(uRI).getParentFile();
    }

    private static File createArchiveDir(String string, File file, Date date) {
        File file2 = ArchiveManager.getArchiveDir(string, file, date);
        file2.mkdirs();
        return file2;
    }

    private static File getArchiveDir(String string, File file, Date date) {
        File file2 = ArchiveManager.getMainArchiveDir(string, file);
        return new File(file2, ArchiveManager.getTimestamp(date));
    }

    private static File getMainArchiveDir(String string, File file) {
        File file2 = new File(file, string + ".parc");
        file2.mkdir();
        return file2;
    }

    private static void moveProject(String string, File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                File file3 = fileArray[i];
                if (!file3.isFile() || !(string2 = file3.getName()).startsWith(string)) continue;
                File file4 = new File(file2, string2);
                file3.renameTo(file4);
            }
        }
    }

    private static File getEmptyTempDir(String string, File file) {
        File[] fileArray;
        File file2 = new File(file, "temp");
        boolean bl = file2.mkdir();
        if (!bl && (fileArray = file2.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
        return file2;
    }

    public Collection getArchiveRecords(Project project) {
        ArrayList<ArchiveRecord> arrayList = new ArrayList<ArchiveRecord>();
        File[] fileArray = ArchiveManager.getMainArchiveDir(project.getProjectName(), ArchiveManager.getProjectDirectoryFile(project)).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(new ArchiveRecord(fileArray[i], ArchiveManager.getComment(fileArray[i])));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project revertToVersion(Project project, Date date) {
        Project project2 = null;
        String string = project.getProjectName();
        File file = ArchiveManager.getProjectDirectoryFile(project);
        File file2 = ArchiveManager.getArchiveDir(string, file, date);
        File file3 = ArchiveManager.getEmptyTempDir(string, file2);
        ArchiveManager.moveProject(string, file, file3);
        ArchiveManager.moveProject(string, file2, file);
        try {
            ArrayList arrayList = new ArrayList();
            project2 = Project.loadProjectFromURI(project.getProjectURI(), arrayList);
        }
        finally {
            ArchiveManager.moveProject(string, file, file2);
            ArchiveManager.moveProject(string, file3, file);
            file3.delete();
        }
        return project2;
    }

    private static String getTimestamp(Date date) {
        return THE_FORMAT.format(date);
    }

    private static String getComment(File file) {
        String string = null;
        File file2 = ArchiveManager.getCommentFile(file);
        if (file2 != null) {
            try {
                BufferedReader bufferedReader = FileUtilities.createBufferedReader(file2);
                string = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static File getCommentFile(File file) {
        return new File(file, "comment.txt");
    }

    private static void createComment(File file, String string) {
        if (string != null && string.length() > 0) {
            File file2 = ArchiveManager.getCommentFile(file);
            try {
                PrintWriter printWriter = FileUtilities.createPrintWriter(file2, false);
                printWriter.println(string);
                printWriter.close();
            }
            catch (Exception exception) {
                Log.getLogger().warning(exception.toString());
            }
        }
    }
}

